<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditieInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met edities
 * @subpackage Structs
 */
class EditieInfoV4 extends AbstractStructBase
{
    /**
     * The editie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met edities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\EditieV4[]
     */
    public $editie;
    /**
     * Constructor method for EditieInfoV4
     * @uses EditieInfoV4::setEditie()
     * @param \StructType\EditieV4[] $editie
     */
    public function __construct(array $editie = array())
    {
        $this
            ->setEditie($editie);
    }
    /**
     * Get editie value
     * @return \StructType\EditieV4[]|null
     */
    public function getEditie()
    {
        return $this->editie;
    }
    /**
     * Set editie value
     * @throws \InvalidArgumentException
     * @param \StructType\EditieV4[] $editie
     * @return \StructType\EditieInfoV4
     */
    public function setEditie(array $editie = array())
    {
        foreach ($editie as $editieInfoV4EditieItem) {
            // validation for constraint: itemType
            if (!$editieInfoV4EditieItem instanceof \StructType\EditieV4) {
                throw new \InvalidArgumentException(sprintf('The editie property can only contain items of \StructType\EditieV4, "%s" given', is_object($editieInfoV4EditieItem) ? get_class($editieInfoV4EditieItem) : gettype($editieInfoV4EditieItem)), __LINE__);
            }
        }
        $this->editie = $editie;
        return $this;
    }
    /**
     * Add item to editie value
     * @throws \InvalidArgumentException
     * @param \StructType\EditieV4 $item
     * @return \StructType\EditieInfoV4
     */
    public function addToEditie(\StructType\EditieV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditieV4) {
            throw new \InvalidArgumentException(sprintf('The editie property can only contain items of \StructType\EditieV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->editie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditieInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
