<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditcardV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Creditcard object.
 * @subpackage Structs
 */
class CreditcardV4 extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - documentation: CustomerId van de creditcard t.b.v. incasso op de creditcard bij de PSP
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $customerId;
    /**
     * The kaartHouder
     * Meta informations extracted from the WSDL
     * - documentation: De naam van de kaarthouder van de creditcard
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $kaartHouder;
    /**
     * The kaartNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het nummer van de creditcard (uit veiligheidsoverwegingen alleen de laatste 4 cijfers)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $kaartNummer;
    /**
     * The kaartSecurityType
     * Meta informations extracted from the WSDL
     * - documentation: Security type van de creditcard (bijv. 3dsecure)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $kaartSecurityType;
    /**
     * The kaartLabel
     * Meta informations extracted from the WSDL
     * - documentation: Label van de creditcard (de naam van de creditcardmaatschappij)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $kaartLabel;
    /**
     * The kaartExpiryDate
     * Meta informations extracted from the WSDL
     * - documentation: De datum waarop de geldigheid van de creditcard verloopt
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kaartExpiryDate;
    /**
     * Constructor method for CreditcardV4
     * @uses CreditcardV4::setCustomerId()
     * @uses CreditcardV4::setKaartHouder()
     * @uses CreditcardV4::setKaartNummer()
     * @uses CreditcardV4::setKaartSecurityType()
     * @uses CreditcardV4::setKaartLabel()
     * @uses CreditcardV4::setKaartExpiryDate()
     * @param string $customerId
     * @param string $kaartHouder
     * @param string $kaartNummer
     * @param string $kaartSecurityType
     * @param string $kaartLabel
     * @param string $kaartExpiryDate
     */
    public function __construct($customerId = null, $kaartHouder = null, $kaartNummer = null, $kaartSecurityType = null, $kaartLabel = null, $kaartExpiryDate = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setKaartHouder($kaartHouder)
            ->setKaartNummer($kaartNummer)
            ->setKaartSecurityType($kaartSecurityType)
            ->setKaartLabel($kaartLabel)
            ->setKaartExpiryDate($kaartExpiryDate);
    }
    /**
     * Get customerId value
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \StructType\CreditcardV4
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerId) && strlen($customerId) > 255) || (is_array($customerId) && count($customerId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($customerId) ? strlen($customerId) : count($customerId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($customerId) && strlen($customerId) < 1) || (is_array($customerId) && count($customerId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get kaartHouder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartHouder()
    {
        return isset($this->kaartHouder) ? $this->kaartHouder : null;
    }
    /**
     * Set kaartHouder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartHouder
     * @return \StructType\CreditcardV4
     */
    public function setKaartHouder($kaartHouder = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kaartHouder) && strlen($kaartHouder) > 255) || (is_array($kaartHouder) && count($kaartHouder) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kaartHouder) ? strlen($kaartHouder) : count($kaartHouder)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kaartHouder) && !is_string($kaartHouder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kaartHouder)), __LINE__);
        }
        if (is_null($kaartHouder) || (is_array($kaartHouder) && empty($kaartHouder))) {
            unset($this->kaartHouder);
        } else {
            $this->kaartHouder = $kaartHouder;
        }
        return $this;
    }
    /**
     * Get kaartNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartNummer()
    {
        return isset($this->kaartNummer) ? $this->kaartNummer : null;
    }
    /**
     * Set kaartNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartNummer
     * @return \StructType\CreditcardV4
     */
    public function setKaartNummer($kaartNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kaartNummer) && strlen($kaartNummer) > 255) || (is_array($kaartNummer) && count($kaartNummer) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kaartNummer) ? strlen($kaartNummer) : count($kaartNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kaartNummer) && !is_string($kaartNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kaartNummer)), __LINE__);
        }
        if (is_null($kaartNummer) || (is_array($kaartNummer) && empty($kaartNummer))) {
            unset($this->kaartNummer);
        } else {
            $this->kaartNummer = $kaartNummer;
        }
        return $this;
    }
    /**
     * Get kaartSecurityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartSecurityType()
    {
        return isset($this->kaartSecurityType) ? $this->kaartSecurityType : null;
    }
    /**
     * Set kaartSecurityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartSecurityType
     * @return \StructType\CreditcardV4
     */
    public function setKaartSecurityType($kaartSecurityType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kaartSecurityType) && strlen($kaartSecurityType) > 50) || (is_array($kaartSecurityType) && count($kaartSecurityType) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($kaartSecurityType) ? strlen($kaartSecurityType) : count($kaartSecurityType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kaartSecurityType) && !is_string($kaartSecurityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kaartSecurityType)), __LINE__);
        }
        if (is_null($kaartSecurityType) || (is_array($kaartSecurityType) && empty($kaartSecurityType))) {
            unset($this->kaartSecurityType);
        } else {
            $this->kaartSecurityType = $kaartSecurityType;
        }
        return $this;
    }
    /**
     * Get kaartLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartLabel()
    {
        return isset($this->kaartLabel) ? $this->kaartLabel : null;
    }
    /**
     * Set kaartLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartLabel
     * @return \StructType\CreditcardV4
     */
    public function setKaartLabel($kaartLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kaartLabel) && strlen($kaartLabel) > 255) || (is_array($kaartLabel) && count($kaartLabel) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kaartLabel) ? strlen($kaartLabel) : count($kaartLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kaartLabel) && !is_string($kaartLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kaartLabel)), __LINE__);
        }
        if (is_null($kaartLabel) || (is_array($kaartLabel) && empty($kaartLabel))) {
            unset($this->kaartLabel);
        } else {
            $this->kaartLabel = $kaartLabel;
        }
        return $this;
    }
    /**
     * Get kaartExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartExpiryDate()
    {
        return isset($this->kaartExpiryDate) ? $this->kaartExpiryDate : null;
    }
    /**
     * Set kaartExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartExpiryDate
     * @return \StructType\CreditcardV4
     */
    public function setKaartExpiryDate($kaartExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($kaartExpiryDate) && !is_string($kaartExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kaartExpiryDate)), __LINE__);
        }
        if (is_null($kaartExpiryDate) || (is_array($kaartExpiryDate) && empty($kaartExpiryDate))) {
            unset($this->kaartExpiryDate);
        } else {
            $this->kaartExpiryDate = $kaartExpiryDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditcardV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
