<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerhuizingResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error2: Het land is niet gevonden | error5: De relatie is niet gevonden | error6: Mutaties moeten in de toekomst liggen | error7: Adrestype is niet bekend | error19: Er is geen relatie opgegeven | error30: De adresgegevens zijn niet
 * compleet | error32: De adresgegevens ontbreken | error66: De provincie is niet gevonden | error69: De provincie is niet gekoppeld aan het land | error72: Voor een provincie is een land verplicht | error81: Het adres is niet gevonden in de
 * postcodetabel | error124: Bij een verhuizing is een ingangsdatum verplicht | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid | error401: Verhuizing is niet toegestaan voor dit abonnement | error402:
 * Levering in het buitenland niet toegestaan voor dit abonnement
 * @subpackage Structs
 */
class CreateVerhuizingResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The datumIngang
     * Meta informations extracted from the WSDL
     * - documentation: Daadwerkelijke ingangsdatum van de vakantieregeling. Indien een ingangsdatum opgegeven is die kleiner is dan de verschijningsdatum van een van de actieve abonnementen van de relatie wordt de eerste verschijningsdatum als ingangsdatum
     * genomen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumIngang;
    /**
     * The relNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van gebruikte relatie (kan afwijken van relNo input in geval van ontdubbelde relatie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die de aangemaakte verhuizing uniek identificeert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * Constructor method for createVerhuizingResponse
     * @uses CreateVerhuizingResponse::setRequestTag()
     * @uses CreateVerhuizingResponse::setDatumIngang()
     * @uses CreateVerhuizingResponse::setRelNoResult()
     * @uses CreateVerhuizingResponse::setToekMutNo()
     * @param string $requestTag
     * @param string $datumIngang
     * @param int $relNoResult
     * @param int $toekMutNo
     */
    public function __construct($requestTag = null, $datumIngang = null, $relNoResult = null, $toekMutNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setDatumIngang($datumIngang)
            ->setRelNoResult($relNoResult)
            ->setToekMutNo($toekMutNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVerhuizingResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get datumIngang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumIngang()
    {
        return isset($this->datumIngang) ? $this->datumIngang : null;
    }
    /**
     * Set datumIngang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumIngang
     * @return \StructType\CreateVerhuizingResponse
     */
    public function setDatumIngang($datumIngang = null)
    {
        // validation for constraint: string
        if (!is_null($datumIngang) && !is_string($datumIngang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumIngang)), __LINE__);
        }
        if (is_null($datumIngang) || (is_array($datumIngang) && empty($datumIngang))) {
            unset($this->datumIngang);
        } else {
            $this->datumIngang = $datumIngang;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \StructType\CreateVerhuizingResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoResult)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoResult, strpos($relNoResult, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoResult) && !is_numeric($relNoResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoResult)), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
    /**
     * Get toekMutNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToekMutNo()
    {
        return isset($this->toekMutNo) ? $this->toekMutNo : null;
    }
    /**
     * Set toekMutNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toekMutNo
     * @return \StructType\CreateVerhuizingResponse
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($toekMutNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toekMutNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($toekMutNo, strpos($toekMutNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($toekMutNo) && !is_numeric($toekMutNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toekMutNo)), __LINE__);
        }
        if (is_null($toekMutNo) || (is_array($toekMutNo) && empty($toekMutNo))) {
            unset($this->toekMutNo);
        } else {
            $this->toekMutNo = $toekMutNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVerhuizingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
