<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandR1nawR2noResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error5: Er is geen relatie gevonden met het relatienummer van relatie 1 | error19: Er is geen relatienummer van relatie 1 opgegeven | error21: Er is geen relatie gevonden met het relatienummer van relatie 2 | error37: Er is geen
 * relatienummer van relatie 2 opgegeven | error132: Relatie 2 is niet gevonden | error133: Er is geen relatie 2 opgegeven | error134: Er is geen verbandCode opgegeven | error135: Er is geen verband gevonden met de opgegeven verbandCode | error136: Het
 * land voor relatie 1 is niet gevonden | error140: Voor relatie 1 ontbreekt de achternaam | error141: Voor relatie 1 ontbreken adresgegevens | error142: Het adres van relatie 1 is incompleet | error143: Het e-mail adres van relatie 1 voldoet niet aan
 * de eisen | error144: Het telefoonnummer van relatie 1 is niet geldig | error145: Het mobiele telefoonnummer voor relatie 1 is niet geldig | error146: De provincie voor relatie 1 is niet gevonden | error147: De provincie voor relatie 1 is niet
 * gekoppeld aan het land | error148: Voor de provincie voor relatie 1 is een land verplicht | error149: Titulatuur voor relatie 1 is niet gevonden | error150: Het adres voor relatie 1 is niet gevonden in de postcodetabel | error151: Het opgegeven
 * geslacht voor relatie 1 is niet geldig | error170: Er bestaat al een relatieverband tussen relatie 1 en 2 met de opgegeven verbandcode | error228: Het IBAN nummer van Relatie 1 is ongeldig | error229: De BIC code van Relatie 1 is ongeldig | error230:
 * Bij Relatie 1 dient het IBAN nummer samen met de BIC code opgegeven te worden | error231: De bij Relatie 1 opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error604: Er zijn meerdere kandidaten gevonden voor relatie 1
 * @subpackage Structs
 */
class CreateVerbandR1nawR2noResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The isNieuweRelatieRel1
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of Relatie 1 een nieuwe relatie is of dat er een bestaande relatie gebruikt is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatieRel1;
    /**
     * The relNoRel1
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van de nieuwe of bestaande relatie van Relatie 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1;
    /**
     * The relNoRel2Result
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van Relatie 2. (kan afwijken van relNoRel2 input in geval van ontdubbelde relatie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel2Result;
    /**
     * The verbandNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die het verband tussen Relatie 1 en Relatie 2 uniek identificeert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * Constructor method for createVerbandR1nawR2noResponse
     * @uses CreateVerbandR1nawR2noResponse::setRequestTag()
     * @uses CreateVerbandR1nawR2noResponse::setIsNieuweRelatieRel1()
     * @uses CreateVerbandR1nawR2noResponse::setRelNoRel1()
     * @uses CreateVerbandR1nawR2noResponse::setRelNoRel2Result()
     * @uses CreateVerbandR1nawR2noResponse::setVerbandNo()
     * @param string $requestTag
     * @param bool $isNieuweRelatieRel1
     * @param int $relNoRel1
     * @param int $relNoRel2Result
     * @param int $verbandNo
     */
    public function __construct($requestTag = null, $isNieuweRelatieRel1 = null, $relNoRel1 = null, $relNoRel2Result = null, $verbandNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setIsNieuweRelatieRel1($isNieuweRelatieRel1)
            ->setRelNoRel1($relNoRel1)
            ->setRelNoRel2Result($relNoRel2Result)
            ->setVerbandNo($verbandNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVerbandR1nawR2noResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatieRel1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatieRel1()
    {
        return isset($this->isNieuweRelatieRel1) ? $this->isNieuweRelatieRel1 : null;
    }
    /**
     * Set isNieuweRelatieRel1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatieRel1
     * @return \StructType\CreateVerbandR1nawR2noResponse
     */
    public function setIsNieuweRelatieRel1($isNieuweRelatieRel1 = null)
    {
        if (is_null($isNieuweRelatieRel1) || (is_array($isNieuweRelatieRel1) && empty($isNieuweRelatieRel1))) {
            unset($this->isNieuweRelatieRel1);
        } else {
            $this->isNieuweRelatieRel1 = $isNieuweRelatieRel1;
        }
        return $this;
    }
    /**
     * Get relNoRel1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel1()
    {
        return isset($this->relNoRel1) ? $this->relNoRel1 : null;
    }
    /**
     * Set relNoRel1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel1
     * @return \StructType\CreateVerbandR1nawR2noResponse
     */
    public function setRelNoRel1($relNoRel1 = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoRel1) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoRel1)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoRel1, strpos($relNoRel1, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoRel1) && !is_numeric($relNoRel1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoRel1)), __LINE__);
        }
        if (is_null($relNoRel1) || (is_array($relNoRel1) && empty($relNoRel1))) {
            unset($this->relNoRel1);
        } else {
            $this->relNoRel1 = $relNoRel1;
        }
        return $this;
    }
    /**
     * Get relNoRel2Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel2Result()
    {
        return isset($this->relNoRel2Result) ? $this->relNoRel2Result : null;
    }
    /**
     * Set relNoRel2Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel2Result
     * @return \StructType\CreateVerbandR1nawR2noResponse
     */
    public function setRelNoRel2Result($relNoRel2Result = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoRel2Result) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoRel2Result)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoRel2Result, strpos($relNoRel2Result, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoRel2Result) && !is_numeric($relNoRel2Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoRel2Result)), __LINE__);
        }
        if (is_null($relNoRel2Result) || (is_array($relNoRel2Result) && empty($relNoRel2Result))) {
            unset($this->relNoRel2Result);
        } else {
            $this->relNoRel2Result = $relNoRel2Result;
        }
        return $this;
    }
    /**
     * Get verbandNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVerbandNo()
    {
        return isset($this->verbandNo) ? $this->verbandNo : null;
    }
    /**
     * Set verbandNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $verbandNo
     * @return \StructType\CreateVerbandR1nawR2noResponse
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($verbandNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $verbandNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($verbandNo, strpos($verbandNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($verbandNo) && !is_numeric($verbandNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($verbandNo)), __LINE__);
        }
        if (is_null($verbandNo) || (is_array($verbandNo) && empty($verbandNo))) {
            unset($this->verbandNo);
        } else {
            $this->verbandNo = $verbandNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVerbandR1nawR2noResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
