<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVakantieRegelingResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Het abonnement is niet gevonden | error2: Het land is niet gevonden | error6: Mutaties moeten in de toekomst liggen | error12: Er is geen abonnement opgegeven | error28: Bij een relatie is een naam verplicht | error30: De
 * adresgegevens zijn niet compleet | error31: Het e-mail adres voldoet niet aan de eisen | error32: De adresgegevens ontbreken | error38: Het telefoonnummer is niet geldig | error59: Er zijn meerdere kandidaten gevonden | error62: De titulatuur is niet
 * bekend | error63: Het mobiele telefoonnummer is niet geldig | error66: De provincie is niet gevonden | error69: De provincie is niet gekoppeld aan het land | error72: Voor een provincie is een land verplicht | error81: Het adres is niet gevonden in
 * de postcodetabel | error86: De einddatum mag niet voor de ingangsdatum van de vakantieregeling liggen | error87: Het opgegeven regelingtype voor de vakantieregeling is niet bekend | error88: De opgegeven geboortedatum is niet geldig | error104: Het
 * opgegeven geslacht is niet geldig | error110: Onderbreking is niet toegestaan, het abonnement heeft een einddatum | error111: Bij een vakantieregeling is een ingangsdatum verplicht | error112: Bij een vakantieregeling is een einddatum verplicht |
 * error113: Ongeldige lengte voor de vakantieregeling opgegeven | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid | error189: Regeling is niet toegestaan, de ingangsdatum ligt voor de startdatum van het
 * abonnement | error190: Regeling is niet toegestaan, de einddatum ligt na de stopdatum van het abonnement | error265: Doorgifte van een tijdelijke afdelingsnaam alleen toegestaan bij regeling type 4 (Vakantieadres) | error502: Vakantieregeling is niet
 * toegestaan voor dit type abonnement | error503: De onderbreking ligt te dicht bij een voorgaande of opvolgende onderbreking | error504: Bij de abonnementsoort ontbreken instellingen om te bepalen of de vakantieregeling toegestaan is | error505: De
 * instellingen bij de abonnementsoort voor de vakantieregeling zijn ongeldig | error506: Levering in het buitenland niet toegestaan voor dit abonnement | error507: In de opgegeven periode staat al een onderbreking genoteerd
 * @subpackage Structs
 */
class CreateVakantieRegelingResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The datumIngang
     * Meta informations extracted from the WSDL
     * - documentation: Daadwerkelijke ingangsdatum van de vakantieregeling. Indien een ingangsdatum opgegeven is die kleiner is dan de verschijningsdatum van het abonnement (of abonnementen in geval van een pakket) deze verschijningsdatum als ingangsdatum
     * genomen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumIngang;
    /**
     * The isNieuweRelatie
     * Meta informations extracted from the WSDL
     * - documentation: [vakantieRegelingType = 5 (doorsturen)] Geeft aan of er een nieuwe relatie is aangemaakt of dat er een bestaande relatie gebruikt is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatie;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: [vakantieRegelingType = 5 (doorsturen)] Het relatienummer van de relatie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die de vakantieregeling uniek identificeert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * Constructor method for createVakantieRegelingResponse
     * @uses CreateVakantieRegelingResponse::setRequestTag()
     * @uses CreateVakantieRegelingResponse::setDatumIngang()
     * @uses CreateVakantieRegelingResponse::setIsNieuweRelatie()
     * @uses CreateVakantieRegelingResponse::setRelNo()
     * @uses CreateVakantieRegelingResponse::setToekMutNo()
     * @param string $requestTag
     * @param string $datumIngang
     * @param bool $isNieuweRelatie
     * @param int $relNo
     * @param int $toekMutNo
     */
    public function __construct($requestTag = null, $datumIngang = null, $isNieuweRelatie = null, $relNo = null, $toekMutNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setDatumIngang($datumIngang)
            ->setIsNieuweRelatie($isNieuweRelatie)
            ->setRelNo($relNo)
            ->setToekMutNo($toekMutNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVakantieRegelingResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get datumIngang value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumIngang()
    {
        return isset($this->datumIngang) ? $this->datumIngang : null;
    }
    /**
     * Set datumIngang value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumIngang
     * @return \StructType\CreateVakantieRegelingResponse
     */
    public function setDatumIngang($datumIngang = null)
    {
        // validation for constraint: string
        if (!is_null($datumIngang) && !is_string($datumIngang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumIngang)), __LINE__);
        }
        if (is_null($datumIngang) || (is_array($datumIngang) && empty($datumIngang))) {
            unset($this->datumIngang);
        } else {
            $this->datumIngang = $datumIngang;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatie()
    {
        return isset($this->isNieuweRelatie) ? $this->isNieuweRelatie : null;
    }
    /**
     * Set isNieuweRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatie
     * @return \StructType\CreateVakantieRegelingResponse
     */
    public function setIsNieuweRelatie($isNieuweRelatie = null)
    {
        if (is_null($isNieuweRelatie) || (is_array($isNieuweRelatie) && empty($isNieuweRelatie))) {
            unset($this->isNieuweRelatie);
        } else {
            $this->isNieuweRelatie = $isNieuweRelatie;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\CreateVakantieRegelingResponse
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get toekMutNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToekMutNo()
    {
        return isset($this->toekMutNo) ? $this->toekMutNo : null;
    }
    /**
     * Set toekMutNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toekMutNo
     * @return \StructType\CreateVakantieRegelingResponse
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($toekMutNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $toekMutNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($toekMutNo, strpos($toekMutNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($toekMutNo) && !is_numeric($toekMutNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toekMutNo)), __LINE__);
        }
        if (is_null($toekMutNo) || (is_array($toekMutNo) && empty($toekMutNo))) {
            unset($this->toekMutNo);
        } else {
            $this->toekMutNo = $toekMutNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVakantieRegelingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
