<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboDebNoAboNawRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanmaken van een nieuw abonnement voor een relatie, waarbij de NAW gegevens van de abonnee en het relatienummer van de debiteur meegegeven kan worden.
 * @subpackage Structs
 */
class CreateAboDebNoAboNawRequest extends AbstractStructBase
{
    /**
     * The relNoDeb
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de betaler.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoDeb;
    /**
     * The persoonsObjectAbo
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens voor de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\PersoonsObjectV4
     */
    public $persoonsObjectAbo;
    /**
     * The adresObjectAbo
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens voor de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectAbo;
    /**
     * The aboObject
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsgegevens.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AboObjectV4
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The geenControleLopendAbo
     * Meta informations extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie en abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createAboDebNoAboNawRequest
     * @uses CreateAboDebNoAboNawRequest::setRelNoDeb()
     * @uses CreateAboDebNoAboNawRequest::setPersoonsObjectAbo()
     * @uses CreateAboDebNoAboNawRequest::setAdresObjectAbo()
     * @uses CreateAboDebNoAboNawRequest::setAboObject()
     * @uses CreateAboDebNoAboNawRequest::setRequestTag()
     * @uses CreateAboDebNoAboNawRequest::setGeenControleLopendAbo()
     * @uses CreateAboDebNoAboNawRequest::setCanCreate()
     * @param int $relNoDeb
     * @param \StructType\PersoonsObjectV4 $persoonsObjectAbo
     * @param \StructType\AdresObjectV4 $adresObjectAbo
     * @param \StructType\AboObjectV4 $aboObject
     * @param string $requestTag
     * @param bool $geenControleLopendAbo
     * @param bool $canCreate
     */
    public function __construct($relNoDeb = null, \StructType\PersoonsObjectV4 $persoonsObjectAbo = null, \StructType\AdresObjectV4 $adresObjectAbo = null, \StructType\AboObjectV4 $aboObject = null, $requestTag = null, $geenControleLopendAbo = null, $canCreate = null)
    {
        $this
            ->setRelNoDeb($relNoDeb)
            ->setPersoonsObjectAbo($persoonsObjectAbo)
            ->setAdresObjectAbo($adresObjectAbo)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNoDeb value
     * @return int
     */
    public function getRelNoDeb()
    {
        return $this->relNoDeb;
    }
    /**
     * Set relNoDeb value
     * @param int $relNoDeb
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setRelNoDeb($relNoDeb = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoDeb) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoDeb)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoDeb, strpos($relNoDeb, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoDeb) && !is_numeric($relNoDeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoDeb)), __LINE__);
        }
        $this->relNoDeb = $relNoDeb;
        return $this;
    }
    /**
     * Get persoonsObjectAbo value
     * @return \StructType\PersoonsObjectV4
     */
    public function getPersoonsObjectAbo()
    {
        return $this->persoonsObjectAbo;
    }
    /**
     * Set persoonsObjectAbo value
     * @param \StructType\PersoonsObjectV4 $persoonsObjectAbo
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setPersoonsObjectAbo(\StructType\PersoonsObjectV4 $persoonsObjectAbo = null)
    {
        $this->persoonsObjectAbo = $persoonsObjectAbo;
        return $this;
    }
    /**
     * Get adresObjectAbo value
     * @return \StructType\AdresObjectV4
     */
    public function getAdresObjectAbo()
    {
        return $this->adresObjectAbo;
    }
    /**
     * Set adresObjectAbo value
     * @param \StructType\AdresObjectV4 $adresObjectAbo
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setAdresObjectAbo(\StructType\AdresObjectV4 $adresObjectAbo = null)
    {
        $this->adresObjectAbo = $adresObjectAbo;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \StructType\AboObjectV4
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \StructType\AboObjectV4 $aboObject
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setAboObject(\StructType\AboObjectV4 $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAboDebNoAboNawRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
