<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboDebNawAboNawResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error3: De betaalwijze is niet bekend | error4: Bij automatische incasso is een rekeningnummer verplicht | error16: De editie is niet gevonden | error23: De premium voor de abonnee is niet gevonden | error26: Het opgegeven
 * rekeningnummer voldoet niet | error33: Geef of een abonnementsoort- of een pakketcode op | error34: De actie is niet gevonden | error36: De herkomst is niet bekend | error39: Het land voor de abonnee is niet gevonden | error43: Voor de abonnee
 * ontbreekt de achternaam | error44: Voor de abonnee ontbreken adresgegevens | error45: Het adres van de abonnee is incompleet | error46: Het e-mail adres van de abonnee voldoet niet aan de eisen | error47: Het telefoonnummer van de abonnee is niet
 * geldig | error48: Het land voor de debiteur is niet gevonden | error51: Voor de debiteur ontbreekt de achternaam | error52: Voor de debiteur ontbreken adresgegevens | error53: Het adres van de debiteur is incompleet | error54: Het e-mail adres van de
 * debiteur voldoet niet aan de eisen | error55: Het telefoonnummer van de debiteur is niet geldig | error56: De abonnementsoort is niet actief | error57: De actie is niet actief | error58: De premium voor de abonnee is niet actief | error60: Er zijn
 * meerdere kandidaten gevonden voor de abonnee | error61: Er zijn meerdere kandidaten gevonden voor de debiteur | error64: Het mobiele telefoonnummer voor de abonnee is niet geldig | error65: Het mobiele telefoonnummer voor de debiteur is niet geldig |
 * error67: De provincie voor de abonnee is niet gevonden | error68: De provincie voor de debiteur is niet gevonden | error70: De provincie voor de abonnee is niet gekoppeld aan het land | error71: De provincie voor de debiteur is niet gekoppeld aan het
 * land | error73: Voor de provincie voor de abonnee is een land verplicht | error74: Voor de provincie voor de debiteur is een land verplicht | error75: Titulatuur voor de abonnee is niet gevonden | error76: Titulatuur voor de debiteur is niet gevonden
 * | error82: Het adres voor de abonnee is niet gevonden in de postcodetabel | error83: Het adres voor de debiteur is niet gevonden in de postcodetabel | error84: Voor de abonnee is al een actief abonnement met dezelfde uitgave aanwezig (deze melding
 * kan dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request) | error88: Het opgegeven pakket is niet bekend | error89: Het opgegeven pakket is niet actief | error91: De premium voor de debiteur is niet actief | error92: De
 * abonnementsoort is niet bekend | error95: De ingangsdatum van de actie is nog niet ingegaan | error96: De einddatum van de actie is verstreken | error97: De premium voor de abonnee is niet gekoppeld aan de propositie | error98: De premium voor de
 * debiteur is niet gekoppeld aan de propositie | error105: Het opgegeven geslacht voor de abonnee is niet geldig | error106: Het opgegeven geslacht voor de debiteur is niet geldig | error107: Het abonnement kan niet aangemaakt worden. Voor de debiteur
 * geldt een leververbod | error127: De abonnementsoort is niet gekoppeld aan de actie | error128: Het pakket is niet gekoppeld aan de actie | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid | error131: Een
 * betaalwijze anders dan incasso is niet toegestaan voor dit abonnement | error215: Het IBAN nummer is ongeldig | error216: De BIC code is ongeldig | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplicht | error218: Het
 * IBAN nummer dient samen met de BIC code opgegeven te worden | error219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error220: Het IBAN nummer van de abonnee is ongeldig | error221: De BIC code van de abonnee is ongeldig |
 * error222: Bij de abonnee dient het IBAN nummer samen met de BIC code opgegeven te worden | error223: De bij de abonnee opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error224: Het IBAN nummer van de debiteur is ongeldig | error225: De
 * BIC code van de debiteur is ongeldig | error226: Bij de debiteur dient het IBAN nummer samen met de BIC code opgegeven te worden | error227: De bij de debiteur opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error256: De proposie is
 * niet gevonden | error257: De propositie is niet actief | error258: Op basis van de opgegeven abosoort/pakket/propositiecode en actiecode zijn meerdere proposities gevonden | error259: De opgegeven vrije code 3 is niet bekend | error260: Een
 * propositiecode dient in combinatie met een actiecode opgegeven te worden | error261: De opgegeven vrije code 1 is niet bekend | error262: De opgegeven vrije code 2 is niet bekend | error263: De opgegeven vrije code 4 is niet bekend | error264: Bij
 * betaalwijze creditcard zijn gegevens van de creditcard verplicht | error265: Een betaalwijze anders dan factuur per mail is niet toegestaan voor dit abonnement | error701: Bij een abonnement is een herkomst verplicht | error702: Bij een abonnement is
 * een actie verplicht
 * @subpackage Structs
 */
class CreateAboDebNawAboNawResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het aangemaakte abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The isNieuweRelatieAbo
     * Meta informations extracted from the WSDL
     * - documentation: Terugkoppeling over het aanmaken van een nieuwe abonnee-relatie of het gebruiken van bestaande. false=Een bestaande relatie is gevonden, true=Een nieuwe relatie is aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatieAbo;
    /**
     * The isNieuweRelatieDeb
     * Meta informations extracted from the WSDL
     * - documentation: Terugkoppeling over het aanmaken van een nieuwe debiteur-relatie of het gebruiken van bestaande. false=Een bestaande relatie is gevonden, true=Een nieuwe relatie is aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatieDeb;
    /**
     * The ingangsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Eerst mogelijke ingangsdatum van het abonnement. Afhankelijk van het type abonnementsoort is dit de verschijningsdatum van de eerstvolgende editie of de eerstvolgende datum waarop het abonnement kan starten, rekeninghoudend met zon-
     * en feestdagen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ingangsDatum;
    /**
     * The relNoAboResult
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de aangemaakte / bijgewerkte abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoAboResult;
    /**
     * The relNoDebResult
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de aangemaakte / bijgewerkte debiteur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoDebResult;
    /**
     * The machtigingsKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Door Zeno aangemaakt machtigingskenmerk in geval van betaalwijze SEPA incasso.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 35
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * Constructor method for createAboDebNawAboNawResponse
     * @uses CreateAboDebNawAboNawResponse::setRequestTag()
     * @uses CreateAboDebNawAboNawResponse::setAboNo()
     * @uses CreateAboDebNawAboNawResponse::setIsNieuweRelatieAbo()
     * @uses CreateAboDebNawAboNawResponse::setIsNieuweRelatieDeb()
     * @uses CreateAboDebNawAboNawResponse::setIngangsDatum()
     * @uses CreateAboDebNawAboNawResponse::setRelNoAboResult()
     * @uses CreateAboDebNawAboNawResponse::setRelNoDebResult()
     * @uses CreateAboDebNawAboNawResponse::setMachtigingsKenmerk()
     * @param string $requestTag
     * @param int $aboNo
     * @param bool $isNieuweRelatieAbo
     * @param bool $isNieuweRelatieDeb
     * @param string $ingangsDatum
     * @param int $relNoAboResult
     * @param int $relNoDebResult
     * @param string $machtigingsKenmerk
     */
    public function __construct($requestTag = null, $aboNo = null, $isNieuweRelatieAbo = null, $isNieuweRelatieDeb = null, $ingangsDatum = null, $relNoAboResult = null, $relNoDebResult = null, $machtigingsKenmerk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setIsNieuweRelatieAbo($isNieuweRelatieAbo)
            ->setIsNieuweRelatieDeb($isNieuweRelatieDeb)
            ->setIngangsDatum($ingangsDatum)
            ->setRelNoAboResult($relNoAboResult)
            ->setRelNoDebResult($relNoDebResult)
            ->setMachtigingsKenmerk($machtigingsKenmerk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatieAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatieAbo()
    {
        return isset($this->isNieuweRelatieAbo) ? $this->isNieuweRelatieAbo : null;
    }
    /**
     * Set isNieuweRelatieAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatieAbo
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setIsNieuweRelatieAbo($isNieuweRelatieAbo = null)
    {
        if (is_null($isNieuweRelatieAbo) || (is_array($isNieuweRelatieAbo) && empty($isNieuweRelatieAbo))) {
            unset($this->isNieuweRelatieAbo);
        } else {
            $this->isNieuweRelatieAbo = $isNieuweRelatieAbo;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatieDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatieDeb()
    {
        return isset($this->isNieuweRelatieDeb) ? $this->isNieuweRelatieDeb : null;
    }
    /**
     * Set isNieuweRelatieDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatieDeb
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setIsNieuweRelatieDeb($isNieuweRelatieDeb = null)
    {
        if (is_null($isNieuweRelatieDeb) || (is_array($isNieuweRelatieDeb) && empty($isNieuweRelatieDeb))) {
            unset($this->isNieuweRelatieDeb);
        } else {
            $this->isNieuweRelatieDeb = $isNieuweRelatieDeb;
        }
        return $this;
    }
    /**
     * Get ingangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIngangsDatum()
    {
        return isset($this->ingangsDatum) ? $this->ingangsDatum : null;
    }
    /**
     * Set ingangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ingangsDatum
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setIngangsDatum($ingangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($ingangsDatum) && !is_string($ingangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ingangsDatum)), __LINE__);
        }
        if (is_null($ingangsDatum) || (is_array($ingangsDatum) && empty($ingangsDatum))) {
            unset($this->ingangsDatum);
        } else {
            $this->ingangsDatum = $ingangsDatum;
        }
        return $this;
    }
    /**
     * Get relNoAboResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoAboResult()
    {
        return isset($this->relNoAboResult) ? $this->relNoAboResult : null;
    }
    /**
     * Set relNoAboResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoAboResult
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setRelNoAboResult($relNoAboResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoAboResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoAboResult)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoAboResult, strpos($relNoAboResult, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoAboResult) && !is_numeric($relNoAboResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoAboResult)), __LINE__);
        }
        if (is_null($relNoAboResult) || (is_array($relNoAboResult) && empty($relNoAboResult))) {
            unset($this->relNoAboResult);
        } else {
            $this->relNoAboResult = $relNoAboResult;
        }
        return $this;
    }
    /**
     * Get relNoDebResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoDebResult()
    {
        return isset($this->relNoDebResult) ? $this->relNoDebResult : null;
    }
    /**
     * Set relNoDebResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoDebResult
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setRelNoDebResult($relNoDebResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoDebResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoDebResult)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoDebResult, strpos($relNoDebResult, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoDebResult) && !is_numeric($relNoDebResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoDebResult)), __LINE__);
        }
        if (is_null($relNoDebResult) || (is_array($relNoDebResult) && empty($relNoDebResult))) {
            unset($this->relNoDebResult);
        } else {
            $this->relNoDebResult = $relNoDebResult;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($machtigingsKenmerk) && strlen($machtigingsKenmerk) > 35) || (is_array($machtigingsKenmerk) && count($machtigingsKenmerk) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($machtigingsKenmerk) ? strlen($machtigingsKenmerk) : count($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAboDebNawAboNawResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
