<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addLicentiehouderResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Het abonnement is niet gevonden. | error5: De relatie is niet gevonden. | error12: Er is geen abonnement opgegeven. | error19: Er is geen relatie opgegeven. | error236: De opgegeven rol is niet gevonden bij de uitgave van het
 * abonnement. | error239: Het abonnement is geen licentieabonnement.
 * @subpackage Structs
 */
class AddLicentiehouderResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The licentieNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de licentie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * Constructor method for addLicentiehouderResponse
     * @uses AddLicentiehouderResponse::setRequestTag()
     * @uses AddLicentiehouderResponse::setLicentieNo()
     * @param string $requestTag
     * @param int $licentieNo
     */
    public function __construct($requestTag = null, $licentieNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLicentieNo($licentieNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\AddLicentiehouderResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get licentieNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLicentieNo()
    {
        return isset($this->licentieNo) ? $this->licentieNo : null;
    }
    /**
     * Set licentieNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $licentieNo
     * @return \StructType\AddLicentiehouderResponse
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($licentieNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $licentieNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($licentieNo, strpos($licentieNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($licentieNo) && !is_numeric($licentieNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($licentieNo)), __LINE__);
        }
        if (is_null($licentieNo) || (is_array($licentieNo) && empty($licentieNo))) {
            unset($this->licentieNo);
        } else {
            $this->licentieNo = $licentieNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddLicentiehouderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
