<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActieV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Actie object.
 * @subpackage Structs
 */
class ActieV4 extends AbstractStructBase
{
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de actie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $actieCode;
    /**
     * The omschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Korte omschrijving van de actie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $omschrijving;
    /**
     * The prijsEerstePeriode
     * Meta informations extracted from the WSDL
     * - documentation: Prijs exclusief BTW voor de eerste periode, dus met verrekening actiekorting.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $prijsEerstePeriode;
    /**
     * The prijsVervolgPeriode
     * Meta informations extracted from the WSDL
     * - documentation: Prijs exclusief BTW voor de vervolg periode.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $prijsVervolgPeriode;
    /**
     * The omschrijvingUitgebreid
     * Meta informations extracted from the WSDL
     * - documentation: Uitgebreide omschrijving van de actie voor op de website.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 2000
     * @var string
     */
    public $omschrijvingUitgebreid;
    /**
     * The aboSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de bijbehorende abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $aboSoortCode;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het bijbehorende pakket.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketCode;
    /**
     * Constructor method for ActieV4
     * @uses ActieV4::setActieCode()
     * @uses ActieV4::setOmschrijving()
     * @uses ActieV4::setPrijsEerstePeriode()
     * @uses ActieV4::setPrijsVervolgPeriode()
     * @uses ActieV4::setOmschrijvingUitgebreid()
     * @uses ActieV4::setAboSoortCode()
     * @uses ActieV4::setPakketCode()
     * @param string $actieCode
     * @param string $omschrijving
     * @param float $prijsEerstePeriode
     * @param float $prijsVervolgPeriode
     * @param string $omschrijvingUitgebreid
     * @param string $aboSoortCode
     * @param string $pakketCode
     */
    public function __construct($actieCode = null, $omschrijving = null, $prijsEerstePeriode = null, $prijsVervolgPeriode = null, $omschrijvingUitgebreid = null, $aboSoortCode = null, $pakketCode = null)
    {
        $this
            ->setActieCode($actieCode)
            ->setOmschrijving($omschrijving)
            ->setPrijsEerstePeriode($prijsEerstePeriode)
            ->setPrijsVervolgPeriode($prijsVervolgPeriode)
            ->setOmschrijvingUitgebreid($omschrijvingUitgebreid)
            ->setAboSoortCode($aboSoortCode)
            ->setPakketCode($pakketCode);
    }
    /**
     * Get actieCode value
     * @return string
     */
    public function getActieCode()
    {
        return $this->actieCode;
    }
    /**
     * Set actieCode value
     * @param string $actieCode
     * @return \StructType\ActieV4
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieCode) && strlen($actieCode) > 15) || (is_array($actieCode) && count($actieCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($actieCode) ? strlen($actieCode) : count($actieCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($actieCode) && strlen($actieCode) < 1) || (is_array($actieCode) && count($actieCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieCode)), __LINE__);
        }
        $this->actieCode = $actieCode;
        return $this;
    }
    /**
     * Get omschrijving value
     * @return string
     */
    public function getOmschrijving()
    {
        return $this->omschrijving;
    }
    /**
     * Set omschrijving value
     * @param string $omschrijving
     * @return \StructType\ActieV4
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) > 255) || (is_array($omschrijving) && count($omschrijving) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($omschrijving) ? strlen($omschrijving) : count($omschrijving)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) < 1) || (is_array($omschrijving) && count($omschrijving) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        $this->omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get prijsEerstePeriode value
     * @return float
     */
    public function getPrijsEerstePeriode()
    {
        return $this->prijsEerstePeriode;
    }
    /**
     * Set prijsEerstePeriode value
     * @param float $prijsEerstePeriode
     * @return \StructType\ActieV4
     */
    public function setPrijsEerstePeriode($prijsEerstePeriode = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($prijsEerstePeriode) && strlen(substr($prijsEerstePeriode, strpos($prijsEerstePeriode, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($prijsEerstePeriode, strpos($prijsEerstePeriode, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($prijsEerstePeriode) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsEerstePeriode)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($prijsEerstePeriode, strpos($prijsEerstePeriode, '.')))), __LINE__);
        }
        $this->prijsEerstePeriode = $prijsEerstePeriode;
        return $this;
    }
    /**
     * Get prijsVervolgPeriode value
     * @return float
     */
    public function getPrijsVervolgPeriode()
    {
        return $this->prijsVervolgPeriode;
    }
    /**
     * Set prijsVervolgPeriode value
     * @param float $prijsVervolgPeriode
     * @return \StructType\ActieV4
     */
    public function setPrijsVervolgPeriode($prijsVervolgPeriode = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($prijsVervolgPeriode) && strlen(substr($prijsVervolgPeriode, strpos($prijsVervolgPeriode, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($prijsVervolgPeriode, strpos($prijsVervolgPeriode, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($prijsVervolgPeriode) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsVervolgPeriode)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($prijsVervolgPeriode, strpos($prijsVervolgPeriode, '.')))), __LINE__);
        }
        $this->prijsVervolgPeriode = $prijsVervolgPeriode;
        return $this;
    }
    /**
     * Get omschrijvingUitgebreid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijvingUitgebreid()
    {
        return isset($this->omschrijvingUitgebreid) ? $this->omschrijvingUitgebreid : null;
    }
    /**
     * Set omschrijvingUitgebreid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijvingUitgebreid
     * @return \StructType\ActieV4
     */
    public function setOmschrijvingUitgebreid($omschrijvingUitgebreid = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijvingUitgebreid) && strlen($omschrijvingUitgebreid) > 2000) || (is_array($omschrijvingUitgebreid) && count($omschrijvingUitgebreid) > 2000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2000 element(s) or a scalar of 2000 character(s) at most, "%d" length given', is_scalar($omschrijvingUitgebreid) ? strlen($omschrijvingUitgebreid) : count($omschrijvingUitgebreid)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijvingUitgebreid) && !is_string($omschrijvingUitgebreid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijvingUitgebreid)), __LINE__);
        }
        if (is_null($omschrijvingUitgebreid) || (is_array($omschrijvingUitgebreid) && empty($omschrijvingUitgebreid))) {
            unset($this->omschrijvingUitgebreid);
        } else {
            $this->omschrijvingUitgebreid = $omschrijvingUitgebreid;
        }
        return $this;
    }
    /**
     * Get aboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortCode()
    {
        return isset($this->aboSoortCode) ? $this->aboSoortCode : null;
    }
    /**
     * Set aboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortCode
     * @return \StructType\ActieV4
     */
    public function setAboSoortCode($aboSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortCode) && strlen($aboSoortCode) > 30) || (is_array($aboSoortCode) && count($aboSoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($aboSoortCode) ? strlen($aboSoortCode) : count($aboSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortCode) && !is_string($aboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortCode)), __LINE__);
        }
        if (is_null($aboSoortCode) || (is_array($aboSoortCode) && empty($aboSoortCode))) {
            unset($this->aboSoortCode);
        } else {
            $this->aboSoortCode = $aboSoortCode;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\ActieV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActieV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
