<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementsoortV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abonnementsoort object
 * @subpackage Structs
 */
class AbonnementsoortV4 extends AbstractStructBase
{
    /**
     * The abonnementsoortNo
     * Meta informations extracted from the WSDL
     * - documentation: Interne sleutel van de abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $abonnementsoortNo;
    /**
     * The abonnementsoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The abonnementsoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $abonnementsoortNaam;
    /**
     * The abonnementsoortBetaalwijze
     * Meta informations extracted from the WSDL
     * - documentation: Betaalwijze van de abonnementsoort (0= Geen voorkeur, 1= Bij voorkeur aut. incasso, 2= Verplicht aut. incasso).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 3
     * @var int
     */
    public $abonnementsoortBetaalwijze;
    /**
     * The abonnementsoortPrijs
     * Meta informations extracted from the WSDL
     * - documentation: Prijs exclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $abonnementsoortPrijs;
    /**
     * The abonnementsoortBtwCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van BTW die van toepassing is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $abonnementsoortBtwCode;
    /**
     * The abonnementsoortBtwOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Naam van BTW die van toepassing is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $abonnementsoortBtwOmschr;
    /**
     * The abonnementsoortBtwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: BTW percentage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortBtwPercentage;
    /**
     * The abonnementsoortPeriode
     * Meta informations extracted from the WSDL
     * - documentation: Looptijd abonnement is in Edities, Jaar, Maanden, Weken of Einddatum.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $abonnementsoortPeriode;
    /**
     * The abonnementsoortAantal
     * Meta informations extracted from the WSDL
     * - documentation: Aantal periodes per abonnementsperiode.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $abonnementsoortAantal;
    /**
     * The abonnementsoortVerlenging
     * Meta informations extracted from the WSDL
     * - documentation: Automatisch verlenging (Automatisch verlengen, Niet automatisch verlengen, Overgang naar abonnement, Overgang naar Promo of Overgang naar Pakket).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $abonnementsoortVerlenging;
    /**
     * The abonnementsoortDoorlopend
     * Meta informations extracted from the WSDL
     * - documentation: Abonnement doorlopend factureren, dus niet aan het begin van het jaar Ja/Nee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $abonnementsoortDoorlopend;
    /**
     * The abonnementsoortKortPerc
     * Meta informations extracted from the WSDL
     * - documentation: Percentage korting op het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortKortPerc;
    /**
     * The abonnementsoortKortBedr
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag korting op het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortKortBedr;
    /**
     * The abonnementsoortKortIncasso
     * Meta informations extracted from the WSDL
     * - documentation: Korting bij betaling via automatische incasso.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortKortIncasso;
    /**
     * The abonnementsoortVrijeTekst1
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 1, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst1;
    /**
     * The abonnementsoortVrijeTekst2
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 2, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst2;
    /**
     * The abonnementsoortVrijeTekst3
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 3, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst3;
    /**
     * The abonnementsoortVrijeTekst4
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 4, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst4;
    /**
     * The abonnementsoortVrijeTekst5
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 5, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst5;
    /**
     * The abonnementsoortVrijeTekst6
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 6, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst6;
    /**
     * The abonnementsoortVrijeTekst7
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 7, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst7;
    /**
     * The abonnementsoortVrijeTekst8
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 8, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst8;
    /**
     * The abonnementsoortVrijeTekst9
     * Meta informations extracted from the WSDL
     * - documentation: Vrij tekst veld 9, 1800 karakters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldTekstV4
     */
    public $abonnementsoortVrijeTekst9;
    /**
     * The abonnementsoortVrijeDatum1
     * Meta informations extracted from the WSDL
     * - documentation: Vrij datum veld 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldDatumV4
     */
    public $abonnementsoortVrijeDatum1;
    /**
     * The abonnementsoortVrijeDatum2
     * Meta informations extracted from the WSDL
     * - documentation: Vrij datum veld 2.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldDatumV4
     */
    public $abonnementsoortVrijeDatum2;
    /**
     * The abonnementsoortVrijCode1
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode1;
    /**
     * The abonnementsoortVrijCode2
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 2.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode2;
    /**
     * The abonnementsoortVrijCode3
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 3.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode3;
    /**
     * The abonnementsoortVrijCode4
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 4.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode4;
    /**
     * The abonnementsoortVrijCode5
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 5.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode5;
    /**
     * The abonnementsoortVrijCode6
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 6.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode6;
    /**
     * The abonnementsoortVrijCode7
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 7.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode7;
    /**
     * The abonnementsoortVrijCode8
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 8.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode8;
    /**
     * The abonnementsoortVrijCode9
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 9.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode9;
    /**
     * The abonnementsoortVrijCode10
     * Meta informations extracted from the WSDL
     * - documentation: Vrij code veld 10.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijVeldCodeV4
     */
    public $abonnementsoortVrijCode10;
    /**
     * The abonnementsoortActief
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie abonnementsoort actief.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $abonnementsoortActief;
    /**
     * The organisatieLicentie
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie organisatie licentie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $organisatieLicentie;
    /**
     * The buitenland
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie abonnement leverbaar in het buitenland.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $buitenland;
    /**
     * Constructor method for AbonnementsoortV4
     * @uses AbonnementsoortV4::setAbonnementsoortNo()
     * @uses AbonnementsoortV4::setAbonnementsoortCode()
     * @uses AbonnementsoortV4::setAbonnementsoortNaam()
     * @uses AbonnementsoortV4::setAbonnementsoortBetaalwijze()
     * @uses AbonnementsoortV4::setAbonnementsoortPrijs()
     * @uses AbonnementsoortV4::setAbonnementsoortBtwCode()
     * @uses AbonnementsoortV4::setAbonnementsoortBtwOmschr()
     * @uses AbonnementsoortV4::setAbonnementsoortBtwPercentage()
     * @uses AbonnementsoortV4::setAbonnementsoortPeriode()
     * @uses AbonnementsoortV4::setAbonnementsoortAantal()
     * @uses AbonnementsoortV4::setAbonnementsoortVerlenging()
     * @uses AbonnementsoortV4::setAbonnementsoortDoorlopend()
     * @uses AbonnementsoortV4::setAbonnementsoortKortPerc()
     * @uses AbonnementsoortV4::setAbonnementsoortKortBedr()
     * @uses AbonnementsoortV4::setAbonnementsoortKortIncasso()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst1()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst2()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst3()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst4()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst5()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst6()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst7()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst8()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeTekst9()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeDatum1()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijeDatum2()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode1()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode2()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode3()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode4()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode5()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode6()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode7()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode8()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode9()
     * @uses AbonnementsoortV4::setAbonnementsoortVrijCode10()
     * @uses AbonnementsoortV4::setAbonnementsoortActief()
     * @uses AbonnementsoortV4::setOrganisatieLicentie()
     * @uses AbonnementsoortV4::setBuitenland()
     * @param int $abonnementsoortNo
     * @param string $abonnementsoortCode
     * @param string $abonnementsoortNaam
     * @param int $abonnementsoortBetaalwijze
     * @param float $abonnementsoortPrijs
     * @param string $abonnementsoortBtwCode
     * @param string $abonnementsoortBtwOmschr
     * @param float $abonnementsoortBtwPercentage
     * @param string $abonnementsoortPeriode
     * @param int $abonnementsoortAantal
     * @param string $abonnementsoortVerlenging
     * @param bool $abonnementsoortDoorlopend
     * @param float $abonnementsoortKortPerc
     * @param float $abonnementsoortKortBedr
     * @param float $abonnementsoortKortIncasso
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst1
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst2
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst3
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst4
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst5
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst6
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst7
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst8
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst9
     * @param \StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum1
     * @param \StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum2
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode1
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode2
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode3
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode4
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode5
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode6
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode7
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode8
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode9
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode10
     * @param bool $abonnementsoortActief
     * @param bool $organisatieLicentie
     * @param bool $buitenland
     */
    public function __construct($abonnementsoortNo = null, $abonnementsoortCode = null, $abonnementsoortNaam = null, $abonnementsoortBetaalwijze = null, $abonnementsoortPrijs = null, $abonnementsoortBtwCode = null, $abonnementsoortBtwOmschr = null, $abonnementsoortBtwPercentage = null, $abonnementsoortPeriode = null, $abonnementsoortAantal = null, $abonnementsoortVerlenging = null, $abonnementsoortDoorlopend = null, $abonnementsoortKortPerc = null, $abonnementsoortKortBedr = null, $abonnementsoortKortIncasso = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst1 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst2 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst3 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst4 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst5 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst6 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst7 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst8 = null, \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst9 = null, \StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum1 = null, \StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum2 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode1 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode2 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode3 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode4 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode5 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode6 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode7 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode8 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode9 = null, \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode10 = null, $abonnementsoortActief = null, $organisatieLicentie = null, $buitenland = null)
    {
        $this
            ->setAbonnementsoortNo($abonnementsoortNo)
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setAbonnementsoortNaam($abonnementsoortNaam)
            ->setAbonnementsoortBetaalwijze($abonnementsoortBetaalwijze)
            ->setAbonnementsoortPrijs($abonnementsoortPrijs)
            ->setAbonnementsoortBtwCode($abonnementsoortBtwCode)
            ->setAbonnementsoortBtwOmschr($abonnementsoortBtwOmschr)
            ->setAbonnementsoortBtwPercentage($abonnementsoortBtwPercentage)
            ->setAbonnementsoortPeriode($abonnementsoortPeriode)
            ->setAbonnementsoortAantal($abonnementsoortAantal)
            ->setAbonnementsoortVerlenging($abonnementsoortVerlenging)
            ->setAbonnementsoortDoorlopend($abonnementsoortDoorlopend)
            ->setAbonnementsoortKortPerc($abonnementsoortKortPerc)
            ->setAbonnementsoortKortBedr($abonnementsoortKortBedr)
            ->setAbonnementsoortKortIncasso($abonnementsoortKortIncasso)
            ->setAbonnementsoortVrijeTekst1($abonnementsoortVrijeTekst1)
            ->setAbonnementsoortVrijeTekst2($abonnementsoortVrijeTekst2)
            ->setAbonnementsoortVrijeTekst3($abonnementsoortVrijeTekst3)
            ->setAbonnementsoortVrijeTekst4($abonnementsoortVrijeTekst4)
            ->setAbonnementsoortVrijeTekst5($abonnementsoortVrijeTekst5)
            ->setAbonnementsoortVrijeTekst6($abonnementsoortVrijeTekst6)
            ->setAbonnementsoortVrijeTekst7($abonnementsoortVrijeTekst7)
            ->setAbonnementsoortVrijeTekst8($abonnementsoortVrijeTekst8)
            ->setAbonnementsoortVrijeTekst9($abonnementsoortVrijeTekst9)
            ->setAbonnementsoortVrijeDatum1($abonnementsoortVrijeDatum1)
            ->setAbonnementsoortVrijeDatum2($abonnementsoortVrijeDatum2)
            ->setAbonnementsoortVrijCode1($abonnementsoortVrijCode1)
            ->setAbonnementsoortVrijCode2($abonnementsoortVrijCode2)
            ->setAbonnementsoortVrijCode3($abonnementsoortVrijCode3)
            ->setAbonnementsoortVrijCode4($abonnementsoortVrijCode4)
            ->setAbonnementsoortVrijCode5($abonnementsoortVrijCode5)
            ->setAbonnementsoortVrijCode6($abonnementsoortVrijCode6)
            ->setAbonnementsoortVrijCode7($abonnementsoortVrijCode7)
            ->setAbonnementsoortVrijCode8($abonnementsoortVrijCode8)
            ->setAbonnementsoortVrijCode9($abonnementsoortVrijCode9)
            ->setAbonnementsoortVrijCode10($abonnementsoortVrijCode10)
            ->setAbonnementsoortActief($abonnementsoortActief)
            ->setOrganisatieLicentie($organisatieLicentie)
            ->setBuitenland($buitenland);
    }
    /**
     * Get abonnementsoortNo value
     * @return int
     */
    public function getAbonnementsoortNo()
    {
        return $this->abonnementsoortNo;
    }
    /**
     * Set abonnementsoortNo value
     * @param int $abonnementsoortNo
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortNo($abonnementsoortNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($abonnementsoortNo, strpos($abonnementsoortNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abonnementsoortNo) && !is_numeric($abonnementsoortNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abonnementsoortNo)), __LINE__);
        }
        $this->abonnementsoortNo = $abonnementsoortNo;
        return $this;
    }
    /**
     * Get abonnementsoortCode value
     * @return string
     */
    public function getAbonnementsoortCode()
    {
        return $this->abonnementsoortCode;
    }
    /**
     * Set abonnementsoortCode value
     * @param string $abonnementsoortCode
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) > 30) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementsoortCode) ? strlen($abonnementsoortCode) : count($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abonnementsoortCode) && strlen($abonnementsoortCode) < 1) || (is_array($abonnementsoortCode) && count($abonnementsoortCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortCode)), __LINE__);
        }
        $this->abonnementsoortCode = $abonnementsoortCode;
        return $this;
    }
    /**
     * Get abonnementsoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortNaam()
    {
        return isset($this->abonnementsoortNaam) ? $this->abonnementsoortNaam : null;
    }
    /**
     * Set abonnementsoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortNaam
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortNaam($abonnementsoortNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortNaam) && strlen($abonnementsoortNaam) > 500) || (is_array($abonnementsoortNaam) && count($abonnementsoortNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($abonnementsoortNaam) ? strlen($abonnementsoortNaam) : count($abonnementsoortNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortNaam) && !is_string($abonnementsoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortNaam)), __LINE__);
        }
        if (is_null($abonnementsoortNaam) || (is_array($abonnementsoortNaam) && empty($abonnementsoortNaam))) {
            unset($this->abonnementsoortNaam);
        } else {
            $this->abonnementsoortNaam = $abonnementsoortNaam;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBetaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementsoortBetaalwijze()
    {
        return isset($this->abonnementsoortBetaalwijze) ? $this->abonnementsoortBetaalwijze : null;
    }
    /**
     * Set abonnementsoortBetaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementsoortBetaalwijze
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortBetaalwijze($abonnementsoortBetaalwijze = null)
    {
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortBetaalwijze) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortBetaalwijze)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 digits, "%d" given', strlen(substr($abonnementsoortBetaalwijze, strpos($abonnementsoortBetaalwijze, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abonnementsoortBetaalwijze) && !is_numeric($abonnementsoortBetaalwijze)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abonnementsoortBetaalwijze)), __LINE__);
        }
        if (is_null($abonnementsoortBetaalwijze) || (is_array($abonnementsoortBetaalwijze) && empty($abonnementsoortBetaalwijze))) {
            unset($this->abonnementsoortBetaalwijze);
        } else {
            $this->abonnementsoortBetaalwijze = $abonnementsoortBetaalwijze;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPrijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortPrijs()
    {
        return isset($this->abonnementsoortPrijs) ? $this->abonnementsoortPrijs : null;
    }
    /**
     * Set abonnementsoortPrijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortPrijs
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortPrijs($abonnementsoortPrijs = null)
    {
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortPrijs) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortPrijs)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($abonnementsoortPrijs, strpos($abonnementsoortPrijs, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortPrijs) || (is_array($abonnementsoortPrijs) && empty($abonnementsoortPrijs))) {
            unset($this->abonnementsoortPrijs);
        } else {
            $this->abonnementsoortPrijs = $abonnementsoortPrijs;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBtwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortBtwCode()
    {
        return isset($this->abonnementsoortBtwCode) ? $this->abonnementsoortBtwCode : null;
    }
    /**
     * Set abonnementsoortBtwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortBtwCode
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortBtwCode($abonnementsoortBtwCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortBtwCode) && strlen($abonnementsoortBtwCode) > 3) || (is_array($abonnementsoortBtwCode) && count($abonnementsoortBtwCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($abonnementsoortBtwCode) ? strlen($abonnementsoortBtwCode) : count($abonnementsoortBtwCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortBtwCode) && !is_string($abonnementsoortBtwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortBtwCode)), __LINE__);
        }
        if (is_null($abonnementsoortBtwCode) || (is_array($abonnementsoortBtwCode) && empty($abonnementsoortBtwCode))) {
            unset($this->abonnementsoortBtwCode);
        } else {
            $this->abonnementsoortBtwCode = $abonnementsoortBtwCode;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBtwOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortBtwOmschr()
    {
        return isset($this->abonnementsoortBtwOmschr) ? $this->abonnementsoortBtwOmschr : null;
    }
    /**
     * Set abonnementsoortBtwOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortBtwOmschr
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortBtwOmschr($abonnementsoortBtwOmschr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortBtwOmschr) && strlen($abonnementsoortBtwOmschr) > 120) || (is_array($abonnementsoortBtwOmschr) && count($abonnementsoortBtwOmschr) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($abonnementsoortBtwOmschr) ? strlen($abonnementsoortBtwOmschr) : count($abonnementsoortBtwOmschr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortBtwOmschr) && !is_string($abonnementsoortBtwOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortBtwOmschr)), __LINE__);
        }
        if (is_null($abonnementsoortBtwOmschr) || (is_array($abonnementsoortBtwOmschr) && empty($abonnementsoortBtwOmschr))) {
            unset($this->abonnementsoortBtwOmschr);
        } else {
            $this->abonnementsoortBtwOmschr = $abonnementsoortBtwOmschr;
        }
        return $this;
    }
    /**
     * Get abonnementsoortBtwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortBtwPercentage()
    {
        return isset($this->abonnementsoortBtwPercentage) ? $this->abonnementsoortBtwPercentage : null;
    }
    /**
     * Set abonnementsoortBtwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortBtwPercentage
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortBtwPercentage($abonnementsoortBtwPercentage = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($abonnementsoortBtwPercentage) && strlen(substr($abonnementsoortBtwPercentage, strpos($abonnementsoortBtwPercentage, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($abonnementsoortBtwPercentage, strpos($abonnementsoortBtwPercentage, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortBtwPercentage) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortBtwPercentage)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($abonnementsoortBtwPercentage, strpos($abonnementsoortBtwPercentage, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortBtwPercentage) || (is_array($abonnementsoortBtwPercentage) && empty($abonnementsoortBtwPercentage))) {
            unset($this->abonnementsoortBtwPercentage);
        } else {
            $this->abonnementsoortBtwPercentage = $abonnementsoortBtwPercentage;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPeriode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortPeriode()
    {
        return isset($this->abonnementsoortPeriode) ? $this->abonnementsoortPeriode : null;
    }
    /**
     * Set abonnementsoortPeriode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortPeriode
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortPeriode($abonnementsoortPeriode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortPeriode) && strlen($abonnementsoortPeriode) > 10) || (is_array($abonnementsoortPeriode) && count($abonnementsoortPeriode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($abonnementsoortPeriode) ? strlen($abonnementsoortPeriode) : count($abonnementsoortPeriode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortPeriode) && !is_string($abonnementsoortPeriode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortPeriode)), __LINE__);
        }
        if (is_null($abonnementsoortPeriode) || (is_array($abonnementsoortPeriode) && empty($abonnementsoortPeriode))) {
            unset($this->abonnementsoortPeriode);
        } else {
            $this->abonnementsoortPeriode = $abonnementsoortPeriode;
        }
        return $this;
    }
    /**
     * Get abonnementsoortAantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementsoortAantal()
    {
        return isset($this->abonnementsoortAantal) ? $this->abonnementsoortAantal : null;
    }
    /**
     * Set abonnementsoortAantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementsoortAantal
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortAantal($abonnementsoortAantal = null)
    {
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortAantal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortAantal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($abonnementsoortAantal, strpos($abonnementsoortAantal, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abonnementsoortAantal) && !is_numeric($abonnementsoortAantal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abonnementsoortAantal)), __LINE__);
        }
        if (is_null($abonnementsoortAantal) || (is_array($abonnementsoortAantal) && empty($abonnementsoortAantal))) {
            unset($this->abonnementsoortAantal);
        } else {
            $this->abonnementsoortAantal = $abonnementsoortAantal;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVerlenging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortVerlenging()
    {
        return isset($this->abonnementsoortVerlenging) ? $this->abonnementsoortVerlenging : null;
    }
    /**
     * Set abonnementsoortVerlenging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortVerlenging
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVerlenging($abonnementsoortVerlenging = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementsoortVerlenging) && strlen($abonnementsoortVerlenging) > 50) || (is_array($abonnementsoortVerlenging) && count($abonnementsoortVerlenging) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($abonnementsoortVerlenging) ? strlen($abonnementsoortVerlenging) : count($abonnementsoortVerlenging)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementsoortVerlenging) && !is_string($abonnementsoortVerlenging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementsoortVerlenging)), __LINE__);
        }
        if (is_null($abonnementsoortVerlenging) || (is_array($abonnementsoortVerlenging) && empty($abonnementsoortVerlenging))) {
            unset($this->abonnementsoortVerlenging);
        } else {
            $this->abonnementsoortVerlenging = $abonnementsoortVerlenging;
        }
        return $this;
    }
    /**
     * Get abonnementsoortDoorlopend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAbonnementsoortDoorlopend()
    {
        return isset($this->abonnementsoortDoorlopend) ? $this->abonnementsoortDoorlopend : null;
    }
    /**
     * Set abonnementsoortDoorlopend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $abonnementsoortDoorlopend
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortDoorlopend($abonnementsoortDoorlopend = null)
    {
        if (is_null($abonnementsoortDoorlopend) || (is_array($abonnementsoortDoorlopend) && empty($abonnementsoortDoorlopend))) {
            unset($this->abonnementsoortDoorlopend);
        } else {
            $this->abonnementsoortDoorlopend = $abonnementsoortDoorlopend;
        }
        return $this;
    }
    /**
     * Get abonnementsoortKortPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortKortPerc()
    {
        return isset($this->abonnementsoortKortPerc) ? $this->abonnementsoortKortPerc : null;
    }
    /**
     * Set abonnementsoortKortPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortKortPerc
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortKortPerc($abonnementsoortKortPerc = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($abonnementsoortKortPerc) && strlen(substr($abonnementsoortKortPerc, strpos($abonnementsoortKortPerc, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($abonnementsoortKortPerc, strpos($abonnementsoortKortPerc, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortKortPerc) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortKortPerc)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($abonnementsoortKortPerc, strpos($abonnementsoortKortPerc, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortKortPerc) || (is_array($abonnementsoortKortPerc) && empty($abonnementsoortKortPerc))) {
            unset($this->abonnementsoortKortPerc);
        } else {
            $this->abonnementsoortKortPerc = $abonnementsoortKortPerc;
        }
        return $this;
    }
    /**
     * Get abonnementsoortKortBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortKortBedr()
    {
        return isset($this->abonnementsoortKortBedr) ? $this->abonnementsoortKortBedr : null;
    }
    /**
     * Set abonnementsoortKortBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortKortBedr
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortKortBedr($abonnementsoortKortBedr = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($abonnementsoortKortBedr) && strlen(substr($abonnementsoortKortBedr, strpos($abonnementsoortKortBedr, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($abonnementsoortKortBedr, strpos($abonnementsoortKortBedr, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortKortBedr) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortKortBedr)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($abonnementsoortKortBedr, strpos($abonnementsoortKortBedr, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortKortBedr) || (is_array($abonnementsoortKortBedr) && empty($abonnementsoortKortBedr))) {
            unset($this->abonnementsoortKortBedr);
        } else {
            $this->abonnementsoortKortBedr = $abonnementsoortKortBedr;
        }
        return $this;
    }
    /**
     * Get abonnementsoortKortIncasso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortKortIncasso()
    {
        return isset($this->abonnementsoortKortIncasso) ? $this->abonnementsoortKortIncasso : null;
    }
    /**
     * Set abonnementsoortKortIncasso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortKortIncasso
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortKortIncasso($abonnementsoortKortIncasso = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($abonnementsoortKortIncasso) && strlen(substr($abonnementsoortKortIncasso, strpos($abonnementsoortKortIncasso, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($abonnementsoortKortIncasso, strpos($abonnementsoortKortIncasso, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abonnementsoortKortIncasso) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abonnementsoortKortIncasso)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($abonnementsoortKortIncasso, strpos($abonnementsoortKortIncasso, '.')))), __LINE__);
        }
        if (is_null($abonnementsoortKortIncasso) || (is_array($abonnementsoortKortIncasso) && empty($abonnementsoortKortIncasso))) {
            unset($this->abonnementsoortKortIncasso);
        } else {
            $this->abonnementsoortKortIncasso = $abonnementsoortKortIncasso;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst1()
    {
        return isset($this->abonnementsoortVrijeTekst1) ? $this->abonnementsoortVrijeTekst1 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst1
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst1(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst1 = null)
    {
        if (is_null($abonnementsoortVrijeTekst1) || (is_array($abonnementsoortVrijeTekst1) && empty($abonnementsoortVrijeTekst1))) {
            unset($this->abonnementsoortVrijeTekst1);
        } else {
            $this->abonnementsoortVrijeTekst1 = $abonnementsoortVrijeTekst1;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst2()
    {
        return isset($this->abonnementsoortVrijeTekst2) ? $this->abonnementsoortVrijeTekst2 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst2
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst2(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst2 = null)
    {
        if (is_null($abonnementsoortVrijeTekst2) || (is_array($abonnementsoortVrijeTekst2) && empty($abonnementsoortVrijeTekst2))) {
            unset($this->abonnementsoortVrijeTekst2);
        } else {
            $this->abonnementsoortVrijeTekst2 = $abonnementsoortVrijeTekst2;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst3()
    {
        return isset($this->abonnementsoortVrijeTekst3) ? $this->abonnementsoortVrijeTekst3 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst3
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst3(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst3 = null)
    {
        if (is_null($abonnementsoortVrijeTekst3) || (is_array($abonnementsoortVrijeTekst3) && empty($abonnementsoortVrijeTekst3))) {
            unset($this->abonnementsoortVrijeTekst3);
        } else {
            $this->abonnementsoortVrijeTekst3 = $abonnementsoortVrijeTekst3;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst4()
    {
        return isset($this->abonnementsoortVrijeTekst4) ? $this->abonnementsoortVrijeTekst4 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst4
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst4(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst4 = null)
    {
        if (is_null($abonnementsoortVrijeTekst4) || (is_array($abonnementsoortVrijeTekst4) && empty($abonnementsoortVrijeTekst4))) {
            unset($this->abonnementsoortVrijeTekst4);
        } else {
            $this->abonnementsoortVrijeTekst4 = $abonnementsoortVrijeTekst4;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst5()
    {
        return isset($this->abonnementsoortVrijeTekst5) ? $this->abonnementsoortVrijeTekst5 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst5
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst5(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst5 = null)
    {
        if (is_null($abonnementsoortVrijeTekst5) || (is_array($abonnementsoortVrijeTekst5) && empty($abonnementsoortVrijeTekst5))) {
            unset($this->abonnementsoortVrijeTekst5);
        } else {
            $this->abonnementsoortVrijeTekst5 = $abonnementsoortVrijeTekst5;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst6()
    {
        return isset($this->abonnementsoortVrijeTekst6) ? $this->abonnementsoortVrijeTekst6 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst6
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst6(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst6 = null)
    {
        if (is_null($abonnementsoortVrijeTekst6) || (is_array($abonnementsoortVrijeTekst6) && empty($abonnementsoortVrijeTekst6))) {
            unset($this->abonnementsoortVrijeTekst6);
        } else {
            $this->abonnementsoortVrijeTekst6 = $abonnementsoortVrijeTekst6;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst7()
    {
        return isset($this->abonnementsoortVrijeTekst7) ? $this->abonnementsoortVrijeTekst7 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst7
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst7(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst7 = null)
    {
        if (is_null($abonnementsoortVrijeTekst7) || (is_array($abonnementsoortVrijeTekst7) && empty($abonnementsoortVrijeTekst7))) {
            unset($this->abonnementsoortVrijeTekst7);
        } else {
            $this->abonnementsoortVrijeTekst7 = $abonnementsoortVrijeTekst7;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst8()
    {
        return isset($this->abonnementsoortVrijeTekst8) ? $this->abonnementsoortVrijeTekst8 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst8
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst8(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst8 = null)
    {
        if (is_null($abonnementsoortVrijeTekst8) || (is_array($abonnementsoortVrijeTekst8) && empty($abonnementsoortVrijeTekst8))) {
            unset($this->abonnementsoortVrijeTekst8);
        } else {
            $this->abonnementsoortVrijeTekst8 = $abonnementsoortVrijeTekst8;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeTekst9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldTekstV4|null
     */
    public function getAbonnementsoortVrijeTekst9()
    {
        return isset($this->abonnementsoortVrijeTekst9) ? $this->abonnementsoortVrijeTekst9 : null;
    }
    /**
     * Set abonnementsoortVrijeTekst9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst9
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeTekst9(\StructType\VrijVeldTekstV4 $abonnementsoortVrijeTekst9 = null)
    {
        if (is_null($abonnementsoortVrijeTekst9) || (is_array($abonnementsoortVrijeTekst9) && empty($abonnementsoortVrijeTekst9))) {
            unset($this->abonnementsoortVrijeTekst9);
        } else {
            $this->abonnementsoortVrijeTekst9 = $abonnementsoortVrijeTekst9;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeDatum1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldDatumV4|null
     */
    public function getAbonnementsoortVrijeDatum1()
    {
        return isset($this->abonnementsoortVrijeDatum1) ? $this->abonnementsoortVrijeDatum1 : null;
    }
    /**
     * Set abonnementsoortVrijeDatum1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum1
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeDatum1(\StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum1 = null)
    {
        if (is_null($abonnementsoortVrijeDatum1) || (is_array($abonnementsoortVrijeDatum1) && empty($abonnementsoortVrijeDatum1))) {
            unset($this->abonnementsoortVrijeDatum1);
        } else {
            $this->abonnementsoortVrijeDatum1 = $abonnementsoortVrijeDatum1;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijeDatum2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldDatumV4|null
     */
    public function getAbonnementsoortVrijeDatum2()
    {
        return isset($this->abonnementsoortVrijeDatum2) ? $this->abonnementsoortVrijeDatum2 : null;
    }
    /**
     * Set abonnementsoortVrijeDatum2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum2
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijeDatum2(\StructType\VrijVeldDatumV4 $abonnementsoortVrijeDatum2 = null)
    {
        if (is_null($abonnementsoortVrijeDatum2) || (is_array($abonnementsoortVrijeDatum2) && empty($abonnementsoortVrijeDatum2))) {
            unset($this->abonnementsoortVrijeDatum2);
        } else {
            $this->abonnementsoortVrijeDatum2 = $abonnementsoortVrijeDatum2;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode1()
    {
        return isset($this->abonnementsoortVrijCode1) ? $this->abonnementsoortVrijCode1 : null;
    }
    /**
     * Set abonnementsoortVrijCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode1
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode1(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode1 = null)
    {
        if (is_null($abonnementsoortVrijCode1) || (is_array($abonnementsoortVrijCode1) && empty($abonnementsoortVrijCode1))) {
            unset($this->abonnementsoortVrijCode1);
        } else {
            $this->abonnementsoortVrijCode1 = $abonnementsoortVrijCode1;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode2()
    {
        return isset($this->abonnementsoortVrijCode2) ? $this->abonnementsoortVrijCode2 : null;
    }
    /**
     * Set abonnementsoortVrijCode2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode2
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode2(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode2 = null)
    {
        if (is_null($abonnementsoortVrijCode2) || (is_array($abonnementsoortVrijCode2) && empty($abonnementsoortVrijCode2))) {
            unset($this->abonnementsoortVrijCode2);
        } else {
            $this->abonnementsoortVrijCode2 = $abonnementsoortVrijCode2;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode3()
    {
        return isset($this->abonnementsoortVrijCode3) ? $this->abonnementsoortVrijCode3 : null;
    }
    /**
     * Set abonnementsoortVrijCode3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode3
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode3(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode3 = null)
    {
        if (is_null($abonnementsoortVrijCode3) || (is_array($abonnementsoortVrijCode3) && empty($abonnementsoortVrijCode3))) {
            unset($this->abonnementsoortVrijCode3);
        } else {
            $this->abonnementsoortVrijCode3 = $abonnementsoortVrijCode3;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode4()
    {
        return isset($this->abonnementsoortVrijCode4) ? $this->abonnementsoortVrijCode4 : null;
    }
    /**
     * Set abonnementsoortVrijCode4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode4
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode4(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode4 = null)
    {
        if (is_null($abonnementsoortVrijCode4) || (is_array($abonnementsoortVrijCode4) && empty($abonnementsoortVrijCode4))) {
            unset($this->abonnementsoortVrijCode4);
        } else {
            $this->abonnementsoortVrijCode4 = $abonnementsoortVrijCode4;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode5()
    {
        return isset($this->abonnementsoortVrijCode5) ? $this->abonnementsoortVrijCode5 : null;
    }
    /**
     * Set abonnementsoortVrijCode5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode5
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode5(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode5 = null)
    {
        if (is_null($abonnementsoortVrijCode5) || (is_array($abonnementsoortVrijCode5) && empty($abonnementsoortVrijCode5))) {
            unset($this->abonnementsoortVrijCode5);
        } else {
            $this->abonnementsoortVrijCode5 = $abonnementsoortVrijCode5;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode6()
    {
        return isset($this->abonnementsoortVrijCode6) ? $this->abonnementsoortVrijCode6 : null;
    }
    /**
     * Set abonnementsoortVrijCode6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode6
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode6(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode6 = null)
    {
        if (is_null($abonnementsoortVrijCode6) || (is_array($abonnementsoortVrijCode6) && empty($abonnementsoortVrijCode6))) {
            unset($this->abonnementsoortVrijCode6);
        } else {
            $this->abonnementsoortVrijCode6 = $abonnementsoortVrijCode6;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode7()
    {
        return isset($this->abonnementsoortVrijCode7) ? $this->abonnementsoortVrijCode7 : null;
    }
    /**
     * Set abonnementsoortVrijCode7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode7
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode7(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode7 = null)
    {
        if (is_null($abonnementsoortVrijCode7) || (is_array($abonnementsoortVrijCode7) && empty($abonnementsoortVrijCode7))) {
            unset($this->abonnementsoortVrijCode7);
        } else {
            $this->abonnementsoortVrijCode7 = $abonnementsoortVrijCode7;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode8()
    {
        return isset($this->abonnementsoortVrijCode8) ? $this->abonnementsoortVrijCode8 : null;
    }
    /**
     * Set abonnementsoortVrijCode8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode8
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode8(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode8 = null)
    {
        if (is_null($abonnementsoortVrijCode8) || (is_array($abonnementsoortVrijCode8) && empty($abonnementsoortVrijCode8))) {
            unset($this->abonnementsoortVrijCode8);
        } else {
            $this->abonnementsoortVrijCode8 = $abonnementsoortVrijCode8;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode9()
    {
        return isset($this->abonnementsoortVrijCode9) ? $this->abonnementsoortVrijCode9 : null;
    }
    /**
     * Set abonnementsoortVrijCode9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode9
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode9(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode9 = null)
    {
        if (is_null($abonnementsoortVrijCode9) || (is_array($abonnementsoortVrijCode9) && empty($abonnementsoortVrijCode9))) {
            unset($this->abonnementsoortVrijCode9);
        } else {
            $this->abonnementsoortVrijCode9 = $abonnementsoortVrijCode9;
        }
        return $this;
    }
    /**
     * Get abonnementsoortVrijCode10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijVeldCodeV4|null
     */
    public function getAbonnementsoortVrijCode10()
    {
        return isset($this->abonnementsoortVrijCode10) ? $this->abonnementsoortVrijCode10 : null;
    }
    /**
     * Set abonnementsoortVrijCode10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijVeldCodeV4 $abonnementsoortVrijCode10
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortVrijCode10(\StructType\VrijVeldCodeV4 $abonnementsoortVrijCode10 = null)
    {
        if (is_null($abonnementsoortVrijCode10) || (is_array($abonnementsoortVrijCode10) && empty($abonnementsoortVrijCode10))) {
            unset($this->abonnementsoortVrijCode10);
        } else {
            $this->abonnementsoortVrijCode10 = $abonnementsoortVrijCode10;
        }
        return $this;
    }
    /**
     * Get abonnementsoortActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAbonnementsoortActief()
    {
        return isset($this->abonnementsoortActief) ? $this->abonnementsoortActief : null;
    }
    /**
     * Set abonnementsoortActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $abonnementsoortActief
     * @return \StructType\AbonnementsoortV4
     */
    public function setAbonnementsoortActief($abonnementsoortActief = null)
    {
        if (is_null($abonnementsoortActief) || (is_array($abonnementsoortActief) && empty($abonnementsoortActief))) {
            unset($this->abonnementsoortActief);
        } else {
            $this->abonnementsoortActief = $abonnementsoortActief;
        }
        return $this;
    }
    /**
     * Get organisatieLicentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganisatieLicentie()
    {
        return isset($this->organisatieLicentie) ? $this->organisatieLicentie : null;
    }
    /**
     * Set organisatieLicentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organisatieLicentie
     * @return \StructType\AbonnementsoortV4
     */
    public function setOrganisatieLicentie($organisatieLicentie = null)
    {
        if (is_null($organisatieLicentie) || (is_array($organisatieLicentie) && empty($organisatieLicentie))) {
            unset($this->organisatieLicentie);
        } else {
            $this->organisatieLicentie = $organisatieLicentie;
        }
        return $this;
    }
    /**
     * Get buitenland value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBuitenland()
    {
        return isset($this->buitenland) ? $this->buitenland : null;
    }
    /**
     * Set buitenland value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $buitenland
     * @return \StructType\AbonnementsoortV4
     */
    public function setBuitenland($buitenland = null)
    {
        if (is_null($buitenland) || (is_array($buitenland) && empty($buitenland))) {
            unset($this->buitenland);
        } else {
            $this->buitenland = $buitenland;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbonnementsoortV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
