<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Stop ServiceType
 * @subpackage Services
 */
class Stop extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named stopGratisAboPerDirect
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Stopt een abonnement per direct. Bedoelt om abonnementen op een nieuwsbrief of online toegang te stoppen.<br /> Mag aangeroepen worden met ofwel aboNo, ofwel met een relNo, een uitgaveCode en evt. een abosoortCode.<br /><br />
     * Voorwaarden: <ul><li>Looptijd van een abonnement is opgegeven in maanden of jaren, of edities en is ingericht met 365 edities per jaar</li> <li>Abonnementsoort is gratis</li></ul><br /> Abonnement wordt stopgezet per de datum van gisteren. Als de
     * startdatum van het abonnement gelijk is aan de datum van vandaag, wordt het abonnement per vandaag gestopt en wordt 'verzendstop' aangezet.<br />error1: Ongeldige combinatie van argumenten: geef ofwel een aboNo op, ofwel een combiniatie van een relNo
     * en uitgaveCode met evt. een abosoortCode,error2: Het abonnement is niet gevonden op basis van de opgegeven aboNo.error3: Kan geen relatie vinden obv de opgegeven relNoerror4: Kan geen uitgave vinden obv de opgegeven uitgaveCode.error5: Kan geen
     * abonnementsoort vinden obv de opgegeven abosoortCode.error6: De opgegeven abosoortCode hoort niet bij de opgegeven uitgaveCode.error7: Er is geen abonnement gevonden op basis van de opgegeven relNo, uitgaveCode en abosoortCodeerror8: De inrichting
     * van de uitgave of abonnementsoort voldoet niet aan de voorwaarden.error9: Het abonnement is reeds gestopt.error10: De stopreden is niet gevonden.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StopGratisAboPerDirectRequest $request_parameters
     * @return \StructType\StopGratisAboPerDirectResponse|bool
     */
    public function stopGratisAboPerDirect(\StructType\StopGratisAboPerDirectRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->stopGratisAboPerDirect($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StopGratisAboPerDirectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
