<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named searchAbonnement
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Zoeken van abonnements informatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchAbonnementRequest $request_parameters
     * @return \StructType\SearchAbonnementResponse|bool
     */
    public function searchAbonnement(\StructType\SearchAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchAbonnementByCred
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Geeft een lijst met abonnementen op die gelden voor de opgegeven userName en password combinatie.error11: Op basis van de opgegeven username en password is er meer dan 1 abonnement gevondenerror12: Op basis van de opgegeven username
     * en password is er meer dan 1 relatie gevondenerror14: Op basis van de opgegeven username en password is geen relatie of abonnement gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchAbonnementByCredRequest $request_parameters
     * @return \StructType\SearchAbonnementByCredResponse|bool
     */
    public function searchAbonnementByCred(\StructType\SearchAbonnementByCredRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchAbonnementByCred($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchSmartcode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Geeft het aboneementnummer terug van het abonnement behorende bij de smartcode.error1: Op basis van de smartcode is geen abonnement gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchSmartcodeRequest $request_parameters
     * @return \StructType\SearchSmartcodeResponse|bool
     */
    public function searchSmartcode(\StructType\SearchSmartcodeRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchSmartcode($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchRelNoByAboNo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Geeft het relatienummer van het opgegeven abonnementnummer terug
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchRelNoByAboNoRequest $request_parameters
     * @return \StructType\SearchRelNoByAboNoResponse|bool
     */
    public function searchRelNoByAboNo(\StructType\SearchRelNoByAboNoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchRelNoByAboNo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchRelNoByEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Geeft een lijst met relatienummers terug die het opgegeven e-mail adres hebben.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchRelNoByEmailRequest $request_parameters
     * @return \StructType\SearchRelNoByEmailResponse|bool
     */
    public function searchRelNoByEmail(\StructType\SearchRelNoByEmailRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->searchRelNoByEmail($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchAbonnementByCredResponse|\StructType\SearchAbonnementResponse|\StructType\SearchRelNoByAboNoResponse|\StructType\SearchRelNoByEmailResponse|\StructType\SearchSmartcodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
