<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerbandV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens van het gevonden verband
 * @subpackage Structs
 */
class VerbandV4 extends AbstractStructBase
{
    /**
     * The relNo1
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het verband eventueel te gebruiken bij deleteVerband.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo1;
    /**
     * The relNo2
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 1.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo2;
    /**
     * The verbandCode
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 2.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $verbandCode;
    /**
     * The verbandNo
     * Meta informations extracted from the WSDL
     * - documentation: Code van het verband.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * Constructor method for VerbandV4
     * @uses VerbandV4::setRelNo1()
     * @uses VerbandV4::setRelNo2()
     * @uses VerbandV4::setVerbandCode()
     * @uses VerbandV4::setVerbandNo()
     * @param int $relNo1
     * @param int $relNo2
     * @param string $verbandCode
     * @param int $verbandNo
     */
    public function __construct($relNo1 = null, $relNo2 = null, $verbandCode = null, $verbandNo = null)
    {
        $this
            ->setRelNo1($relNo1)
            ->setRelNo2($relNo2)
            ->setVerbandCode($verbandCode)
            ->setVerbandNo($verbandNo);
    }
    /**
     * Get relNo1 value
     * @return int
     */
    public function getRelNo1()
    {
        return $this->relNo1;
    }
    /**
     * Set relNo1 value
     * @param int $relNo1
     * @return \StructType\VerbandV4
     */
    public function setRelNo1($relNo1 = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo1) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo1)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo1, strpos($relNo1, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo1) && !is_numeric($relNo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo1)), __LINE__);
        }
        $this->relNo1 = $relNo1;
        return $this;
    }
    /**
     * Get relNo2 value
     * @return int
     */
    public function getRelNo2()
    {
        return $this->relNo2;
    }
    /**
     * Set relNo2 value
     * @param int $relNo2
     * @return \StructType\VerbandV4
     */
    public function setRelNo2($relNo2 = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo2) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo2)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo2, strpos($relNo2, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo2) && !is_numeric($relNo2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo2)), __LINE__);
        }
        $this->relNo2 = $relNo2;
        return $this;
    }
    /**
     * Get verbandCode value
     * @return string
     */
    public function getVerbandCode()
    {
        return $this->verbandCode;
    }
    /**
     * Set verbandCode value
     * @param string $verbandCode
     * @return \StructType\VerbandV4
     */
    public function setVerbandCode($verbandCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($verbandCode) && strlen($verbandCode) > 12) || (is_array($verbandCode) && count($verbandCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($verbandCode) ? strlen($verbandCode) : count($verbandCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($verbandCode) && strlen($verbandCode) < 1) || (is_array($verbandCode) && count($verbandCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($verbandCode) && !is_string($verbandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verbandCode)), __LINE__);
        }
        $this->verbandCode = $verbandCode;
        return $this;
    }
    /**
     * Get verbandNo value
     * @return int
     */
    public function getVerbandNo()
    {
        return $this->verbandNo;
    }
    /**
     * Set verbandNo value
     * @param int $verbandNo
     * @return \StructType\VerbandV4
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($verbandNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $verbandNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($verbandNo, strpos($verbandNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($verbandNo) && !is_numeric($verbandNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($verbandNo)), __LINE__);
        }
        $this->verbandNo = $verbandNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerbandV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
