<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerbandInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met verbanden.
 * @subpackage Structs
 */
class VerbandInfoV4 extends AbstractStructBase
{
    /**
     * The verband
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met verbanden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\VerbandV4[]
     */
    public $verband;
    /**
     * Constructor method for VerbandInfoV4
     * @uses VerbandInfoV4::setVerband()
     * @param \StructType\VerbandV4[] $verband
     */
    public function __construct(array $verband = array())
    {
        $this
            ->setVerband($verband);
    }
    /**
     * Get verband value
     * @return \StructType\VerbandV4[]|null
     */
    public function getVerband()
    {
        return $this->verband;
    }
    /**
     * Set verband value
     * @throws \InvalidArgumentException
     * @param \StructType\VerbandV4[] $verband
     * @return \StructType\VerbandInfoV4
     */
    public function setVerband(array $verband = array())
    {
        foreach ($verband as $verbandInfoV4VerbandItem) {
            // validation for constraint: itemType
            if (!$verbandInfoV4VerbandItem instanceof \StructType\VerbandV4) {
                throw new \InvalidArgumentException(sprintf('The verband property can only contain items of \StructType\VerbandV4, "%s" given', is_object($verbandInfoV4VerbandItem) ? get_class($verbandInfoV4VerbandItem) : gettype($verbandInfoV4VerbandItem)), __LINE__);
            }
        }
        $this->verband = $verband;
        return $this;
    }
    /**
     * Add item to verband value
     * @throws \InvalidArgumentException
     * @param \StructType\VerbandV4 $item
     * @return \StructType\VerbandInfoV4
     */
    public function addToVerband(\StructType\VerbandV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VerbandV4) {
            throw new \InvalidArgumentException(sprintf('The verband property can only contain items of \StructType\VerbandV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->verband[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerbandInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
