<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateLicentieRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Hoogt het aantal licenties van een licentieabonnement op. <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen
 * worden leeg gemaakt door de update.
 * @subpackage Structs
 */
class UpdateLicentieRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Het abonnementsnummer waarvoor het aantal licenties verhoogd moet worden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aantalLicenties
     * Meta informations extracted from the WSDL
     * - documentation: Het nieuwe aantal licenties.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aantalLicenties;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer dat het aantal licenties heeft verhoofd.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The emailAdres
     * Meta informations extracted from the WSDL
     * - documentation: Het e-mail adres van de relatie die het aantal licenties heeft verhoogd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 80
     * @var string
     */
    public $emailAdres;
    /**
     * Constructor method for updateLicentieRequest
     * @uses UpdateLicentieRequest::setAboNo()
     * @uses UpdateLicentieRequest::setAantalLicenties()
     * @uses UpdateLicentieRequest::setRelNo()
     * @uses UpdateLicentieRequest::setRequestTag()
     * @uses UpdateLicentieRequest::setEmailAdres()
     * @param int $aboNo
     * @param float $aantalLicenties
     * @param int $relNo
     * @param string $requestTag
     * @param string $emailAdres
     */
    public function __construct($aboNo = null, $aantalLicenties = null, $relNo = null, $requestTag = null, $emailAdres = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setAantalLicenties($aantalLicenties)
            ->setRelNo($relNo)
            ->setRequestTag($requestTag)
            ->setEmailAdres($emailAdres);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\UpdateLicentieRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get aantalLicenties value
     * @return float
     */
    public function getAantalLicenties()
    {
        return $this->aantalLicenties;
    }
    /**
     * Set aantalLicenties value
     * @param float $aantalLicenties
     * @return \StructType\UpdateLicentieRequest
     */
    public function setAantalLicenties($aantalLicenties = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantalLicenties) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantalLicenties)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aantalLicenties, strpos($aantalLicenties, '.')))), __LINE__);
        }
        $this->aantalLicenties = $aantalLicenties;
        return $this;
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \StructType\UpdateLicentieRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\UpdateLicentieRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get emailAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAdres()
    {
        return isset($this->emailAdres) ? $this->emailAdres : null;
    }
    /**
     * Set emailAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAdres
     * @return \StructType\UpdateLicentieRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAdres) && strlen($emailAdres) > 80) || (is_array($emailAdres) && count($emailAdres) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($emailAdres) ? strlen($emailAdres) : count($emailAdres)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAdres)), __LINE__);
        }
        if (is_null($emailAdres) || (is_array($emailAdres) && empty($emailAdres))) {
            unset($this->emailAdres);
        } else {
            $this->emailAdres = $emailAdres;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateLicentieRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
