<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateKlantPersoonRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Werkt een bestaande relatie zijnde een persoon bij op basis van de opgegeven gegevens. <br/><u>Let op:</u> bij wijzigingen van een bestaand persoon dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven
 * (groepen) elementen worden leeg gemaakt door de update.
 * @subpackage Structs
 */
class UpdateKlantPersoonRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The persoon
     * Meta informations extracted from the WSDL
     * - documentation: Te wijzigen persoonsgegevens voor de relatie Zie 5.1 Persoonsobject.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersoonsObjectV4
     */
    public $persoon;
    /**
     * The canUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen update uitgevoerd). false (Default) = updaten, true = testmodus niet updaten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canUpdate;
    /**
     * Constructor method for updateKlantPersoonRequest
     * @uses UpdateKlantPersoonRequest::setRequestTag()
     * @uses UpdateKlantPersoonRequest::setRelNo()
     * @uses UpdateKlantPersoonRequest::setPersoon()
     * @uses UpdateKlantPersoonRequest::setCanUpdate()
     * @param string $requestTag
     * @param int $relNo
     * @param \StructType\PersoonsObjectV4 $persoon
     * @param bool $canUpdate
     */
    public function __construct($requestTag = null, $relNo = null, \StructType\PersoonsObjectV4 $persoon = null, $canUpdate = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNo($relNo)
            ->setPersoon($persoon)
            ->setCanUpdate($canUpdate);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\UpdateKlantPersoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \StructType\UpdateKlantPersoonRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get persoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersoonsObjectV4|null
     */
    public function getPersoon()
    {
        return isset($this->persoon) ? $this->persoon : null;
    }
    /**
     * Set persoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersoonsObjectV4 $persoon
     * @return \StructType\UpdateKlantPersoonRequest
     */
    public function setPersoon(\StructType\PersoonsObjectV4 $persoon = null)
    {
        if (is_null($persoon) || (is_array($persoon) && empty($persoon))) {
            unset($this->persoon);
        } else {
            $this->persoon = $persoon;
        }
        return $this;
    }
    /**
     * Get canUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUpdate()
    {
        return isset($this->canUpdate) ? $this->canUpdate : null;
    }
    /**
     * Set canUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUpdate
     * @return \StructType\UpdateKlantPersoonRequest
     */
    public function setCanUpdate($canUpdate = null)
    {
        if (is_null($canUpdate) || (is_array($canUpdate) && empty($canUpdate))) {
            unset($this->canUpdate);
        } else {
            $this->canUpdate = $canUpdate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateKlantPersoonRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
