<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UitgaveObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Uitgave object t.b.v getLeverbareProducten.
 * @subpackage Structs
 */
class UitgaveObjectV4 extends AbstractStructBase
{
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The uitgaveReguliereBezorging
     * Meta informations extracted from the WSDL
     * - documentation: Reguliere bezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $uitgaveReguliereBezorging;
    /**
     * The uitgavePostBezorging
     * Meta informations extracted from the WSDL
     * - documentation: Post bezorging mogelijk.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $uitgavePostBezorging;
    /**
     * Constructor method for UitgaveObjectV4
     * @uses UitgaveObjectV4::setUitgaveCode()
     * @uses UitgaveObjectV4::setUitgaveNaam()
     * @uses UitgaveObjectV4::setUitgaveReguliereBezorging()
     * @uses UitgaveObjectV4::setUitgavePostBezorging()
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param bool $uitgaveReguliereBezorging
     * @param bool $uitgavePostBezorging
     */
    public function __construct($uitgaveCode = null, $uitgaveNaam = null, $uitgaveReguliereBezorging = null, $uitgavePostBezorging = null)
    {
        $this
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setUitgaveReguliereBezorging($uitgaveReguliereBezorging)
            ->setUitgavePostBezorging($uitgavePostBezorging);
    }
    /**
     * Get uitgaveCode value
     * @return string
     */
    public function getUitgaveCode()
    {
        return $this->uitgaveCode;
    }
    /**
     * Set uitgaveCode value
     * @param string $uitgaveCode
     * @return \StructType\UitgaveObjectV4
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) < 1) || (is_array($uitgaveCode) && count($uitgaveCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        $this->uitgaveCode = $uitgaveCode;
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * @return string
     */
    public function getUitgaveNaam()
    {
        return $this->uitgaveNaam;
    }
    /**
     * Set uitgaveNaam value
     * @param string $uitgaveNaam
     * @return \StructType\UitgaveObjectV4
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveNaam) && strlen($uitgaveNaam) > 120) || (is_array($uitgaveNaam) && count($uitgaveNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($uitgaveNaam) ? strlen($uitgaveNaam) : count($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uitgaveNaam) && strlen($uitgaveNaam) < 1) || (is_array($uitgaveNaam) && count($uitgaveNaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveNaam)), __LINE__);
        }
        $this->uitgaveNaam = $uitgaveNaam;
        return $this;
    }
    /**
     * Get uitgaveReguliereBezorging value
     * @return bool
     */
    public function getUitgaveReguliereBezorging()
    {
        return $this->uitgaveReguliereBezorging;
    }
    /**
     * Set uitgaveReguliereBezorging value
     * @param bool $uitgaveReguliereBezorging
     * @return \StructType\UitgaveObjectV4
     */
    public function setUitgaveReguliereBezorging($uitgaveReguliereBezorging = null)
    {
        $this->uitgaveReguliereBezorging = $uitgaveReguliereBezorging;
        return $this;
    }
    /**
     * Get uitgavePostBezorging value
     * @return bool
     */
    public function getUitgavePostBezorging()
    {
        return $this->uitgavePostBezorging;
    }
    /**
     * Set uitgavePostBezorging value
     * @param bool $uitgavePostBezorging
     * @return \StructType\UitgaveObjectV4
     */
    public function setUitgavePostBezorging($uitgavePostBezorging = null)
    {
        $this->uitgavePostBezorging = $uitgavePostBezorging;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UitgaveObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
