<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RolV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Rol
 * @subpackage Structs
 */
class RolV4 extends AbstractStructBase
{
    /**
     * The rolOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Rol omschrijving.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $rolOmschrijving;
    /**
     * The rolBeheerder
     * Meta informations extracted from the WSDL
     * - documentation: Rol beheerder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $rolBeheerder;
    /**
     * The rolNummer
     * Meta informations extracted from the WSDL
     * - documentation: Rol nummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $rolNummer;
    /**
     * Constructor method for RolV4
     * @uses RolV4::setRolOmschrijving()
     * @uses RolV4::setRolBeheerder()
     * @uses RolV4::setRolNummer()
     * @param string $rolOmschrijving
     * @param int $rolBeheerder
     * @param int $rolNummer
     */
    public function __construct($rolOmschrijving = null, $rolBeheerder = null, $rolNummer = null)
    {
        $this
            ->setRolOmschrijving($rolOmschrijving)
            ->setRolBeheerder($rolBeheerder)
            ->setRolNummer($rolNummer);
    }
    /**
     * Get rolOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRolOmschrijving()
    {
        return isset($this->rolOmschrijving) ? $this->rolOmschrijving : null;
    }
    /**
     * Set rolOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rolOmschrijving
     * @return \StructType\RolV4
     */
    public function setRolOmschrijving($rolOmschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rolOmschrijving) && strlen($rolOmschrijving) > 4000) || (is_array($rolOmschrijving) && count($rolOmschrijving) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($rolOmschrijving) ? strlen($rolOmschrijving) : count($rolOmschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rolOmschrijving) && !is_string($rolOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rolOmschrijving)), __LINE__);
        }
        if (is_null($rolOmschrijving) || (is_array($rolOmschrijving) && empty($rolOmschrijving))) {
            unset($this->rolOmschrijving);
        } else {
            $this->rolOmschrijving = $rolOmschrijving;
        }
        return $this;
    }
    /**
     * Get rolBeheerder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRolBeheerder()
    {
        return isset($this->rolBeheerder) ? $this->rolBeheerder : null;
    }
    /**
     * Set rolBeheerder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rolBeheerder
     * @return \StructType\RolV4
     */
    public function setRolBeheerder($rolBeheerder = null)
    {
        // validation for constraint: totalDigits
        if (is_float($rolBeheerder) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $rolBeheerder)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($rolBeheerder, strpos($rolBeheerder, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($rolBeheerder) && !is_numeric($rolBeheerder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rolBeheerder)), __LINE__);
        }
        if (is_null($rolBeheerder) || (is_array($rolBeheerder) && empty($rolBeheerder))) {
            unset($this->rolBeheerder);
        } else {
            $this->rolBeheerder = $rolBeheerder;
        }
        return $this;
    }
    /**
     * Get rolNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRolNummer()
    {
        return isset($this->rolNummer) ? $this->rolNummer : null;
    }
    /**
     * Set rolNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rolNummer
     * @return \StructType\RolV4
     */
    public function setRolNummer($rolNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($rolNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $rolNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($rolNummer, strpos($rolNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($rolNummer) && !is_numeric($rolNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rolNummer)), __LINE__);
        }
        if (is_null($rolNummer) || (is_array($rolNummer) && empty($rolNummer))) {
            unset($this->rolNummer);
        } else {
            $this->rolNummer = $rolNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RolV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
