<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KlachtV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Klacht informatie.
 * @subpackage Structs
 */
class KlachtV4 extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The klachtErnstig
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie ernstige klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtErnstig;
    /**
     * The klachtHerhaald
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie herhaalde klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtHerhaald;
    /**
     * The klachtNo
     * Meta informations extracted from the WSDL
     * - documentation: Klachtnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $klachtNo;
    /**
     * The klachtOnderwerpCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het klachtonderwerp.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $klachtOnderwerpCode;
    /**
     * The klachtOnderwerpOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van het klachtonderwerp.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 250
     * @var string
     */
    public $klachtOnderwerpOmschr;
    /**
     * The klachtSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de klachtsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $klachtSoortCode;
    /**
     * The klachtSoortOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de klachtsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 250
     * @var string
     */
    public $klachtSoortOmschr;
    /**
     * The klachtToelichting
     * Meta informations extracted from the WSDL
     * - documentation: Toelichting bij de klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $klachtToelichting;
    /**
     * The klachtVerschDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum waarover geklaagd is. Dit is in het systeem de verschijningsdatum van een editie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtVerschDatum;
    /**
     * The meldDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum van de klacht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $meldDatum;
    /**
     * The klachtStatusCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de klachtstatus.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 25
     * @var string
     */
    public $klachtStatusCode;
    /**
     * The klachtStatusOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de klachtstatus.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 250
     * @var string
     */
    public $klachtStatusOmschr;
    /**
     * The canCancel
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of deze klacht geannuleerd mag worden, als de abonnee vindt dat het bij nader inzien een onterechte klacht is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCancel;
    /**
     * The klachtAfgehandeld
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of de klacht is afgehandeld.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtAfgehandeld;
    /**
     * The klachtNazenden
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of er gaat worden nagezonden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtNazenden;
    /**
     * Constructor method for KlachtV4
     * @uses KlachtV4::setAboNo()
     * @uses KlachtV4::setKlachtErnstig()
     * @uses KlachtV4::setKlachtHerhaald()
     * @uses KlachtV4::setKlachtNo()
     * @uses KlachtV4::setKlachtOnderwerpCode()
     * @uses KlachtV4::setKlachtOnderwerpOmschr()
     * @uses KlachtV4::setKlachtSoortCode()
     * @uses KlachtV4::setKlachtSoortOmschr()
     * @uses KlachtV4::setKlachtToelichting()
     * @uses KlachtV4::setKlachtVerschDatum()
     * @uses KlachtV4::setMeldDatum()
     * @uses KlachtV4::setKlachtStatusCode()
     * @uses KlachtV4::setKlachtStatusOmschr()
     * @uses KlachtV4::setCanCancel()
     * @uses KlachtV4::setKlachtAfgehandeld()
     * @uses KlachtV4::setKlachtNazenden()
     * @param int $aboNo
     * @param bool $klachtErnstig
     * @param bool $klachtHerhaald
     * @param int $klachtNo
     * @param string $klachtOnderwerpCode
     * @param string $klachtOnderwerpOmschr
     * @param string $klachtSoortCode
     * @param string $klachtSoortOmschr
     * @param string $klachtToelichting
     * @param string $klachtVerschDatum
     * @param string $meldDatum
     * @param string $klachtStatusCode
     * @param string $klachtStatusOmschr
     * @param bool $canCancel
     * @param bool $klachtAfgehandeld
     * @param bool $klachtNazenden
     */
    public function __construct($aboNo = null, $klachtErnstig = null, $klachtHerhaald = null, $klachtNo = null, $klachtOnderwerpCode = null, $klachtOnderwerpOmschr = null, $klachtSoortCode = null, $klachtSoortOmschr = null, $klachtToelichting = null, $klachtVerschDatum = null, $meldDatum = null, $klachtStatusCode = null, $klachtStatusOmschr = null, $canCancel = null, $klachtAfgehandeld = null, $klachtNazenden = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setKlachtErnstig($klachtErnstig)
            ->setKlachtHerhaald($klachtHerhaald)
            ->setKlachtNo($klachtNo)
            ->setKlachtOnderwerpCode($klachtOnderwerpCode)
            ->setKlachtOnderwerpOmschr($klachtOnderwerpOmschr)
            ->setKlachtSoortCode($klachtSoortCode)
            ->setKlachtSoortOmschr($klachtSoortOmschr)
            ->setKlachtToelichting($klachtToelichting)
            ->setKlachtVerschDatum($klachtVerschDatum)
            ->setMeldDatum($meldDatum)
            ->setKlachtStatusCode($klachtStatusCode)
            ->setKlachtStatusOmschr($klachtStatusOmschr)
            ->setCanCancel($canCancel)
            ->setKlachtAfgehandeld($klachtAfgehandeld)
            ->setKlachtNazenden($klachtNazenden);
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \StructType\KlachtV4
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get klachtErnstig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtErnstig()
    {
        return isset($this->klachtErnstig) ? $this->klachtErnstig : null;
    }
    /**
     * Set klachtErnstig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtErnstig
     * @return \StructType\KlachtV4
     */
    public function setKlachtErnstig($klachtErnstig = null)
    {
        if (is_null($klachtErnstig) || (is_array($klachtErnstig) && empty($klachtErnstig))) {
            unset($this->klachtErnstig);
        } else {
            $this->klachtErnstig = $klachtErnstig;
        }
        return $this;
    }
    /**
     * Get klachtHerhaald value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtHerhaald()
    {
        return isset($this->klachtHerhaald) ? $this->klachtHerhaald : null;
    }
    /**
     * Set klachtHerhaald value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtHerhaald
     * @return \StructType\KlachtV4
     */
    public function setKlachtHerhaald($klachtHerhaald = null)
    {
        if (is_null($klachtHerhaald) || (is_array($klachtHerhaald) && empty($klachtHerhaald))) {
            unset($this->klachtHerhaald);
        } else {
            $this->klachtHerhaald = $klachtHerhaald;
        }
        return $this;
    }
    /**
     * Get klachtNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKlachtNo()
    {
        return isset($this->klachtNo) ? $this->klachtNo : null;
    }
    /**
     * Set klachtNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $klachtNo
     * @return \StructType\KlachtV4
     */
    public function setKlachtNo($klachtNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($klachtNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $klachtNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($klachtNo, strpos($klachtNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($klachtNo) && !is_numeric($klachtNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($klachtNo)), __LINE__);
        }
        if (is_null($klachtNo) || (is_array($klachtNo) && empty($klachtNo))) {
            unset($this->klachtNo);
        } else {
            $this->klachtNo = $klachtNo;
        }
        return $this;
    }
    /**
     * Get klachtOnderwerpCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtOnderwerpCode()
    {
        return isset($this->klachtOnderwerpCode) ? $this->klachtOnderwerpCode : null;
    }
    /**
     * Set klachtOnderwerpCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtOnderwerpCode
     * @return \StructType\KlachtV4
     */
    public function setKlachtOnderwerpCode($klachtOnderwerpCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtOnderwerpCode) && strlen($klachtOnderwerpCode) > 30) || (is_array($klachtOnderwerpCode) && count($klachtOnderwerpCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($klachtOnderwerpCode) ? strlen($klachtOnderwerpCode) : count($klachtOnderwerpCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtOnderwerpCode) && !is_string($klachtOnderwerpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtOnderwerpCode)), __LINE__);
        }
        if (is_null($klachtOnderwerpCode) || (is_array($klachtOnderwerpCode) && empty($klachtOnderwerpCode))) {
            unset($this->klachtOnderwerpCode);
        } else {
            $this->klachtOnderwerpCode = $klachtOnderwerpCode;
        }
        return $this;
    }
    /**
     * Get klachtOnderwerpOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtOnderwerpOmschr()
    {
        return isset($this->klachtOnderwerpOmschr) ? $this->klachtOnderwerpOmschr : null;
    }
    /**
     * Set klachtOnderwerpOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtOnderwerpOmschr
     * @return \StructType\KlachtV4
     */
    public function setKlachtOnderwerpOmschr($klachtOnderwerpOmschr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtOnderwerpOmschr) && strlen($klachtOnderwerpOmschr) > 250) || (is_array($klachtOnderwerpOmschr) && count($klachtOnderwerpOmschr) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($klachtOnderwerpOmschr) ? strlen($klachtOnderwerpOmschr) : count($klachtOnderwerpOmschr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtOnderwerpOmschr) && !is_string($klachtOnderwerpOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtOnderwerpOmschr)), __LINE__);
        }
        if (is_null($klachtOnderwerpOmschr) || (is_array($klachtOnderwerpOmschr) && empty($klachtOnderwerpOmschr))) {
            unset($this->klachtOnderwerpOmschr);
        } else {
            $this->klachtOnderwerpOmschr = $klachtOnderwerpOmschr;
        }
        return $this;
    }
    /**
     * Get klachtSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtSoortCode()
    {
        return isset($this->klachtSoortCode) ? $this->klachtSoortCode : null;
    }
    /**
     * Set klachtSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtSoortCode
     * @return \StructType\KlachtV4
     */
    public function setKlachtSoortCode($klachtSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtSoortCode) && strlen($klachtSoortCode) > 30) || (is_array($klachtSoortCode) && count($klachtSoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($klachtSoortCode) ? strlen($klachtSoortCode) : count($klachtSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtSoortCode) && !is_string($klachtSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtSoortCode)), __LINE__);
        }
        if (is_null($klachtSoortCode) || (is_array($klachtSoortCode) && empty($klachtSoortCode))) {
            unset($this->klachtSoortCode);
        } else {
            $this->klachtSoortCode = $klachtSoortCode;
        }
        return $this;
    }
    /**
     * Get klachtSoortOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtSoortOmschr()
    {
        return isset($this->klachtSoortOmschr) ? $this->klachtSoortOmschr : null;
    }
    /**
     * Set klachtSoortOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtSoortOmschr
     * @return \StructType\KlachtV4
     */
    public function setKlachtSoortOmschr($klachtSoortOmschr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtSoortOmschr) && strlen($klachtSoortOmschr) > 250) || (is_array($klachtSoortOmschr) && count($klachtSoortOmschr) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($klachtSoortOmschr) ? strlen($klachtSoortOmschr) : count($klachtSoortOmschr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtSoortOmschr) && !is_string($klachtSoortOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtSoortOmschr)), __LINE__);
        }
        if (is_null($klachtSoortOmschr) || (is_array($klachtSoortOmschr) && empty($klachtSoortOmschr))) {
            unset($this->klachtSoortOmschr);
        } else {
            $this->klachtSoortOmschr = $klachtSoortOmschr;
        }
        return $this;
    }
    /**
     * Get klachtToelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtToelichting()
    {
        return isset($this->klachtToelichting) ? $this->klachtToelichting : null;
    }
    /**
     * Set klachtToelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtToelichting
     * @return \StructType\KlachtV4
     */
    public function setKlachtToelichting($klachtToelichting = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtToelichting) && strlen($klachtToelichting) > 255) || (is_array($klachtToelichting) && count($klachtToelichting) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($klachtToelichting) ? strlen($klachtToelichting) : count($klachtToelichting)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtToelichting) && !is_string($klachtToelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtToelichting)), __LINE__);
        }
        if (is_null($klachtToelichting) || (is_array($klachtToelichting) && empty($klachtToelichting))) {
            unset($this->klachtToelichting);
        } else {
            $this->klachtToelichting = $klachtToelichting;
        }
        return $this;
    }
    /**
     * Get klachtVerschDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtVerschDatum()
    {
        return isset($this->klachtVerschDatum) ? $this->klachtVerschDatum : null;
    }
    /**
     * Set klachtVerschDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtVerschDatum
     * @return \StructType\KlachtV4
     */
    public function setKlachtVerschDatum($klachtVerschDatum = null)
    {
        // validation for constraint: string
        if (!is_null($klachtVerschDatum) && !is_string($klachtVerschDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtVerschDatum)), __LINE__);
        }
        if (is_null($klachtVerschDatum) || (is_array($klachtVerschDatum) && empty($klachtVerschDatum))) {
            unset($this->klachtVerschDatum);
        } else {
            $this->klachtVerschDatum = $klachtVerschDatum;
        }
        return $this;
    }
    /**
     * Get meldDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeldDatum()
    {
        return isset($this->meldDatum) ? $this->meldDatum : null;
    }
    /**
     * Set meldDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $meldDatum
     * @return \StructType\KlachtV4
     */
    public function setMeldDatum($meldDatum = null)
    {
        // validation for constraint: string
        if (!is_null($meldDatum) && !is_string($meldDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meldDatum)), __LINE__);
        }
        if (is_null($meldDatum) || (is_array($meldDatum) && empty($meldDatum))) {
            unset($this->meldDatum);
        } else {
            $this->meldDatum = $meldDatum;
        }
        return $this;
    }
    /**
     * Get klachtStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtStatusCode()
    {
        return isset($this->klachtStatusCode) ? $this->klachtStatusCode : null;
    }
    /**
     * Set klachtStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtStatusCode
     * @return \StructType\KlachtV4
     */
    public function setKlachtStatusCode($klachtStatusCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtStatusCode) && strlen($klachtStatusCode) > 25) || (is_array($klachtStatusCode) && count($klachtStatusCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($klachtStatusCode) ? strlen($klachtStatusCode) : count($klachtStatusCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtStatusCode) && !is_string($klachtStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtStatusCode)), __LINE__);
        }
        if (is_null($klachtStatusCode) || (is_array($klachtStatusCode) && empty($klachtStatusCode))) {
            unset($this->klachtStatusCode);
        } else {
            $this->klachtStatusCode = $klachtStatusCode;
        }
        return $this;
    }
    /**
     * Get klachtStatusOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtStatusOmschr()
    {
        return isset($this->klachtStatusOmschr) ? $this->klachtStatusOmschr : null;
    }
    /**
     * Set klachtStatusOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtStatusOmschr
     * @return \StructType\KlachtV4
     */
    public function setKlachtStatusOmschr($klachtStatusOmschr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($klachtStatusOmschr) && strlen($klachtStatusOmschr) > 250) || (is_array($klachtStatusOmschr) && count($klachtStatusOmschr) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($klachtStatusOmschr) ? strlen($klachtStatusOmschr) : count($klachtStatusOmschr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($klachtStatusOmschr) && !is_string($klachtStatusOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($klachtStatusOmschr)), __LINE__);
        }
        if (is_null($klachtStatusOmschr) || (is_array($klachtStatusOmschr) && empty($klachtStatusOmschr))) {
            unset($this->klachtStatusOmschr);
        } else {
            $this->klachtStatusOmschr = $klachtStatusOmschr;
        }
        return $this;
    }
    /**
     * Get canCancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCancel()
    {
        return isset($this->canCancel) ? $this->canCancel : null;
    }
    /**
     * Set canCancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCancel
     * @return \StructType\KlachtV4
     */
    public function setCanCancel($canCancel = null)
    {
        if (is_null($canCancel) || (is_array($canCancel) && empty($canCancel))) {
            unset($this->canCancel);
        } else {
            $this->canCancel = $canCancel;
        }
        return $this;
    }
    /**
     * Get klachtAfgehandeld value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtAfgehandeld()
    {
        return isset($this->klachtAfgehandeld) ? $this->klachtAfgehandeld : null;
    }
    /**
     * Set klachtAfgehandeld value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtAfgehandeld
     * @return \StructType\KlachtV4
     */
    public function setKlachtAfgehandeld($klachtAfgehandeld = null)
    {
        if (is_null($klachtAfgehandeld) || (is_array($klachtAfgehandeld) && empty($klachtAfgehandeld))) {
            unset($this->klachtAfgehandeld);
        } else {
            $this->klachtAfgehandeld = $klachtAfgehandeld;
        }
        return $this;
    }
    /**
     * Get klachtNazenden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtNazenden()
    {
        return isset($this->klachtNazenden) ? $this->klachtNazenden : null;
    }
    /**
     * Set klachtNazenden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtNazenden
     * @return \StructType\KlachtV4
     */
    public function setKlachtNazenden($klachtNazenden = null)
    {
        if (is_null($klachtNazenden) || (is_array($klachtNazenden) && empty($klachtNazenden))) {
            unset($this->klachtNazenden);
        } else {
            $this->klachtNazenden = $klachtNazenden;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KlachtV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
