<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KlachtTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst klachten.
 * @subpackage Structs
 */
class KlachtTabV4 extends AbstractStructBase
{
    /**
     * The klacht
     * Meta informations extracted from the WSDL
     * - documentation: Lijst klachten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\KlachtV4[]
     */
    public $klacht;
    /**
     * Constructor method for KlachtTabV4
     * @uses KlachtTabV4::setKlacht()
     * @param \StructType\KlachtV4[] $klacht
     */
    public function __construct(array $klacht = array())
    {
        $this
            ->setKlacht($klacht);
    }
    /**
     * Get klacht value
     * @return \StructType\KlachtV4[]|null
     */
    public function getKlacht()
    {
        return $this->klacht;
    }
    /**
     * Set klacht value
     * @throws \InvalidArgumentException
     * @param \StructType\KlachtV4[] $klacht
     * @return \StructType\KlachtTabV4
     */
    public function setKlacht(array $klacht = array())
    {
        foreach ($klacht as $klachtTabV4KlachtItem) {
            // validation for constraint: itemType
            if (!$klachtTabV4KlachtItem instanceof \StructType\KlachtV4) {
                throw new \InvalidArgumentException(sprintf('The klacht property can only contain items of \StructType\KlachtV4, "%s" given', is_object($klachtTabV4KlachtItem) ? get_class($klachtTabV4KlachtItem) : gettype($klachtTabV4KlachtItem)), __LINE__);
            }
        }
        $this->klacht = $klacht;
        return $this;
    }
    /**
     * Add item to klacht value
     * @throws \InvalidArgumentException
     * @param \StructType\KlachtV4 $item
     * @return \StructType\KlachtTabV4
     */
    public function addToKlacht(\StructType\KlachtV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KlachtV4) {
            throw new \InvalidArgumentException(sprintf('The klacht property can only contain items of \StructType\KlachtV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->klacht[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KlachtTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
