<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden kenmerken.
 * @subpackage Structs
 */
class KenmerkInfoV4 extends AbstractStructBase
{
    /**
     * The kenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden kenmerken.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\KenmerkV4[]
     */
    public $kenmerk;
    /**
     * Constructor method for KenmerkInfoV4
     * @uses KenmerkInfoV4::setKenmerk()
     * @param \StructType\KenmerkV4[] $kenmerk
     */
    public function __construct(array $kenmerk = array())
    {
        $this
            ->setKenmerk($kenmerk);
    }
    /**
     * Get kenmerk value
     * @return \StructType\KenmerkV4[]|null
     */
    public function getKenmerk()
    {
        return $this->kenmerk;
    }
    /**
     * Set kenmerk value
     * @throws \InvalidArgumentException
     * @param \StructType\KenmerkV4[] $kenmerk
     * @return \StructType\KenmerkInfoV4
     */
    public function setKenmerk(array $kenmerk = array())
    {
        foreach ($kenmerk as $kenmerkInfoV4KenmerkItem) {
            // validation for constraint: itemType
            if (!$kenmerkInfoV4KenmerkItem instanceof \StructType\KenmerkV4) {
                throw new \InvalidArgumentException(sprintf('The kenmerk property can only contain items of \StructType\KenmerkV4, "%s" given', is_object($kenmerkInfoV4KenmerkItem) ? get_class($kenmerkInfoV4KenmerkItem) : gettype($kenmerkInfoV4KenmerkItem)), __LINE__);
            }
        }
        $this->kenmerk = $kenmerk;
        return $this;
    }
    /**
     * Add item to kenmerk value
     * @throws \InvalidArgumentException
     * @param \StructType\KenmerkV4 $item
     * @return \StructType\KenmerkInfoV4
     */
    public function addToKenmerk(\StructType\KenmerkV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KenmerkV4) {
            throw new \InvalidArgumentException(sprintf('The kenmerk property can only contain items of \StructType\KenmerkV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->kenmerk[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KenmerkInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
