<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPropositieInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft informatie terug over een propositie voor de gegeven actieCode</p> <p>In de default implementatie worden alleen gegevens terugegeven voor abonnementsoorten die bij de Actieve Stamgegevens op actief zijn gezet.
 * @subpackage Structs
 */
class GetPropositieInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: Actiecode. Moet bestaan in de actietabel
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $actieCode;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Uitgave code. Moet bestaan in de uitgaventabel. Indien deze is meegegeven worden alleen de proposities van de opgegeven uitgave teruggegeven.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $uitgaveCode;
    /**
     * The landCode
     * Meta informations extracted from the WSDL
     * - documentation: Landcode. Moet bestaan in de landentabel. Indien meegegeven wordt in het return object de prijs voor het opgegeven land teruggegeven.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $landCode;
    /**
     * The negeerActStamgegevensInt
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie negeer actieve stamgegevens. false (Default) = Hou rekening met inrichting actieve stamgegevens. true = Negeer actieve stamgegevens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $negeerActStamgegevensInt;
    /**
     * Constructor method for getPropositieInfoRequest
     * @uses GetPropositieInfoRequest::setRequestTag()
     * @uses GetPropositieInfoRequest::setActieCode()
     * @uses GetPropositieInfoRequest::setUitgaveCode()
     * @uses GetPropositieInfoRequest::setLandCode()
     * @uses GetPropositieInfoRequest::setNegeerActStamgegevensInt()
     * @param string $requestTag
     * @param string $actieCode
     * @param string $uitgaveCode
     * @param string $landCode
     * @param bool $negeerActStamgegevensInt
     */
    public function __construct($requestTag = null, $actieCode = null, $uitgaveCode = null, $landCode = null, $negeerActStamgegevensInt = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setActieCode($actieCode)
            ->setUitgaveCode($uitgaveCode)
            ->setLandCode($landCode)
            ->setNegeerActStamgegevensInt($negeerActStamgegevensInt);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetPropositieInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get actieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieCode()
    {
        return isset($this->actieCode) ? $this->actieCode : null;
    }
    /**
     * Set actieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieCode
     * @return \StructType\GetPropositieInfoRequest
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieCode) && strlen($actieCode) > 15) || (is_array($actieCode) && count($actieCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($actieCode) ? strlen($actieCode) : count($actieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieCode)), __LINE__);
        }
        if (is_null($actieCode) || (is_array($actieCode) && empty($actieCode))) {
            unset($this->actieCode);
        } else {
            $this->actieCode = $actieCode;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\GetPropositieInfoRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 12) || (is_array($uitgaveCode) && count($uitgaveCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \StructType\GetPropositieInfoRequest
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($landCode) && strlen($landCode) > 3) || (is_array($landCode) && count($landCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($landCode) ? strlen($landCode) : count($landCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get negeerActStamgegevensInt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNegeerActStamgegevensInt()
    {
        return isset($this->negeerActStamgegevensInt) ? $this->negeerActStamgegevensInt : null;
    }
    /**
     * Set negeerActStamgegevensInt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $negeerActStamgegevensInt
     * @return \StructType\GetPropositieInfoRequest
     */
    public function setNegeerActStamgegevensInt($negeerActStamgegevensInt = null)
    {
        if (is_null($negeerActStamgegevensInt) || (is_array($negeerActStamgegevensInt) && empty($negeerActStamgegevensInt))) {
            unset($this->negeerActStamgegevensInt);
        } else {
            $this->negeerActStamgegevensInt = $negeerActStamgegevensInt;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPropositieInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
