<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPostcodeInfoResponse StructType
 * @subpackage Structs
 */
class GetPostcodeInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The huisNummerResult
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $huisNummerResult;
    /**
     * The postcodeResult
     * Meta informations extracted from the WSDL
     * - documentation: De postcode waarvoor het adres gevonden is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $postcodeResult;
    /**
     * The straat
     * Meta informations extracted from the WSDL
     * - documentation: De straatnaam behorende bij de postcode en huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $straat;
    /**
     * The woonplaats
     * Meta informations extracted from the WSDL
     * - documentation: De woonplaats behorende bij de postcode en huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 40
     * @var string
     */
    public $woonplaats;
    /**
     * Constructor method for getPostcodeInfoResponse
     * @uses GetPostcodeInfoResponse::setRequestTag()
     * @uses GetPostcodeInfoResponse::setHuisNummerResult()
     * @uses GetPostcodeInfoResponse::setPostcodeResult()
     * @uses GetPostcodeInfoResponse::setStraat()
     * @uses GetPostcodeInfoResponse::setWoonplaats()
     * @param string $requestTag
     * @param float $huisNummerResult
     * @param string $postcodeResult
     * @param string $straat
     * @param string $woonplaats
     */
    public function __construct($requestTag = null, $huisNummerResult = null, $postcodeResult = null, $straat = null, $woonplaats = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setHuisNummerResult($huisNummerResult)
            ->setPostcodeResult($postcodeResult)
            ->setStraat($straat)
            ->setWoonplaats($woonplaats);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetPostcodeInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get huisNummerResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHuisNummerResult()
    {
        return isset($this->huisNummerResult) ? $this->huisNummerResult : null;
    }
    /**
     * Set huisNummerResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $huisNummerResult
     * @return \StructType\GetPostcodeInfoResponse
     */
    public function setHuisNummerResult($huisNummerResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisNummerResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisNummerResult)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($huisNummerResult, strpos($huisNummerResult, '.')))), __LINE__);
        }
        if (is_null($huisNummerResult) || (is_array($huisNummerResult) && empty($huisNummerResult))) {
            unset($this->huisNummerResult);
        } else {
            $this->huisNummerResult = $huisNummerResult;
        }
        return $this;
    }
    /**
     * Get postcodeResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcodeResult()
    {
        return isset($this->postcodeResult) ? $this->postcodeResult : null;
    }
    /**
     * Set postcodeResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcodeResult
     * @return \StructType\GetPostcodeInfoResponse
     */
    public function setPostcodeResult($postcodeResult = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcodeResult) && strlen($postcodeResult) > 10) || (is_array($postcodeResult) && count($postcodeResult) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postcodeResult) ? strlen($postcodeResult) : count($postcodeResult)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcodeResult) && !is_string($postcodeResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcodeResult)), __LINE__);
        }
        if (is_null($postcodeResult) || (is_array($postcodeResult) && empty($postcodeResult))) {
            unset($this->postcodeResult);
        } else {
            $this->postcodeResult = $postcodeResult;
        }
        return $this;
    }
    /**
     * Get straat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraat()
    {
        return isset($this->straat) ? $this->straat : null;
    }
    /**
     * Set straat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straat
     * @return \StructType\GetPostcodeInfoResponse
     */
    public function setStraat($straat = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($straat) && strlen($straat) > 255) || (is_array($straat) && count($straat) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($straat) ? strlen($straat) : count($straat)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($straat) && !is_string($straat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($straat)), __LINE__);
        }
        if (is_null($straat) || (is_array($straat) && empty($straat))) {
            unset($this->straat);
        } else {
            $this->straat = $straat;
        }
        return $this;
    }
    /**
     * Get woonplaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWoonplaats()
    {
        return isset($this->woonplaats) ? $this->woonplaats : null;
    }
    /**
     * Set woonplaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $woonplaats
     * @return \StructType\GetPostcodeInfoResponse
     */
    public function setWoonplaats($woonplaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($woonplaats) && strlen($woonplaats) > 40) || (is_array($woonplaats) && count($woonplaats) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($woonplaats) ? strlen($woonplaats) : count($woonplaats)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($woonplaats) && !is_string($woonplaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($woonplaats)), __LINE__);
        }
        if (is_null($woonplaats) || (is_array($woonplaats) && empty($woonplaats))) {
            unset($this->woonplaats);
        } else {
            $this->woonplaats = $woonplaats;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPostcodeInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
