<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPakketInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen van de gegevens van een of meerdere (abonnements) pakketten. Hierbij kan gezocht worden op basis van de pakketcode en op inactieve pakketten.
 * @subpackage Structs
 */
class GetPakketInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket waarvan de informatie wordt opgevraagd. Indien leeg wordt van alle pakketten de gegevens opgehaald.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketCode;
    /**
     * The inclusiefInactieve
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of inactieve pakketten teruggegeven moet worden. false (Default) = Alleen actieve. true = Inclusief inactieve.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactieve;
    /**
     * Constructor method for getPakketInfoRequest
     * @uses GetPakketInfoRequest::setRequestTag()
     * @uses GetPakketInfoRequest::setPakketCode()
     * @uses GetPakketInfoRequest::setInclusiefInactieve()
     * @param string $requestTag
     * @param string $pakketCode
     * @param bool $inclusiefInactieve
     */
    public function __construct($requestTag = null, $pakketCode = null, $inclusiefInactieve = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPakketCode($pakketCode)
            ->setInclusiefInactieve($inclusiefInactieve);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetPakketInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\GetPakketInfoRequest
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get inclusiefInactieve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactieve()
    {
        return isset($this->inclusiefInactieve) ? $this->inclusiefInactieve : null;
    }
    /**
     * Set inclusiefInactieve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactieve
     * @return \StructType\GetPakketInfoRequest
     */
    public function setInclusiefInactieve($inclusiefInactieve = null)
    {
        if (is_null($inclusiefInactieve) || (is_array($inclusiefInactieve) && empty($inclusiefInactieve))) {
            unset($this->inclusiefInactieve);
        } else {
            $this->inclusiefInactieve = $inclusiefInactieve;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPakketInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
