<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLeverbareProductenInfoResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error182: De combinatie postcode/huisnummer is ongeldig | error186: De postcode dient te bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletters | error187: Het huisnummer dient geheel te bestaan uit cijfers
 * @subpackage Structs
 */
class GetLeverbareProductenInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The returnObject
     * Meta informations extracted from the WSDL
     * - documentation: Het object met leverbare producten op het opgegeven adres.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LeverbareProductenInfoV4
     */
    public $returnObject;
    /**
     * Constructor method for getLeverbareProductenInfoResponse
     * @uses GetLeverbareProductenInfoResponse::setRequestTag()
     * @uses GetLeverbareProductenInfoResponse::setReturnObject()
     * @param string $requestTag
     * @param \StructType\LeverbareProductenInfoV4 $returnObject
     */
    public function __construct($requestTag = null, \StructType\LeverbareProductenInfoV4 $returnObject = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setReturnObject($returnObject);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetLeverbareProductenInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get returnObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LeverbareProductenInfoV4|null
     */
    public function getReturnObject()
    {
        return isset($this->returnObject) ? $this->returnObject : null;
    }
    /**
     * Set returnObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LeverbareProductenInfoV4 $returnObject
     * @return \StructType\GetLeverbareProductenInfoResponse
     */
    public function setReturnObject(\StructType\LeverbareProductenInfoV4 $returnObject = null)
    {
        if (is_null($returnObject) || (is_array($returnObject) && empty($returnObject))) {
            unset($this->returnObject);
        } else {
            $this->returnObject = $returnObject;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLeverbareProductenInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
