<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getKenmerkInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft de kenmerken terug die gekoppeld zijn aan een bepaalde relatie.
 * @subpackage Structs
 */
class GetKenmerkInfoRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer waarvan de kenmerken teruggegeven moet worden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The kenmerkGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Indien gevuld, worden alleen de kenmerken van de gegeven relatie in deze gegeven kenmerkgroep teruggegeven.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $kenmerkGroepCode;
    /**
     * Constructor method for getKenmerkInfoRequest
     * @uses GetKenmerkInfoRequest::setRelNo()
     * @uses GetKenmerkInfoRequest::setRequestTag()
     * @uses GetKenmerkInfoRequest::setKenmerkGroepCode()
     * @param int $relNo
     * @param string $requestTag
     * @param string $kenmerkGroepCode
     */
    public function __construct($relNo = null, $requestTag = null, $kenmerkGroepCode = null)
    {
        $this
            ->setRelNo($relNo)
            ->setRequestTag($requestTag)
            ->setKenmerkGroepCode($kenmerkGroepCode);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \StructType\GetKenmerkInfoRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetKenmerkInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get kenmerkGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKenmerkGroepCode()
    {
        return isset($this->kenmerkGroepCode) ? $this->kenmerkGroepCode : null;
    }
    /**
     * Set kenmerkGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kenmerkGroepCode
     * @return \StructType\GetKenmerkInfoRequest
     */
    public function setKenmerkGroepCode($kenmerkGroepCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kenmerkGroepCode) && strlen($kenmerkGroepCode) > 12) || (is_array($kenmerkGroepCode) && count($kenmerkGroepCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($kenmerkGroepCode) ? strlen($kenmerkGroepCode) : count($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kenmerkGroepCode) && !is_string($kenmerkGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kenmerkGroepCode)), __LINE__);
        }
        if (is_null($kenmerkGroepCode) || (is_array($kenmerkGroepCode) && empty($kenmerkGroepCode))) {
            unset($this->kenmerkGroepCode);
        } else {
            $this->kenmerkGroepCode = $kenmerkGroepCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetKenmerkInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
