<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCalamiteitInfoResponse StructType
 * @subpackage Structs
 */
class GetCalamiteitInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The calamiteiten
     * Meta informations extracted from the WSDL
     * - documentation: Object met de geldende calamiteiten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CalamiteitTabV4
     */
    public $calamiteiten;
    /**
     * The relNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer waarvoor de calamiteiten zijn bepaald. Kan afwijken van RelNo in geval van een ontdubbelde relatie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * Constructor method for getCalamiteitInfoResponse
     * @uses GetCalamiteitInfoResponse::setRequestTag()
     * @uses GetCalamiteitInfoResponse::setCalamiteiten()
     * @uses GetCalamiteitInfoResponse::setRelNoResult()
     * @param string $requestTag
     * @param \StructType\CalamiteitTabV4 $calamiteiten
     * @param int $relNoResult
     */
    public function __construct($requestTag = null, \StructType\CalamiteitTabV4 $calamiteiten = null, $relNoResult = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setCalamiteiten($calamiteiten)
            ->setRelNoResult($relNoResult);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\GetCalamiteitInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get calamiteiten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CalamiteitTabV4|null
     */
    public function getCalamiteiten()
    {
        return isset($this->calamiteiten) ? $this->calamiteiten : null;
    }
    /**
     * Set calamiteiten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CalamiteitTabV4 $calamiteiten
     * @return \StructType\GetCalamiteitInfoResponse
     */
    public function setCalamiteiten(\StructType\CalamiteitTabV4 $calamiteiten = null)
    {
        if (is_null($calamiteiten) || (is_array($calamiteiten) && empty($calamiteiten))) {
            unset($this->calamiteiten);
        } else {
            $this->calamiteiten = $calamiteiten;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \StructType\GetCalamiteitInfoResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoResult)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoResult, strpos($relNoResult, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoResult) && !is_numeric($relNoResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoResult)), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCalamiteitInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
