<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatBtwV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: BTW gegevens van een factuur samenvatting.
 * @subpackage Structs
 */
class FactSamenvatBtwV4 extends AbstractStructBase
{
    /**
     * The btwCode
     * Meta informations extracted from the WSDL
     * - documentation: Btw code.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $btwCode;
    /**
     * The btwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Btw percentage.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - fractionDigits: 1
     * - totalDigits: 16
     * @var float
     */
    public $btwPercentage;
    /**
     * The btwOverSubtotaal
     * Meta informations extracted from the WSDL
     * - documentation: Subtotaal waarover BTW wordt berekend.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $btwOverSubtotaal;
    /**
     * The btwBedrag
     * Meta informations extracted from the WSDL
     * - documentation: Btw bedrag.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $btwBedrag;
    /**
     * Constructor method for FactSamenvatBtwV4
     * @uses FactSamenvatBtwV4::setBtwCode()
     * @uses FactSamenvatBtwV4::setBtwPercentage()
     * @uses FactSamenvatBtwV4::setBtwOverSubtotaal()
     * @uses FactSamenvatBtwV4::setBtwBedrag()
     * @param string $btwCode
     * @param float $btwPercentage
     * @param float $btwOverSubtotaal
     * @param float $btwBedrag
     */
    public function __construct($btwCode = null, $btwPercentage = null, $btwOverSubtotaal = null, $btwBedrag = null)
    {
        $this
            ->setBtwCode($btwCode)
            ->setBtwPercentage($btwPercentage)
            ->setBtwOverSubtotaal($btwOverSubtotaal)
            ->setBtwBedrag($btwBedrag);
    }
    /**
     * Get btwCode value
     * @return string
     */
    public function getBtwCode()
    {
        return $this->btwCode;
    }
    /**
     * Set btwCode value
     * @param string $btwCode
     * @return \StructType\FactSamenvatBtwV4
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($btwCode) && strlen($btwCode) > 3) || (is_array($btwCode) && count($btwCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($btwCode) ? strlen($btwCode) : count($btwCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($btwCode) && strlen($btwCode) < 1) || (is_array($btwCode) && count($btwCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($btwCode)), __LINE__);
        }
        $this->btwCode = $btwCode;
        return $this;
    }
    /**
     * Get btwPercentage value
     * @return float
     */
    public function getBtwPercentage()
    {
        return $this->btwPercentage;
    }
    /**
     * Set btwPercentage value
     * @param float $btwPercentage
     * @return \StructType\FactSamenvatBtwV4
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($btwPercentage) && strlen(substr($btwPercentage, strpos($btwPercentage, '.'))) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 1 fraction digits, "%d" given', strlen(substr($btwPercentage, strpos($btwPercentage, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($btwPercentage) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwPercentage)) !== 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 16 digits, "%d" given', strlen(substr($btwPercentage, strpos($btwPercentage, '.')))), __LINE__);
        }
        $this->btwPercentage = $btwPercentage;
        return $this;
    }
    /**
     * Get btwOverSubtotaal value
     * @return float
     */
    public function getBtwOverSubtotaal()
    {
        return $this->btwOverSubtotaal;
    }
    /**
     * Set btwOverSubtotaal value
     * @param float $btwOverSubtotaal
     * @return \StructType\FactSamenvatBtwV4
     */
    public function setBtwOverSubtotaal($btwOverSubtotaal = null)
    {
        // validation for constraint: totalDigits
        if (is_float($btwOverSubtotaal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwOverSubtotaal)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($btwOverSubtotaal, strpos($btwOverSubtotaal, '.')))), __LINE__);
        }
        $this->btwOverSubtotaal = $btwOverSubtotaal;
        return $this;
    }
    /**
     * Get btwBedrag value
     * @return float
     */
    public function getBtwBedrag()
    {
        return $this->btwBedrag;
    }
    /**
     * Set btwBedrag value
     * @param float $btwBedrag
     * @return \StructType\FactSamenvatBtwV4
     */
    public function setBtwBedrag($btwBedrag = null)
    {
        // validation for constraint: totalDigits
        if (is_float($btwBedrag) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $btwBedrag)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($btwBedrag, strpos($btwBedrag, '.')))), __LINE__);
        }
        $this->btwBedrag = $btwBedrag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FactSamenvatBtwV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
