<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandR1noR2noResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error5: Er is geen relatie gevonden met het relatienummer van relatie 1 | error19: Er is geen relatienummer van relatie 1 opgegeven | error21: Er is geen relatie gevonden met het relatienummer van relatie 2 | error37: Er is geen
 * relatienummer van relatie 2 opgegeven | error134: Er is geen verbandCode opgegeven | error135: Er is geen verband gevonden met de opgegeven verbandCode | error170: Er bestaat al een relatieverband tussen relatie 1 en 2 met de opgegeven verbandcode
 * @subpackage Structs
 */
class CreateVerbandR1noR2noResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relNoRel1Result
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van Relatie 1. (kan afwijken van relNoRel1 input in geval van ontdubbelde relatie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1Result;
    /**
     * The relNoRel2Result
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van Relatie 2. (kan afwijken van relNoRel2 input in geval van ontdubbelde relatie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel2Result;
    /**
     * The verbandNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die het verband tussen Relatie 1 en Relatie 2 uniek identificeert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * Constructor method for createVerbandR1noR2noResponse
     * @uses CreateVerbandR1noR2noResponse::setRequestTag()
     * @uses CreateVerbandR1noR2noResponse::setRelNoRel1Result()
     * @uses CreateVerbandR1noR2noResponse::setRelNoRel2Result()
     * @uses CreateVerbandR1noR2noResponse::setVerbandNo()
     * @param string $requestTag
     * @param int $relNoRel1Result
     * @param int $relNoRel2Result
     * @param int $verbandNo
     */
    public function __construct($requestTag = null, $relNoRel1Result = null, $relNoRel2Result = null, $verbandNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNoRel1Result($relNoRel1Result)
            ->setRelNoRel2Result($relNoRel2Result)
            ->setVerbandNo($verbandNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVerbandR1noR2noResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNoRel1Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel1Result()
    {
        return isset($this->relNoRel1Result) ? $this->relNoRel1Result : null;
    }
    /**
     * Set relNoRel1Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel1Result
     * @return \StructType\CreateVerbandR1noR2noResponse
     */
    public function setRelNoRel1Result($relNoRel1Result = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoRel1Result) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoRel1Result)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoRel1Result, strpos($relNoRel1Result, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoRel1Result) && !is_numeric($relNoRel1Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoRel1Result)), __LINE__);
        }
        if (is_null($relNoRel1Result) || (is_array($relNoRel1Result) && empty($relNoRel1Result))) {
            unset($this->relNoRel1Result);
        } else {
            $this->relNoRel1Result = $relNoRel1Result;
        }
        return $this;
    }
    /**
     * Get relNoRel2Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel2Result()
    {
        return isset($this->relNoRel2Result) ? $this->relNoRel2Result : null;
    }
    /**
     * Set relNoRel2Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel2Result
     * @return \StructType\CreateVerbandR1noR2noResponse
     */
    public function setRelNoRel2Result($relNoRel2Result = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoRel2Result) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoRel2Result)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoRel2Result, strpos($relNoRel2Result, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoRel2Result) && !is_numeric($relNoRel2Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoRel2Result)), __LINE__);
        }
        if (is_null($relNoRel2Result) || (is_array($relNoRel2Result) && empty($relNoRel2Result))) {
            unset($this->relNoRel2Result);
        } else {
            $this->relNoRel2Result = $relNoRel2Result;
        }
        return $this;
    }
    /**
     * Get verbandNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVerbandNo()
    {
        return isset($this->verbandNo) ? $this->verbandNo : null;
    }
    /**
     * Set verbandNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $verbandNo
     * @return \StructType\CreateVerbandR1noR2noResponse
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($verbandNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $verbandNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($verbandNo, strpos($verbandNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($verbandNo) && !is_numeric($verbandNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($verbandNo)), __LINE__);
        }
        if (is_null($verbandNo) || (is_array($verbandNo) && empty($verbandNo))) {
            unset($this->verbandNo);
        } else {
            $this->verbandNo = $verbandNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVerbandR1noR2noResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
