<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandR1nawR2nawRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt een relatieverband tussen twee relaties aan. </p> <p>Een nieuwe klant wil een verband vastleggen tussen zijn/haar gebruiker en een andere nieuwe klant. </p> <p>Op basis van de meegegeven klantgegevens wordt bepaald of er klant
 * misschien al bekend is. Is er 1 match dan zal het de bestaande klant gebruikt worden. Zijn er meerdere mogelijkheden, dan zal dit teruggekoppeld worden. Betreft het een onbekende klant, dan zal een nieuwe klant aangemaakt worden. Het uiteindelijk
 * gebruikte relatienummer wordt geretourneerd met een indicatie of het een nieuwe of reeds bestaande klant betreft. Deze controle vindt plaats zo wel voor relatie 1 als relatie 2.
 * @subpackage Structs
 */
class CreateVerbandR1nawR2nawRequest extends AbstractStructBase
{
    /**
     * The persoonsObjectRel1
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens voor Relatie 1.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\PersoonsObjectV4
     */
    public $persoonsObjectRel1;
    /**
     * The adresObjectRel1
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens voor Relatie 1.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectRel1;
    /**
     * The persoonsObjectRel2
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens voor Relatie 2.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\PersoonsObjectV4
     */
    public $persoonsObjectRel2;
    /**
     * The adresObjectRel2
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens voor Relatie 2.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectRel2;
    /**
     * The verbandCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het te leggen verband. Moet een bestaande code zijn.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $verbandCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen verband aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVerbandR1nawR2nawRequest
     * @uses CreateVerbandR1nawR2nawRequest::setPersoonsObjectRel1()
     * @uses CreateVerbandR1nawR2nawRequest::setAdresObjectRel1()
     * @uses CreateVerbandR1nawR2nawRequest::setPersoonsObjectRel2()
     * @uses CreateVerbandR1nawR2nawRequest::setAdresObjectRel2()
     * @uses CreateVerbandR1nawR2nawRequest::setVerbandCode()
     * @uses CreateVerbandR1nawR2nawRequest::setRequestTag()
     * @uses CreateVerbandR1nawR2nawRequest::setCanCreate()
     * @param \StructType\PersoonsObjectV4 $persoonsObjectRel1
     * @param \StructType\AdresObjectV4 $adresObjectRel1
     * @param \StructType\PersoonsObjectV4 $persoonsObjectRel2
     * @param \StructType\AdresObjectV4 $adresObjectRel2
     * @param string $verbandCode
     * @param string $requestTag
     * @param bool $canCreate
     */
    public function __construct(\StructType\PersoonsObjectV4 $persoonsObjectRel1 = null, \StructType\AdresObjectV4 $adresObjectRel1 = null, \StructType\PersoonsObjectV4 $persoonsObjectRel2 = null, \StructType\AdresObjectV4 $adresObjectRel2 = null, $verbandCode = null, $requestTag = null, $canCreate = null)
    {
        $this
            ->setPersoonsObjectRel1($persoonsObjectRel1)
            ->setAdresObjectRel1($adresObjectRel1)
            ->setPersoonsObjectRel2($persoonsObjectRel2)
            ->setAdresObjectRel2($adresObjectRel2)
            ->setVerbandCode($verbandCode)
            ->setRequestTag($requestTag)
            ->setCanCreate($canCreate);
    }
    /**
     * Get persoonsObjectRel1 value
     * @return \StructType\PersoonsObjectV4
     */
    public function getPersoonsObjectRel1()
    {
        return $this->persoonsObjectRel1;
    }
    /**
     * Set persoonsObjectRel1 value
     * @param \StructType\PersoonsObjectV4 $persoonsObjectRel1
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setPersoonsObjectRel1(\StructType\PersoonsObjectV4 $persoonsObjectRel1 = null)
    {
        $this->persoonsObjectRel1 = $persoonsObjectRel1;
        return $this;
    }
    /**
     * Get adresObjectRel1 value
     * @return \StructType\AdresObjectV4
     */
    public function getAdresObjectRel1()
    {
        return $this->adresObjectRel1;
    }
    /**
     * Set adresObjectRel1 value
     * @param \StructType\AdresObjectV4 $adresObjectRel1
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setAdresObjectRel1(\StructType\AdresObjectV4 $adresObjectRel1 = null)
    {
        $this->adresObjectRel1 = $adresObjectRel1;
        return $this;
    }
    /**
     * Get persoonsObjectRel2 value
     * @return \StructType\PersoonsObjectV4
     */
    public function getPersoonsObjectRel2()
    {
        return $this->persoonsObjectRel2;
    }
    /**
     * Set persoonsObjectRel2 value
     * @param \StructType\PersoonsObjectV4 $persoonsObjectRel2
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setPersoonsObjectRel2(\StructType\PersoonsObjectV4 $persoonsObjectRel2 = null)
    {
        $this->persoonsObjectRel2 = $persoonsObjectRel2;
        return $this;
    }
    /**
     * Get adresObjectRel2 value
     * @return \StructType\AdresObjectV4
     */
    public function getAdresObjectRel2()
    {
        return $this->adresObjectRel2;
    }
    /**
     * Set adresObjectRel2 value
     * @param \StructType\AdresObjectV4 $adresObjectRel2
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setAdresObjectRel2(\StructType\AdresObjectV4 $adresObjectRel2 = null)
    {
        $this->adresObjectRel2 = $adresObjectRel2;
        return $this;
    }
    /**
     * Get verbandCode value
     * @return string
     */
    public function getVerbandCode()
    {
        return $this->verbandCode;
    }
    /**
     * Set verbandCode value
     * @param string $verbandCode
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setVerbandCode($verbandCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($verbandCode) && strlen($verbandCode) > 12) || (is_array($verbandCode) && count($verbandCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($verbandCode) ? strlen($verbandCode) : count($verbandCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($verbandCode) && strlen($verbandCode) < 1) || (is_array($verbandCode) && count($verbandCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($verbandCode) && !is_string($verbandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verbandCode)), __LINE__);
        }
        $this->verbandCode = $verbandCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVerbandR1nawR2nawRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
