<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVakantieRegelingRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt een vakantieregeling aan voor een abonnement van het type type 'onderbreking met verlenging' ,'vakantiebonnen', 'goed doel' of 'doorsturen'
 * @subpackage Structs
 */
class CreateVakantieRegelingRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het abonnement waarvoor de regeling geldt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The vakantieDatumVan
     * Meta informations extracted from the WSDL
     * - documentation: Regeling geldig vanaf. Moet in toekomst liggen.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $vakantieDatumVan;
    /**
     * The vakantieDatumTm
     * Meta informations extracted from the WSDL
     * - documentation: Regeling geldig tm. Moet na ingangsdatum liggen.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $vakantieDatumTm;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The persoonsObjectOntvanger
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens van de relatie die de tijdelijke ontvanger is. Verplicht bij vakantieRegelingType 5 (doorsturen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersoonsObjectV4
     */
    public $persoonsObjectOntvanger;
    /**
     * The adresObjectVakantie
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het tijdelijke adres, of het adres van de tijdelijke ontvanger. Verplicht bij vakantieRegelingType 4 (vakantieadres) en 5 (doorsturen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdresObjectV4
     */
    public $adresObjectVakantie;
    /**
     * The tijdelijkeAfdelingsNaam
     * Meta informations extracted from the WSDL
     * - documentation: Afdelings naam bij het tijdelijke adres. Toegestaan bij vakantieRegelingType 4 (vakantieadres).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $tijdelijkeAfdelingsNaam;
    /**
     * The vakantieRegelingType
     * Meta informations extracted from the WSDL
     * - documentation: [1,2,3,4,5,6] Soort vakantieregeling. 1 = Onderbreking + verlengen, 2 = Goed doel, 3 = Vakantie bonnen, 4 = Vakantieadres, 5=Doorsturen naar vriend of familie, 6 = Onderbreken zonder verlenging en restitutieregeling.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $vakantieRegelingType;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen vakantieregeling aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVakantieRegelingRequest
     * @uses CreateVakantieRegelingRequest::setAboNo()
     * @uses CreateVakantieRegelingRequest::setVakantieDatumVan()
     * @uses CreateVakantieRegelingRequest::setVakantieDatumTm()
     * @uses CreateVakantieRegelingRequest::setRequestTag()
     * @uses CreateVakantieRegelingRequest::setPersoonsObjectOntvanger()
     * @uses CreateVakantieRegelingRequest::setAdresObjectVakantie()
     * @uses CreateVakantieRegelingRequest::setTijdelijkeAfdelingsNaam()
     * @uses CreateVakantieRegelingRequest::setVakantieRegelingType()
     * @uses CreateVakantieRegelingRequest::setCanCreate()
     * @param int $aboNo
     * @param string $vakantieDatumVan
     * @param string $vakantieDatumTm
     * @param string $requestTag
     * @param \StructType\PersoonsObjectV4 $persoonsObjectOntvanger
     * @param \StructType\AdresObjectV4 $adresObjectVakantie
     * @param string $tijdelijkeAfdelingsNaam
     * @param float $vakantieRegelingType
     * @param bool $canCreate
     */
    public function __construct($aboNo = null, $vakantieDatumVan = null, $vakantieDatumTm = null, $requestTag = null, \StructType\PersoonsObjectV4 $persoonsObjectOntvanger = null, \StructType\AdresObjectV4 $adresObjectVakantie = null, $tijdelijkeAfdelingsNaam = null, $vakantieRegelingType = null, $canCreate = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setVakantieDatumVan($vakantieDatumVan)
            ->setVakantieDatumTm($vakantieDatumTm)
            ->setRequestTag($requestTag)
            ->setPersoonsObjectOntvanger($persoonsObjectOntvanger)
            ->setAdresObjectVakantie($adresObjectVakantie)
            ->setTijdelijkeAfdelingsNaam($tijdelijkeAfdelingsNaam)
            ->setVakantieRegelingType($vakantieRegelingType)
            ->setCanCreate($canCreate);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get vakantieDatumVan value
     * @return string
     */
    public function getVakantieDatumVan()
    {
        return $this->vakantieDatumVan;
    }
    /**
     * Set vakantieDatumVan value
     * @param string $vakantieDatumVan
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setVakantieDatumVan($vakantieDatumVan = null)
    {
        // validation for constraint: string
        if (!is_null($vakantieDatumVan) && !is_string($vakantieDatumVan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vakantieDatumVan)), __LINE__);
        }
        $this->vakantieDatumVan = $vakantieDatumVan;
        return $this;
    }
    /**
     * Get vakantieDatumTm value
     * @return string
     */
    public function getVakantieDatumTm()
    {
        return $this->vakantieDatumTm;
    }
    /**
     * Set vakantieDatumTm value
     * @param string $vakantieDatumTm
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setVakantieDatumTm($vakantieDatumTm = null)
    {
        // validation for constraint: string
        if (!is_null($vakantieDatumTm) && !is_string($vakantieDatumTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vakantieDatumTm)), __LINE__);
        }
        $this->vakantieDatumTm = $vakantieDatumTm;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get persoonsObjectOntvanger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersoonsObjectV4|null
     */
    public function getPersoonsObjectOntvanger()
    {
        return isset($this->persoonsObjectOntvanger) ? $this->persoonsObjectOntvanger : null;
    }
    /**
     * Set persoonsObjectOntvanger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersoonsObjectV4 $persoonsObjectOntvanger
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setPersoonsObjectOntvanger(\StructType\PersoonsObjectV4 $persoonsObjectOntvanger = null)
    {
        if (is_null($persoonsObjectOntvanger) || (is_array($persoonsObjectOntvanger) && empty($persoonsObjectOntvanger))) {
            unset($this->persoonsObjectOntvanger);
        } else {
            $this->persoonsObjectOntvanger = $persoonsObjectOntvanger;
        }
        return $this;
    }
    /**
     * Get adresObjectVakantie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdresObjectV4|null
     */
    public function getAdresObjectVakantie()
    {
        return isset($this->adresObjectVakantie) ? $this->adresObjectVakantie : null;
    }
    /**
     * Set adresObjectVakantie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdresObjectV4 $adresObjectVakantie
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setAdresObjectVakantie(\StructType\AdresObjectV4 $adresObjectVakantie = null)
    {
        if (is_null($adresObjectVakantie) || (is_array($adresObjectVakantie) && empty($adresObjectVakantie))) {
            unset($this->adresObjectVakantie);
        } else {
            $this->adresObjectVakantie = $adresObjectVakantie;
        }
        return $this;
    }
    /**
     * Get tijdelijkeAfdelingsNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTijdelijkeAfdelingsNaam()
    {
        return isset($this->tijdelijkeAfdelingsNaam) ? $this->tijdelijkeAfdelingsNaam : null;
    }
    /**
     * Set tijdelijkeAfdelingsNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tijdelijkeAfdelingsNaam
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setTijdelijkeAfdelingsNaam($tijdelijkeAfdelingsNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tijdelijkeAfdelingsNaam) && strlen($tijdelijkeAfdelingsNaam) > 4000) || (is_array($tijdelijkeAfdelingsNaam) && count($tijdelijkeAfdelingsNaam) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($tijdelijkeAfdelingsNaam) ? strlen($tijdelijkeAfdelingsNaam) : count($tijdelijkeAfdelingsNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tijdelijkeAfdelingsNaam) && !is_string($tijdelijkeAfdelingsNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tijdelijkeAfdelingsNaam)), __LINE__);
        }
        if (is_null($tijdelijkeAfdelingsNaam) || (is_array($tijdelijkeAfdelingsNaam) && empty($tijdelijkeAfdelingsNaam))) {
            unset($this->tijdelijkeAfdelingsNaam);
        } else {
            $this->tijdelijkeAfdelingsNaam = $tijdelijkeAfdelingsNaam;
        }
        return $this;
    }
    /**
     * Get vakantieRegelingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVakantieRegelingType()
    {
        return isset($this->vakantieRegelingType) ? $this->vakantieRegelingType : null;
    }
    /**
     * Set vakantieRegelingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vakantieRegelingType
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setVakantieRegelingType($vakantieRegelingType = null)
    {
        // validation for constraint: totalDigits
        if (is_float($vakantieRegelingType) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $vakantieRegelingType)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($vakantieRegelingType, strpos($vakantieRegelingType, '.')))), __LINE__);
        }
        if (is_null($vakantieRegelingType) || (is_array($vakantieRegelingType) && empty($vakantieRegelingType))) {
            unset($this->vakantieRegelingType);
        } else {
            $this->vakantieRegelingType = $vakantieRegelingType;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVakantieRegelingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
