<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createKlantKenmerkResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error5: De relatie is niet gevonden | error19: Er is geen relatie opgegeven | error173: Er is geen kenmerk opgegeven | error174: Het kenmerk is niet gevonden | error175: Het kenmerk is niet actief | error178: Er is geen kenmerkgroep
 * opgegeven | error179: De kenmerkgroep is niet gevonden
 * @subpackage Structs
 */
class CreateKlantKenmerkResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The kenmerkNo
     * Meta informations extracted from the WSDL
     * - documentation: Identifier die de combinatie relatie, kenmerk uniek identificeert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $kenmerkNo;
    /**
     * The relNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de relatie waar wie het kenmerk is gegeven. (kan afwijken van relNo input in geval van ontdubbelde relatie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * Constructor method for createKlantKenmerkResponse
     * @uses CreateKlantKenmerkResponse::setRequestTag()
     * @uses CreateKlantKenmerkResponse::setKenmerkNo()
     * @uses CreateKlantKenmerkResponse::setRelNoResult()
     * @param string $requestTag
     * @param int $kenmerkNo
     * @param int $relNoResult
     */
    public function __construct($requestTag = null, $kenmerkNo = null, $relNoResult = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setKenmerkNo($kenmerkNo)
            ->setRelNoResult($relNoResult);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateKlantKenmerkResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get kenmerkNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKenmerkNo()
    {
        return isset($this->kenmerkNo) ? $this->kenmerkNo : null;
    }
    /**
     * Set kenmerkNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kenmerkNo
     * @return \StructType\CreateKlantKenmerkResponse
     */
    public function setKenmerkNo($kenmerkNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($kenmerkNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $kenmerkNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($kenmerkNo, strpos($kenmerkNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($kenmerkNo) && !is_numeric($kenmerkNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kenmerkNo)), __LINE__);
        }
        if (is_null($kenmerkNo) || (is_array($kenmerkNo) && empty($kenmerkNo))) {
            unset($this->kenmerkNo);
        } else {
            $this->kenmerkNo = $kenmerkNo;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \StructType\CreateKlantKenmerkResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoResult)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoResult, strpos($relNoResult, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoResult) && !is_numeric($relNoResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoResult)), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateKlantKenmerkResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
