<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createKlantKenmerkRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt een kenmerk aan bij een relatie. Indien het kenmerk bij de relatie reeds bestaat dan kan deze niet nogmaals toegevoegd worden. Dit wordt niet gezien als een fout en wordt het nummer van het reeds geregistreerde kenmerk
 * geretourneerd.
 * @subpackage Structs
 */
class CreateKlantKenmerkRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van relatie.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The kenmerkCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het kenmerk. Moet bestaande en actieve kenmerkcode zijn.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $kenmerkCode;
    /**
     * The kenmerkGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de kenmerkgroep. Moet bestaande kenmerkgroepcode zijn.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $kenmerkGroepCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen kenmerk aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createKlantKenmerkRequest
     * @uses CreateKlantKenmerkRequest::setRelNo()
     * @uses CreateKlantKenmerkRequest::setKenmerkCode()
     * @uses CreateKlantKenmerkRequest::setKenmerkGroepCode()
     * @uses CreateKlantKenmerkRequest::setRequestTag()
     * @uses CreateKlantKenmerkRequest::setCanCreate()
     * @param int $relNo
     * @param string $kenmerkCode
     * @param string $kenmerkGroepCode
     * @param string $requestTag
     * @param bool $canCreate
     */
    public function __construct($relNo = null, $kenmerkCode = null, $kenmerkGroepCode = null, $requestTag = null, $canCreate = null)
    {
        $this
            ->setRelNo($relNo)
            ->setKenmerkCode($kenmerkCode)
            ->setKenmerkGroepCode($kenmerkGroepCode)
            ->setRequestTag($requestTag)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \StructType\CreateKlantKenmerkRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNo, strpos($relNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNo) && !is_numeric($relNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNo)), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get kenmerkCode value
     * @return string
     */
    public function getKenmerkCode()
    {
        return $this->kenmerkCode;
    }
    /**
     * Set kenmerkCode value
     * @param string $kenmerkCode
     * @return \StructType\CreateKlantKenmerkRequest
     */
    public function setKenmerkCode($kenmerkCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kenmerkCode) && strlen($kenmerkCode) > 12) || (is_array($kenmerkCode) && count($kenmerkCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($kenmerkCode) ? strlen($kenmerkCode) : count($kenmerkCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($kenmerkCode) && strlen($kenmerkCode) < 1) || (is_array($kenmerkCode) && count($kenmerkCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kenmerkCode) && !is_string($kenmerkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kenmerkCode)), __LINE__);
        }
        $this->kenmerkCode = $kenmerkCode;
        return $this;
    }
    /**
     * Get kenmerkGroepCode value
     * @return string
     */
    public function getKenmerkGroepCode()
    {
        return $this->kenmerkGroepCode;
    }
    /**
     * Set kenmerkGroepCode value
     * @param string $kenmerkGroepCode
     * @return \StructType\CreateKlantKenmerkRequest
     */
    public function setKenmerkGroepCode($kenmerkGroepCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kenmerkGroepCode) && strlen($kenmerkGroepCode) > 12) || (is_array($kenmerkGroepCode) && count($kenmerkGroepCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($kenmerkGroepCode) ? strlen($kenmerkGroepCode) : count($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($kenmerkGroepCode) && strlen($kenmerkGroepCode) < 1) || (is_array($kenmerkGroepCode) && count($kenmerkGroepCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kenmerkGroepCode) && !is_string($kenmerkGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kenmerkGroepCode)), __LINE__);
        }
        $this->kenmerkGroepCode = $kenmerkGroepCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\CreateKlantKenmerkRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \StructType\CreateKlantKenmerkRequest
     */
    public function setCanCreate($canCreate = null)
    {
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateKlantKenmerkRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
