<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalamiteitV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens van de gevonden calamiteit
 * @subpackage Structs
 */
class CalamiteitV4 extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementnummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The datum
     * Meta informations extracted from the WSDL
     * - documentation: Datum van de calamiteit.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $datum;
    /**
     * The omschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Korte omschrijving van de calamiteit.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $omschrijving;
    /**
     * The redenSleutel
     * Meta informations extracted from the WSDL
     * - documentation: Melding sleutel.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $redenSleutel;
    /**
     * The redenSoort
     * Meta informations extracted from the WSDL
     * - documentation: Melding soort.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $redenSoort;
    /**
     * The tijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd tot en met wanneer de calamiteit actief is.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $tijd;
    /**
     * Constructor method for CalamiteitV4
     * @uses CalamiteitV4::setAboNo()
     * @uses CalamiteitV4::setDatum()
     * @uses CalamiteitV4::setOmschrijving()
     * @uses CalamiteitV4::setRedenSleutel()
     * @uses CalamiteitV4::setRedenSoort()
     * @uses CalamiteitV4::setTijd()
     * @param int $aboNo
     * @param string $datum
     * @param string $omschrijving
     * @param string $redenSleutel
     * @param string $redenSoort
     * @param string $tijd
     */
    public function __construct($aboNo = null, $datum = null, $omschrijving = null, $redenSleutel = null, $redenSoort = null, $tijd = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setDatum($datum)
            ->setOmschrijving($omschrijving)
            ->setRedenSleutel($redenSleutel)
            ->setRedenSoort($redenSoort)
            ->setTijd($tijd);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\CalamiteitV4
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get datum value
     * @return string
     */
    public function getDatum()
    {
        return $this->datum;
    }
    /**
     * Set datum value
     * @param string $datum
     * @return \StructType\CalamiteitV4
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datum)), __LINE__);
        }
        $this->datum = $datum;
        return $this;
    }
    /**
     * Get omschrijving value
     * @return string
     */
    public function getOmschrijving()
    {
        return $this->omschrijving;
    }
    /**
     * Set omschrijving value
     * @param string $omschrijving
     * @return \StructType\CalamiteitV4
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) > 60) || (is_array($omschrijving) && count($omschrijving) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($omschrijving) ? strlen($omschrijving) : count($omschrijving)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) < 1) || (is_array($omschrijving) && count($omschrijving) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        $this->omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get redenSleutel value
     * @return string
     */
    public function getRedenSleutel()
    {
        return $this->redenSleutel;
    }
    /**
     * Set redenSleutel value
     * @param string $redenSleutel
     * @return \StructType\CalamiteitV4
     */
    public function setRedenSleutel($redenSleutel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($redenSleutel) && strlen($redenSleutel) > 10) || (is_array($redenSleutel) && count($redenSleutel) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($redenSleutel) ? strlen($redenSleutel) : count($redenSleutel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($redenSleutel) && strlen($redenSleutel) < 1) || (is_array($redenSleutel) && count($redenSleutel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redenSleutel) && !is_string($redenSleutel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redenSleutel)), __LINE__);
        }
        $this->redenSleutel = $redenSleutel;
        return $this;
    }
    /**
     * Get redenSoort value
     * @return string
     */
    public function getRedenSoort()
    {
        return $this->redenSoort;
    }
    /**
     * Set redenSoort value
     * @param string $redenSoort
     * @return \StructType\CalamiteitV4
     */
    public function setRedenSoort($redenSoort = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($redenSoort) && strlen($redenSoort) > 10) || (is_array($redenSoort) && count($redenSoort) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($redenSoort) ? strlen($redenSoort) : count($redenSoort)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($redenSoort) && strlen($redenSoort) < 1) || (is_array($redenSoort) && count($redenSoort) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redenSoort) && !is_string($redenSoort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redenSoort)), __LINE__);
        }
        $this->redenSoort = $redenSoort;
        return $this;
    }
    /**
     * Get tijd value
     * @return string
     */
    public function getTijd()
    {
        return $this->tijd;
    }
    /**
     * Set tijd value
     * @param string $tijd
     * @return \StructType\CalamiteitV4
     */
    public function setTijd($tijd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tijd) && strlen($tijd) > 10) || (is_array($tijd) && count($tijd) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($tijd) ? strlen($tijd) : count($tijd)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($tijd) && strlen($tijd) < 1) || (is_array($tijd) && count($tijd) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tijd) && !is_string($tijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tijd)), __LINE__);
        }
        $this->tijd = $tijd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalamiteitV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
