<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bestaatActiefAbonnementRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Check op een adres in combinatie met achternaam of daar al een actief abonnement aanwezig is. Deze controle houdt alleen rekening met nederlandse adressen.
 * @subpackage Structs
 */
class BestaatActiefAbonnementRequest extends AbstractStructBase
{
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The achternaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam van de (abonnee)relatie. Er wordt een match uitgevoerd op uppercase en o.b.v. de 1e 5 karakters.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $achternaam;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The huisNummerToevoeging
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevoeging. Match wordt uitgevoerd zonder spaties, '-' en op uppercase. Dit zoek argument is optioneel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $huisNummerToevoeging;
    /**
     * Constructor method for bestaatActiefAbonnementRequest
     * @uses BestaatActiefAbonnementRequest::setPostcode()
     * @uses BestaatActiefAbonnementRequest::setHuisNummer()
     * @uses BestaatActiefAbonnementRequest::setAchternaam()
     * @uses BestaatActiefAbonnementRequest::setRequestTag()
     * @uses BestaatActiefAbonnementRequest::setHuisNummerToevoeging()
     * @param string $postcode
     * @param float $huisNummer
     * @param string $achternaam
     * @param string $requestTag
     * @param string $huisNummerToevoeging
     */
    public function __construct($postcode = null, $huisNummer = null, $achternaam = null, $requestTag = null, $huisNummerToevoeging = null)
    {
        $this
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setAchternaam($achternaam)
            ->setRequestTag($requestTag)
            ->setHuisNummerToevoeging($huisNummerToevoeging);
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\BestaatActiefAbonnementRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 10) || (is_array($postcode) && count($postcode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postcode) && strlen($postcode) < 1) || (is_array($postcode) && count($postcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get huisNummer value
     * @return float
     */
    public function getHuisNummer()
    {
        return $this->huisNummer;
    }
    /**
     * Set huisNummer value
     * @param float $huisNummer
     * @return \StructType\BestaatActiefAbonnementRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($huisNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $huisNummer)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($huisNummer, strpos($huisNummer, '.')))), __LINE__);
        }
        $this->huisNummer = $huisNummer;
        return $this;
    }
    /**
     * Get achternaam value
     * @return string
     */
    public function getAchternaam()
    {
        return $this->achternaam;
    }
    /**
     * Set achternaam value
     * @param string $achternaam
     * @return \StructType\BestaatActiefAbonnementRequest
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($achternaam) && strlen($achternaam) > 120) || (is_array($achternaam) && count($achternaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($achternaam) ? strlen($achternaam) : count($achternaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($achternaam) && strlen($achternaam) < 1) || (is_array($achternaam) && count($achternaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achternaam)), __LINE__);
        }
        $this->achternaam = $achternaam;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\BestaatActiefAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get huisNummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToevoeging()
    {
        return isset($this->huisNummerToevoeging) ? $this->huisNummerToevoeging : null;
    }
    /**
     * Set huisNummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToevoeging
     * @return \StructType\BestaatActiefAbonnementRequest
     */
    public function setHuisNummerToevoeging($huisNummerToevoeging = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($huisNummerToevoeging) && strlen($huisNummerToevoeging) > 12) || (is_array($huisNummerToevoeging) && count($huisNummerToevoeging) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($huisNummerToevoeging) ? strlen($huisNummerToevoeging) : count($huisNummerToevoeging)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($huisNummerToevoeging) && !is_string($huisNummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($huisNummerToevoeging)), __LINE__);
        }
        if (is_null($huisNummerToevoeging) || (is_array($huisNummerToevoeging) && empty($huisNummerToevoeging))) {
            unset($this->huisNummerToevoeging);
        } else {
            $this->huisNummerToevoeging = $huisNummerToevoeging;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestaatActiefAbonnementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
