<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdresObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Het adresobject bestaat uit de volgende velden
 * @subpackage Structs
 */
class AdresObjectV4 extends AbstractStructBase
{
    /**
     * The relHuisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer, groter dan 0.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relHuisNummer;
    /**
     * The relPlaats
     * Meta informations extracted from the WSDL
     * - documentation: Woonplaats.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $relPlaats;
    /**
     * The relPostcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $relPostcode;
    /**
     * The relStraat
     * Meta informations extracted from the WSDL
     * - documentation: Straatnaam.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $relStraat;
    /**
     * The relHuisNummerToev
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevoeging.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $relHuisNummerToev;
    /**
     * The relLandCode
     * Meta informations extracted from the WSDL
     * - documentation: Land code, moet bestaan in de landen tabel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 3
     * @var string
     */
    public $relLandCode;
    /**
     * The relProvincieCode
     * Meta informations extracted from the WSDL
     * - documentation: De Provincie waar iemand woont. Alleen noodzakelijk en toegestaan voor buitenland. Code moet bestaan in de provincie tabel. Provincie moet gekoppeld zijn aan Land.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $relProvincieCode;
    /**
     * Constructor method for AdresObjectV4
     * @uses AdresObjectV4::setRelHuisNummer()
     * @uses AdresObjectV4::setRelPlaats()
     * @uses AdresObjectV4::setRelPostcode()
     * @uses AdresObjectV4::setRelStraat()
     * @uses AdresObjectV4::setRelHuisNummerToev()
     * @uses AdresObjectV4::setRelLandCode()
     * @uses AdresObjectV4::setRelProvincieCode()
     * @param int $relHuisNummer
     * @param string $relPlaats
     * @param string $relPostcode
     * @param string $relStraat
     * @param string $relHuisNummerToev
     * @param string $relLandCode
     * @param string $relProvincieCode
     */
    public function __construct($relHuisNummer = null, $relPlaats = null, $relPostcode = null, $relStraat = null, $relHuisNummerToev = null, $relLandCode = null, $relProvincieCode = null)
    {
        $this
            ->setRelHuisNummer($relHuisNummer)
            ->setRelPlaats($relPlaats)
            ->setRelPostcode($relPostcode)
            ->setRelStraat($relStraat)
            ->setRelHuisNummerToev($relHuisNummerToev)
            ->setRelLandCode($relLandCode)
            ->setRelProvincieCode($relProvincieCode);
    }
    /**
     * Get relHuisNummer value
     * @return int
     */
    public function getRelHuisNummer()
    {
        return $this->relHuisNummer;
    }
    /**
     * Set relHuisNummer value
     * @param int $relHuisNummer
     * @return \StructType\AdresObjectV4
     */
    public function setRelHuisNummer($relHuisNummer = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relHuisNummer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relHuisNummer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relHuisNummer, strpos($relHuisNummer, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relHuisNummer) && !is_numeric($relHuisNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relHuisNummer)), __LINE__);
        }
        $this->relHuisNummer = $relHuisNummer;
        return $this;
    }
    /**
     * Get relPlaats value
     * @return string
     */
    public function getRelPlaats()
    {
        return $this->relPlaats;
    }
    /**
     * Set relPlaats value
     * @param string $relPlaats
     * @return \StructType\AdresObjectV4
     */
    public function setRelPlaats($relPlaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($relPlaats) && strlen($relPlaats) > 40) || (is_array($relPlaats) && count($relPlaats) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($relPlaats) ? strlen($relPlaats) : count($relPlaats)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($relPlaats) && strlen($relPlaats) < 1) || (is_array($relPlaats) && count($relPlaats) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($relPlaats) && !is_string($relPlaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relPlaats)), __LINE__);
        }
        $this->relPlaats = $relPlaats;
        return $this;
    }
    /**
     * Get relPostcode value
     * @return string
     */
    public function getRelPostcode()
    {
        return $this->relPostcode;
    }
    /**
     * Set relPostcode value
     * @param string $relPostcode
     * @return \StructType\AdresObjectV4
     */
    public function setRelPostcode($relPostcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($relPostcode) && strlen($relPostcode) > 10) || (is_array($relPostcode) && count($relPostcode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($relPostcode) ? strlen($relPostcode) : count($relPostcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($relPostcode) && strlen($relPostcode) < 1) || (is_array($relPostcode) && count($relPostcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($relPostcode) && !is_string($relPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relPostcode)), __LINE__);
        }
        $this->relPostcode = $relPostcode;
        return $this;
    }
    /**
     * Get relStraat value
     * @return string
     */
    public function getRelStraat()
    {
        return $this->relStraat;
    }
    /**
     * Set relStraat value
     * @param string $relStraat
     * @return \StructType\AdresObjectV4
     */
    public function setRelStraat($relStraat = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($relStraat) && strlen($relStraat) > 255) || (is_array($relStraat) && count($relStraat) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($relStraat) ? strlen($relStraat) : count($relStraat)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($relStraat) && strlen($relStraat) < 1) || (is_array($relStraat) && count($relStraat) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($relStraat) && !is_string($relStraat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relStraat)), __LINE__);
        }
        $this->relStraat = $relStraat;
        return $this;
    }
    /**
     * Get relHuisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelHuisNummerToev()
    {
        return isset($this->relHuisNummerToev) ? $this->relHuisNummerToev : null;
    }
    /**
     * Set relHuisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relHuisNummerToev
     * @return \StructType\AdresObjectV4
     */
    public function setRelHuisNummerToev($relHuisNummerToev = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($relHuisNummerToev) && strlen($relHuisNummerToev) > 12) || (is_array($relHuisNummerToev) && count($relHuisNummerToev) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($relHuisNummerToev) ? strlen($relHuisNummerToev) : count($relHuisNummerToev)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($relHuisNummerToev) && !is_string($relHuisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relHuisNummerToev)), __LINE__);
        }
        if (is_null($relHuisNummerToev) || (is_array($relHuisNummerToev) && empty($relHuisNummerToev))) {
            unset($this->relHuisNummerToev);
        } else {
            $this->relHuisNummerToev = $relHuisNummerToev;
        }
        return $this;
    }
    /**
     * Get relLandCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelLandCode()
    {
        return isset($this->relLandCode) ? $this->relLandCode : null;
    }
    /**
     * Set relLandCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relLandCode
     * @return \StructType\AdresObjectV4
     */
    public function setRelLandCode($relLandCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($relLandCode) && strlen($relLandCode) > 3) || (is_array($relLandCode) && count($relLandCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($relLandCode) ? strlen($relLandCode) : count($relLandCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($relLandCode) && !is_string($relLandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relLandCode)), __LINE__);
        }
        if (is_null($relLandCode) || (is_array($relLandCode) && empty($relLandCode))) {
            unset($this->relLandCode);
        } else {
            $this->relLandCode = $relLandCode;
        }
        return $this;
    }
    /**
     * Get relProvincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelProvincieCode()
    {
        return isset($this->relProvincieCode) ? $this->relProvincieCode : null;
    }
    /**
     * Set relProvincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relProvincieCode
     * @return \StructType\AdresObjectV4
     */
    public function setRelProvincieCode($relProvincieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($relProvincieCode) && strlen($relProvincieCode) > 20) || (is_array($relProvincieCode) && count($relProvincieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($relProvincieCode) ? strlen($relProvincieCode) : count($relProvincieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($relProvincieCode) && !is_string($relProvincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relProvincieCode)), __LINE__);
        }
        if (is_null($relProvincieCode) || (is_array($relProvincieCode) && empty($relProvincieCode))) {
            unset($this->relProvincieCode);
        } else {
            $this->relProvincieCode = $relProvincieCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdresObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
