<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActieInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden acties.
 * @subpackage Structs
 */
class ActieInfoV4 extends AbstractStructBase
{
    /**
     * The actie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden acties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ActieV4[]
     */
    public $actie;
    /**
     * Constructor method for ActieInfoV4
     * @uses ActieInfoV4::setActie()
     * @param \StructType\ActieV4[] $actie
     */
    public function __construct(array $actie = array())
    {
        $this
            ->setActie($actie);
    }
    /**
     * Get actie value
     * @return \StructType\ActieV4[]|null
     */
    public function getActie()
    {
        return $this->actie;
    }
    /**
     * Set actie value
     * @throws \InvalidArgumentException
     * @param \StructType\ActieV4[] $actie
     * @return \StructType\ActieInfoV4
     */
    public function setActie(array $actie = array())
    {
        foreach ($actie as $actieInfoV4ActieItem) {
            // validation for constraint: itemType
            if (!$actieInfoV4ActieItem instanceof \StructType\ActieV4) {
                throw new \InvalidArgumentException(sprintf('The actie property can only contain items of \StructType\ActieV4, "%s" given', is_object($actieInfoV4ActieItem) ? get_class($actieInfoV4ActieItem) : gettype($actieInfoV4ActieItem)), __LINE__);
            }
        }
        $this->actie = $actie;
        return $this;
    }
    /**
     * Add item to actie value
     * @throws \InvalidArgumentException
     * @param \StructType\ActieV4 $item
     * @return \StructType\ActieInfoV4
     */
    public function addToActie(\StructType\ActieV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActieV4) {
            throw new \InvalidArgumentException(sprintf('The actie property can only contain items of \StructType\ActieV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->actie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActieInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
