<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementsoortInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden abonnementsoorten.
 * @subpackage Structs
 */
class AbonnementsoortInfoV4 extends AbstractStructBase
{
    /**
     * The abonnementsoort
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden abonnementsoorten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AbonnementsoortV4[]
     */
    public $abonnementsoort;
    /**
     * Constructor method for AbonnementsoortInfoV4
     * @uses AbonnementsoortInfoV4::setAbonnementsoort()
     * @param \StructType\AbonnementsoortV4[] $abonnementsoort
     */
    public function __construct(array $abonnementsoort = array())
    {
        $this
            ->setAbonnementsoort($abonnementsoort);
    }
    /**
     * Get abonnementsoort value
     * @return \StructType\AbonnementsoortV4[]|null
     */
    public function getAbonnementsoort()
    {
        return $this->abonnementsoort;
    }
    /**
     * Set abonnementsoort value
     * @throws \InvalidArgumentException
     * @param \StructType\AbonnementsoortV4[] $abonnementsoort
     * @return \StructType\AbonnementsoortInfoV4
     */
    public function setAbonnementsoort(array $abonnementsoort = array())
    {
        foreach ($abonnementsoort as $abonnementsoortInfoV4AbonnementsoortItem) {
            // validation for constraint: itemType
            if (!$abonnementsoortInfoV4AbonnementsoortItem instanceof \StructType\AbonnementsoortV4) {
                throw new \InvalidArgumentException(sprintf('The abonnementsoort property can only contain items of \StructType\AbonnementsoortV4, "%s" given', is_object($abonnementsoortInfoV4AbonnementsoortItem) ? get_class($abonnementsoortInfoV4AbonnementsoortItem) : gettype($abonnementsoortInfoV4AbonnementsoortItem)), __LINE__);
            }
        }
        $this->abonnementsoort = $abonnementsoort;
        return $this;
    }
    /**
     * Add item to abonnementsoort value
     * @throws \InvalidArgumentException
     * @param \StructType\AbonnementsoortV4 $item
     * @return \StructType\AbonnementsoortInfoV4
     */
    public function addToAbonnementsoort(\StructType\AbonnementsoortV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AbonnementsoortV4) {
            throw new \InvalidArgumentException(sprintf('The abonnementsoort property can only contain items of \StructType\AbonnementsoortV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->abonnementsoort[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbonnementsoortInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
