<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abonnement.
 * @subpackage Structs
 */
class AbonnementV4 extends AbstractStructBase
{
    /**
     * The aboKlachten
     * Meta informations extracted from the WSDL
     * - documentation: Klachten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KlachtTabV4
     */
    public $aboKlachten;
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsnummer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aboSoortIncassoVerplicht
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie automatisch incasso verplicht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboSoortIncassoVerplicht;
    /**
     * The aboSoortProefAbo
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie proefabonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboSoortProefAbo;
    /**
     * The aboSoortVrijeCode1
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 1 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode1;
    /**
     * The aboSoortVrijeCode2
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 1 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode2;
    /**
     * The aboSoortVrijeCode3
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 3 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode3;
    /**
     * The aboSoortVrijeCode4
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 4 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode4;
    /**
     * The aboSoortVrijeCode5
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 5 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode5;
    /**
     * The aboSoortVrijeCode6
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 6 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode6;
    /**
     * The aboSoortVrijeCode7
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 7 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode7;
    /**
     * The aboSoortVrijeCode8
     * Meta informations extracted from the WSDL
     * - documentation: Vrije code 8 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $aboSoortVrijeCode8;
    /**
     * The aboSoortVrijeTekst1
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 1 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst1;
    /**
     * The aboSoortVrijeTekst2
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 2 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst2;
    /**
     * The aboSoortVrijeTekst3
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 3 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst3;
    /**
     * The aboSoortVrijeTekst4
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 4 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst4;
    /**
     * The aboSoortVrijeTekst5
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 5 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst5;
    /**
     * The aboSoortVrijeTekst6
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 6 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst6;
    /**
     * The aboSoortVrijeTekst7
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 7 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst7;
    /**
     * The aboSoortVrijeTekst8
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 8 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst8;
    /**
     * The aboSoortVrijeTekst9
     * Meta informations extracted from the WSDL
     * - documentation: Vrije tekst 9 abonnementsoort.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $aboSoortVrijeTekst9;
    /**
     * The aboVerschInfos
     * Meta informations extracted from the WSDL
     * - documentation: Verschijningen retourneert een lijst met recente verschijningen van het abonnement. De informatie van de verschijningen bepaalt o.a. of er (nu) over een verschijning geklaagd mag worden, en of het mogelijk is een klacht in te voeren
     * met een verzoek om nabezorging. <br/>Business rules: <br/>N.B. indien op basis van het redelivery-type van PCM, dat in de P5 koppeling wordt doorgegeven aan Zeno, bepaald is dat voor een verschijning niet kan worden nabezorgd, dan worden de velden
     * NaBezZelfdeDagMogelijkTot en NaBezorgingMogelijkTot als NULL (=Leeg) teruggegeven.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VerschInfoTabV4
     */
    public $aboVerschInfos;
    /**
     * The aboVrijeVelden
     * Meta informations extracted from the WSDL
     * - documentation: Vrije velden van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VrijeVeldenAboRecV4
     */
    public $aboVrijeVelden;
    /**
     * The abonnementSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $abonnementSoortCode;
    /**
     * The abonnementSoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de abonnementsoort van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $abonnementSoortNaam;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de actie van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $actieCode;
    /**
     * The actieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de actie van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 100
     * @var string
     */
    public $actieNaam;
    /**
     * The artikelGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de artikelgroep van het abonnement (N.B. => Oude product).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $artikelGroepCode;
    /**
     * The artikelGroepNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de artikelgroep van het abonnement (N.B. => Oude product).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $artikelGroepNaam;
    /**
     * The artikelHoofdGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de artikelhoofdgroep van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 12
     * @var string
     */
    public $artikelHoofdGroepCode;
    /**
     * The artikelHoofdGroepNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de artikelhoofdgroep van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $artikelHoofdGroepNaam;
    /**
     * The bankRekeningNummer
     * Meta informations extracted from the WSDL
     * - documentation: Bankrekeningnummer voor het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $bankRekeningNummer;
    /**
     * The bankIbanNummer
     * Meta informations extracted from the WSDL
     * - documentation: IBAN voor het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $bankIbanNummer;
    /**
     * The bankBicCode
     * Meta informations extracted from the WSDL
     * - documentation: BIC voor het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $bankBicCode;
    /**
     * The betaalwijze
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,3,4,7] Betaalwijze voor het abonnement: 0 = Factuur, 1 = Eenmalige incasso, 3 = Eenmalige ideal, 4 = Factuur per mail, 7 = Creditcard
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $betaalwijze;
    /**
     * The eindDatum
     * Meta informations extracted from the WSDL
     * - documentation: Einddatum van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $eindDatum;
    /**
     * The herkomstCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de herkomst van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $herkomstCode;
    /**
     * The herkomstNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de herkomst van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $herkomstNaam;
    /**
     * The ingangsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Daadwerkelijke ingangsdatum van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ingangsDatum;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van het pakket van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $pakketNaam;
    /**
     * The premiumAboCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de premium voor de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $premiumAboCode;
    /**
     * The premiumAboNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de premium voor de abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $premiumAboNaam;
    /**
     * The premiumDebCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de premium voor de debiteur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 30
     * @var string
     */
    public $premiumDebCode;
    /**
     * The premiumDebNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de premium voor de debiteur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $premiumDebNaam;
    /**
     * The relNoAbo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer abonnee.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoAbo;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de uitgave van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de uitgave.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The leverStatus
     * Meta informations extracted from the WSDL
     * - documentation: Leverstatus van het abonnement (mogelijke waarden VERZENDSTOP, VERZENDFACTUURSTOP, ACTIEF).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $leverStatus;
    /**
     * The aantalExemplaren
     * Meta informations extracted from the WSDL
     * - documentation: Aantal exemplaren te verzenden bij dit abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantalExemplaren;
    /**
     * The organisatieLicentie
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of dit een organisatie licentie abonnement betreft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $organisatieLicentie;
    /**
     * The machtigingsKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Machtigingskenmerk in geval van automatische incasso i.c.m. SEPA.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * The aboRollen
     * Meta informations extracted from the WSDL
     * - documentation: Abonnements rollen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RolInfoV4
     */
    public $aboRollen;
    /**
     * The relNoDeb
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer debiteur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoDeb;
    /**
     * The prijsExtern
     * Meta informations extracted from the WSDL
     * - documentation: Extern bepaalde prijs voor het abonnement (let op, indien pakket geldt de prijs voor het hele pakket).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $prijsExtern;
    /**
     * The prijsPropositie
     * Meta informations extracted from the WSDL
     * - documentation: Propositieprijs geldend voor eerste contracttermijn (let op, indien pakket geldt de prijs voor het hele pakket).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 17
     * @var float
     */
    public $prijsPropositie;
    /**
     * The propositieCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de propositie waarmee het abonnement aangemaakt is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $propositieCode;
    /**
     * The propositieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de propositie waarmee het abonnement aangemaakt is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $propositieNaam;
    /**
     * The pakketVrijeCode1
     * Meta informations extracted from the WSDL
     * - documentation: De code van de vrije code 1 van het pakket
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $pakketVrijeCode1;
    /**
     * The pakketVrijeNaam1
     * Meta informations extracted from the WSDL
     * - documentation: De naam van de vrije code 1 van het pakket
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $pakketVrijeNaam1;
    /**
     * The aboOrdernummer
     * Meta informations extracted from the WSDL
     * - documentation: Ordernummer van besteller ter referentie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $aboOrdernummer;
    /**
     * The aboCreditcard
     * Meta informations extracted from the WSDL
     * - documentation: Creditcard gegevens (gevuld indien betaalwijze=7)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditcardV4
     */
    public $aboCreditcard;
    /**
     * The factuurAdres
     * Meta informations extracted from the WSDL
     * - documentation: Gegevens van het huidige factuur adres en tenaam stelling van de factuur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FactuurAdresV4
     */
    public $factuurAdres;
    /**
     * The datumLaatstVerzEditie
     * Meta informations extracted from the WSDL
     * - documentation: De verschijningsdatum van de laatst verzonden editie van dit abonnement, als die kan worden bepaald. Een dag later is bijvoorbeeld de eerst mogelijke verhuisdatum of de eerst mogelijke datum dat een vakantieregeling kan worden
     * aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumLaatstVerzEditie;
    /**
     * The stopredenCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de stopreden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $stopredenCode;
    /**
     * The stopredenNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de stopreden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 40
     * @var string
     */
    public $stopredenNaam;
    /**
     * Constructor method for AbonnementV4
     * @uses AbonnementV4::setAboKlachten()
     * @uses AbonnementV4::setAboNo()
     * @uses AbonnementV4::setAboSoortIncassoVerplicht()
     * @uses AbonnementV4::setAboSoortProefAbo()
     * @uses AbonnementV4::setAboSoortVrijeCode1()
     * @uses AbonnementV4::setAboSoortVrijeCode2()
     * @uses AbonnementV4::setAboSoortVrijeCode3()
     * @uses AbonnementV4::setAboSoortVrijeCode4()
     * @uses AbonnementV4::setAboSoortVrijeCode5()
     * @uses AbonnementV4::setAboSoortVrijeCode6()
     * @uses AbonnementV4::setAboSoortVrijeCode7()
     * @uses AbonnementV4::setAboSoortVrijeCode8()
     * @uses AbonnementV4::setAboSoortVrijeTekst1()
     * @uses AbonnementV4::setAboSoortVrijeTekst2()
     * @uses AbonnementV4::setAboSoortVrijeTekst3()
     * @uses AbonnementV4::setAboSoortVrijeTekst4()
     * @uses AbonnementV4::setAboSoortVrijeTekst5()
     * @uses AbonnementV4::setAboSoortVrijeTekst6()
     * @uses AbonnementV4::setAboSoortVrijeTekst7()
     * @uses AbonnementV4::setAboSoortVrijeTekst8()
     * @uses AbonnementV4::setAboSoortVrijeTekst9()
     * @uses AbonnementV4::setAboVerschInfos()
     * @uses AbonnementV4::setAboVrijeVelden()
     * @uses AbonnementV4::setAbonnementSoortCode()
     * @uses AbonnementV4::setAbonnementSoortNaam()
     * @uses AbonnementV4::setActieCode()
     * @uses AbonnementV4::setActieNaam()
     * @uses AbonnementV4::setArtikelGroepCode()
     * @uses AbonnementV4::setArtikelGroepNaam()
     * @uses AbonnementV4::setArtikelHoofdGroepCode()
     * @uses AbonnementV4::setArtikelHoofdGroepNaam()
     * @uses AbonnementV4::setBankRekeningNummer()
     * @uses AbonnementV4::setBankIbanNummer()
     * @uses AbonnementV4::setBankBicCode()
     * @uses AbonnementV4::setBetaalwijze()
     * @uses AbonnementV4::setEindDatum()
     * @uses AbonnementV4::setHerkomstCode()
     * @uses AbonnementV4::setHerkomstNaam()
     * @uses AbonnementV4::setIngangsDatum()
     * @uses AbonnementV4::setPakketCode()
     * @uses AbonnementV4::setPakketNaam()
     * @uses AbonnementV4::setPremiumAboCode()
     * @uses AbonnementV4::setPremiumAboNaam()
     * @uses AbonnementV4::setPremiumDebCode()
     * @uses AbonnementV4::setPremiumDebNaam()
     * @uses AbonnementV4::setRelNoAbo()
     * @uses AbonnementV4::setUitgaveCode()
     * @uses AbonnementV4::setUitgaveNaam()
     * @uses AbonnementV4::setLeverStatus()
     * @uses AbonnementV4::setAantalExemplaren()
     * @uses AbonnementV4::setOrganisatieLicentie()
     * @uses AbonnementV4::setMachtigingsKenmerk()
     * @uses AbonnementV4::setAboRollen()
     * @uses AbonnementV4::setRelNoDeb()
     * @uses AbonnementV4::setPrijsExtern()
     * @uses AbonnementV4::setPrijsPropositie()
     * @uses AbonnementV4::setPropositieCode()
     * @uses AbonnementV4::setPropositieNaam()
     * @uses AbonnementV4::setPakketVrijeCode1()
     * @uses AbonnementV4::setPakketVrijeNaam1()
     * @uses AbonnementV4::setAboOrdernummer()
     * @uses AbonnementV4::setAboCreditcard()
     * @uses AbonnementV4::setFactuurAdres()
     * @uses AbonnementV4::setDatumLaatstVerzEditie()
     * @uses AbonnementV4::setStopredenCode()
     * @uses AbonnementV4::setStopredenNaam()
     * @param \StructType\KlachtTabV4 $aboKlachten
     * @param int $aboNo
     * @param bool $aboSoortIncassoVerplicht
     * @param bool $aboSoortProefAbo
     * @param string $aboSoortVrijeCode1
     * @param string $aboSoortVrijeCode2
     * @param string $aboSoortVrijeCode3
     * @param string $aboSoortVrijeCode4
     * @param string $aboSoortVrijeCode5
     * @param string $aboSoortVrijeCode6
     * @param string $aboSoortVrijeCode7
     * @param string $aboSoortVrijeCode8
     * @param string $aboSoortVrijeTekst1
     * @param string $aboSoortVrijeTekst2
     * @param string $aboSoortVrijeTekst3
     * @param string $aboSoortVrijeTekst4
     * @param string $aboSoortVrijeTekst5
     * @param string $aboSoortVrijeTekst6
     * @param string $aboSoortVrijeTekst7
     * @param string $aboSoortVrijeTekst8
     * @param string $aboSoortVrijeTekst9
     * @param \StructType\VerschInfoTabV4 $aboVerschInfos
     * @param \StructType\VrijeVeldenAboRecV4 $aboVrijeVelden
     * @param string $abonnementSoortCode
     * @param string $abonnementSoortNaam
     * @param string $actieCode
     * @param string $actieNaam
     * @param string $artikelGroepCode
     * @param string $artikelGroepNaam
     * @param string $artikelHoofdGroepCode
     * @param string $artikelHoofdGroepNaam
     * @param string $bankRekeningNummer
     * @param string $bankIbanNummer
     * @param string $bankBicCode
     * @param int $betaalwijze
     * @param string $eindDatum
     * @param string $herkomstCode
     * @param string $herkomstNaam
     * @param string $ingangsDatum
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param string $premiumAboCode
     * @param string $premiumAboNaam
     * @param string $premiumDebCode
     * @param string $premiumDebNaam
     * @param int $relNoAbo
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param string $leverStatus
     * @param int $aantalExemplaren
     * @param bool $organisatieLicentie
     * @param string $machtigingsKenmerk
     * @param \StructType\RolInfoV4 $aboRollen
     * @param int $relNoDeb
     * @param float $prijsExtern
     * @param float $prijsPropositie
     * @param string $propositieCode
     * @param string $propositieNaam
     * @param string $pakketVrijeCode1
     * @param string $pakketVrijeNaam1
     * @param string $aboOrdernummer
     * @param \StructType\CreditcardV4 $aboCreditcard
     * @param \StructType\FactuurAdresV4 $factuurAdres
     * @param string $datumLaatstVerzEditie
     * @param string $stopredenCode
     * @param string $stopredenNaam
     */
    public function __construct(\StructType\KlachtTabV4 $aboKlachten = null, $aboNo = null, $aboSoortIncassoVerplicht = null, $aboSoortProefAbo = null, $aboSoortVrijeCode1 = null, $aboSoortVrijeCode2 = null, $aboSoortVrijeCode3 = null, $aboSoortVrijeCode4 = null, $aboSoortVrijeCode5 = null, $aboSoortVrijeCode6 = null, $aboSoortVrijeCode7 = null, $aboSoortVrijeCode8 = null, $aboSoortVrijeTekst1 = null, $aboSoortVrijeTekst2 = null, $aboSoortVrijeTekst3 = null, $aboSoortVrijeTekst4 = null, $aboSoortVrijeTekst5 = null, $aboSoortVrijeTekst6 = null, $aboSoortVrijeTekst7 = null, $aboSoortVrijeTekst8 = null, $aboSoortVrijeTekst9 = null, \StructType\VerschInfoTabV4 $aboVerschInfos = null, \StructType\VrijeVeldenAboRecV4 $aboVrijeVelden = null, $abonnementSoortCode = null, $abonnementSoortNaam = null, $actieCode = null, $actieNaam = null, $artikelGroepCode = null, $artikelGroepNaam = null, $artikelHoofdGroepCode = null, $artikelHoofdGroepNaam = null, $bankRekeningNummer = null, $bankIbanNummer = null, $bankBicCode = null, $betaalwijze = null, $eindDatum = null, $herkomstCode = null, $herkomstNaam = null, $ingangsDatum = null, $pakketCode = null, $pakketNaam = null, $premiumAboCode = null, $premiumAboNaam = null, $premiumDebCode = null, $premiumDebNaam = null, $relNoAbo = null, $uitgaveCode = null, $uitgaveNaam = null, $leverStatus = null, $aantalExemplaren = null, $organisatieLicentie = null, $machtigingsKenmerk = null, \StructType\RolInfoV4 $aboRollen = null, $relNoDeb = null, $prijsExtern = null, $prijsPropositie = null, $propositieCode = null, $propositieNaam = null, $pakketVrijeCode1 = null, $pakketVrijeNaam1 = null, $aboOrdernummer = null, \StructType\CreditcardV4 $aboCreditcard = null, \StructType\FactuurAdresV4 $factuurAdres = null, $datumLaatstVerzEditie = null, $stopredenCode = null, $stopredenNaam = null)
    {
        $this
            ->setAboKlachten($aboKlachten)
            ->setAboNo($aboNo)
            ->setAboSoortIncassoVerplicht($aboSoortIncassoVerplicht)
            ->setAboSoortProefAbo($aboSoortProefAbo)
            ->setAboSoortVrijeCode1($aboSoortVrijeCode1)
            ->setAboSoortVrijeCode2($aboSoortVrijeCode2)
            ->setAboSoortVrijeCode3($aboSoortVrijeCode3)
            ->setAboSoortVrijeCode4($aboSoortVrijeCode4)
            ->setAboSoortVrijeCode5($aboSoortVrijeCode5)
            ->setAboSoortVrijeCode6($aboSoortVrijeCode6)
            ->setAboSoortVrijeCode7($aboSoortVrijeCode7)
            ->setAboSoortVrijeCode8($aboSoortVrijeCode8)
            ->setAboSoortVrijeTekst1($aboSoortVrijeTekst1)
            ->setAboSoortVrijeTekst2($aboSoortVrijeTekst2)
            ->setAboSoortVrijeTekst3($aboSoortVrijeTekst3)
            ->setAboSoortVrijeTekst4($aboSoortVrijeTekst4)
            ->setAboSoortVrijeTekst5($aboSoortVrijeTekst5)
            ->setAboSoortVrijeTekst6($aboSoortVrijeTekst6)
            ->setAboSoortVrijeTekst7($aboSoortVrijeTekst7)
            ->setAboSoortVrijeTekst8($aboSoortVrijeTekst8)
            ->setAboSoortVrijeTekst9($aboSoortVrijeTekst9)
            ->setAboVerschInfos($aboVerschInfos)
            ->setAboVrijeVelden($aboVrijeVelden)
            ->setAbonnementSoortCode($abonnementSoortCode)
            ->setAbonnementSoortNaam($abonnementSoortNaam)
            ->setActieCode($actieCode)
            ->setActieNaam($actieNaam)
            ->setArtikelGroepCode($artikelGroepCode)
            ->setArtikelGroepNaam($artikelGroepNaam)
            ->setArtikelHoofdGroepCode($artikelHoofdGroepCode)
            ->setArtikelHoofdGroepNaam($artikelHoofdGroepNaam)
            ->setBankRekeningNummer($bankRekeningNummer)
            ->setBankIbanNummer($bankIbanNummer)
            ->setBankBicCode($bankBicCode)
            ->setBetaalwijze($betaalwijze)
            ->setEindDatum($eindDatum)
            ->setHerkomstCode($herkomstCode)
            ->setHerkomstNaam($herkomstNaam)
            ->setIngangsDatum($ingangsDatum)
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPremiumAboCode($premiumAboCode)
            ->setPremiumAboNaam($premiumAboNaam)
            ->setPremiumDebCode($premiumDebCode)
            ->setPremiumDebNaam($premiumDebNaam)
            ->setRelNoAbo($relNoAbo)
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setLeverStatus($leverStatus)
            ->setAantalExemplaren($aantalExemplaren)
            ->setOrganisatieLicentie($organisatieLicentie)
            ->setMachtigingsKenmerk($machtigingsKenmerk)
            ->setAboRollen($aboRollen)
            ->setRelNoDeb($relNoDeb)
            ->setPrijsExtern($prijsExtern)
            ->setPrijsPropositie($prijsPropositie)
            ->setPropositieCode($propositieCode)
            ->setPropositieNaam($propositieNaam)
            ->setPakketVrijeCode1($pakketVrijeCode1)
            ->setPakketVrijeNaam1($pakketVrijeNaam1)
            ->setAboOrdernummer($aboOrdernummer)
            ->setAboCreditcard($aboCreditcard)
            ->setFactuurAdres($factuurAdres)
            ->setDatumLaatstVerzEditie($datumLaatstVerzEditie)
            ->setStopredenCode($stopredenCode)
            ->setStopredenNaam($stopredenNaam);
    }
    /**
     * Get aboKlachten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KlachtTabV4|null
     */
    public function getAboKlachten()
    {
        return isset($this->aboKlachten) ? $this->aboKlachten : null;
    }
    /**
     * Set aboKlachten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KlachtTabV4 $aboKlachten
     * @return \StructType\AbonnementV4
     */
    public function setAboKlachten(\StructType\KlachtTabV4 $aboKlachten = null)
    {
        if (is_null($aboKlachten) || (is_array($aboKlachten) && empty($aboKlachten))) {
            unset($this->aboKlachten);
        } else {
            $this->aboKlachten = $aboKlachten;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \StructType\AbonnementV4
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get aboSoortIncassoVerplicht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboSoortIncassoVerplicht()
    {
        return isset($this->aboSoortIncassoVerplicht) ? $this->aboSoortIncassoVerplicht : null;
    }
    /**
     * Set aboSoortIncassoVerplicht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboSoortIncassoVerplicht
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortIncassoVerplicht($aboSoortIncassoVerplicht = null)
    {
        if (is_null($aboSoortIncassoVerplicht) || (is_array($aboSoortIncassoVerplicht) && empty($aboSoortIncassoVerplicht))) {
            unset($this->aboSoortIncassoVerplicht);
        } else {
            $this->aboSoortIncassoVerplicht = $aboSoortIncassoVerplicht;
        }
        return $this;
    }
    /**
     * Get aboSoortProefAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboSoortProefAbo()
    {
        return isset($this->aboSoortProefAbo) ? $this->aboSoortProefAbo : null;
    }
    /**
     * Set aboSoortProefAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboSoortProefAbo
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortProefAbo($aboSoortProefAbo = null)
    {
        if (is_null($aboSoortProefAbo) || (is_array($aboSoortProefAbo) && empty($aboSoortProefAbo))) {
            unset($this->aboSoortProefAbo);
        } else {
            $this->aboSoortProefAbo = $aboSoortProefAbo;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode1()
    {
        return isset($this->aboSoortVrijeCode1) ? $this->aboSoortVrijeCode1 : null;
    }
    /**
     * Set aboSoortVrijeCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode1
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode1($aboSoortVrijeCode1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode1) && strlen($aboSoortVrijeCode1) > 20) || (is_array($aboSoortVrijeCode1) && count($aboSoortVrijeCode1) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode1) ? strlen($aboSoortVrijeCode1) : count($aboSoortVrijeCode1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode1) && !is_string($aboSoortVrijeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode1)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode1) || (is_array($aboSoortVrijeCode1) && empty($aboSoortVrijeCode1))) {
            unset($this->aboSoortVrijeCode1);
        } else {
            $this->aboSoortVrijeCode1 = $aboSoortVrijeCode1;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode2()
    {
        return isset($this->aboSoortVrijeCode2) ? $this->aboSoortVrijeCode2 : null;
    }
    /**
     * Set aboSoortVrijeCode2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode2
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode2($aboSoortVrijeCode2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode2) && strlen($aboSoortVrijeCode2) > 20) || (is_array($aboSoortVrijeCode2) && count($aboSoortVrijeCode2) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode2) ? strlen($aboSoortVrijeCode2) : count($aboSoortVrijeCode2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode2) && !is_string($aboSoortVrijeCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode2)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode2) || (is_array($aboSoortVrijeCode2) && empty($aboSoortVrijeCode2))) {
            unset($this->aboSoortVrijeCode2);
        } else {
            $this->aboSoortVrijeCode2 = $aboSoortVrijeCode2;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode3()
    {
        return isset($this->aboSoortVrijeCode3) ? $this->aboSoortVrijeCode3 : null;
    }
    /**
     * Set aboSoortVrijeCode3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode3
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode3($aboSoortVrijeCode3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode3) && strlen($aboSoortVrijeCode3) > 20) || (is_array($aboSoortVrijeCode3) && count($aboSoortVrijeCode3) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode3) ? strlen($aboSoortVrijeCode3) : count($aboSoortVrijeCode3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode3) && !is_string($aboSoortVrijeCode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode3)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode3) || (is_array($aboSoortVrijeCode3) && empty($aboSoortVrijeCode3))) {
            unset($this->aboSoortVrijeCode3);
        } else {
            $this->aboSoortVrijeCode3 = $aboSoortVrijeCode3;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode4()
    {
        return isset($this->aboSoortVrijeCode4) ? $this->aboSoortVrijeCode4 : null;
    }
    /**
     * Set aboSoortVrijeCode4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode4
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode4($aboSoortVrijeCode4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode4) && strlen($aboSoortVrijeCode4) > 20) || (is_array($aboSoortVrijeCode4) && count($aboSoortVrijeCode4) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode4) ? strlen($aboSoortVrijeCode4) : count($aboSoortVrijeCode4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode4) && !is_string($aboSoortVrijeCode4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode4)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode4) || (is_array($aboSoortVrijeCode4) && empty($aboSoortVrijeCode4))) {
            unset($this->aboSoortVrijeCode4);
        } else {
            $this->aboSoortVrijeCode4 = $aboSoortVrijeCode4;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode5()
    {
        return isset($this->aboSoortVrijeCode5) ? $this->aboSoortVrijeCode5 : null;
    }
    /**
     * Set aboSoortVrijeCode5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode5
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode5($aboSoortVrijeCode5 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode5) && strlen($aboSoortVrijeCode5) > 20) || (is_array($aboSoortVrijeCode5) && count($aboSoortVrijeCode5) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode5) ? strlen($aboSoortVrijeCode5) : count($aboSoortVrijeCode5)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode5) && !is_string($aboSoortVrijeCode5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode5)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode5) || (is_array($aboSoortVrijeCode5) && empty($aboSoortVrijeCode5))) {
            unset($this->aboSoortVrijeCode5);
        } else {
            $this->aboSoortVrijeCode5 = $aboSoortVrijeCode5;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode6()
    {
        return isset($this->aboSoortVrijeCode6) ? $this->aboSoortVrijeCode6 : null;
    }
    /**
     * Set aboSoortVrijeCode6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode6
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode6($aboSoortVrijeCode6 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode6) && strlen($aboSoortVrijeCode6) > 20) || (is_array($aboSoortVrijeCode6) && count($aboSoortVrijeCode6) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode6) ? strlen($aboSoortVrijeCode6) : count($aboSoortVrijeCode6)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode6) && !is_string($aboSoortVrijeCode6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode6)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode6) || (is_array($aboSoortVrijeCode6) && empty($aboSoortVrijeCode6))) {
            unset($this->aboSoortVrijeCode6);
        } else {
            $this->aboSoortVrijeCode6 = $aboSoortVrijeCode6;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode7()
    {
        return isset($this->aboSoortVrijeCode7) ? $this->aboSoortVrijeCode7 : null;
    }
    /**
     * Set aboSoortVrijeCode7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode7
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode7($aboSoortVrijeCode7 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode7) && strlen($aboSoortVrijeCode7) > 20) || (is_array($aboSoortVrijeCode7) && count($aboSoortVrijeCode7) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode7) ? strlen($aboSoortVrijeCode7) : count($aboSoortVrijeCode7)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode7) && !is_string($aboSoortVrijeCode7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode7)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode7) || (is_array($aboSoortVrijeCode7) && empty($aboSoortVrijeCode7))) {
            unset($this->aboSoortVrijeCode7);
        } else {
            $this->aboSoortVrijeCode7 = $aboSoortVrijeCode7;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode8()
    {
        return isset($this->aboSoortVrijeCode8) ? $this->aboSoortVrijeCode8 : null;
    }
    /**
     * Set aboSoortVrijeCode8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode8
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeCode8($aboSoortVrijeCode8 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeCode8) && strlen($aboSoortVrijeCode8) > 20) || (is_array($aboSoortVrijeCode8) && count($aboSoortVrijeCode8) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeCode8) ? strlen($aboSoortVrijeCode8) : count($aboSoortVrijeCode8)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode8) && !is_string($aboSoortVrijeCode8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeCode8)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode8) || (is_array($aboSoortVrijeCode8) && empty($aboSoortVrijeCode8))) {
            unset($this->aboSoortVrijeCode8);
        } else {
            $this->aboSoortVrijeCode8 = $aboSoortVrijeCode8;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst1()
    {
        return isset($this->aboSoortVrijeTekst1) ? $this->aboSoortVrijeTekst1 : null;
    }
    /**
     * Set aboSoortVrijeTekst1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst1
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst1($aboSoortVrijeTekst1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst1) && strlen($aboSoortVrijeTekst1) > 4000) || (is_array($aboSoortVrijeTekst1) && count($aboSoortVrijeTekst1) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst1) ? strlen($aboSoortVrijeTekst1) : count($aboSoortVrijeTekst1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst1) && !is_string($aboSoortVrijeTekst1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst1)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst1) || (is_array($aboSoortVrijeTekst1) && empty($aboSoortVrijeTekst1))) {
            unset($this->aboSoortVrijeTekst1);
        } else {
            $this->aboSoortVrijeTekst1 = $aboSoortVrijeTekst1;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst2()
    {
        return isset($this->aboSoortVrijeTekst2) ? $this->aboSoortVrijeTekst2 : null;
    }
    /**
     * Set aboSoortVrijeTekst2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst2
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst2($aboSoortVrijeTekst2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst2) && strlen($aboSoortVrijeTekst2) > 4000) || (is_array($aboSoortVrijeTekst2) && count($aboSoortVrijeTekst2) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst2) ? strlen($aboSoortVrijeTekst2) : count($aboSoortVrijeTekst2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst2) && !is_string($aboSoortVrijeTekst2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst2)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst2) || (is_array($aboSoortVrijeTekst2) && empty($aboSoortVrijeTekst2))) {
            unset($this->aboSoortVrijeTekst2);
        } else {
            $this->aboSoortVrijeTekst2 = $aboSoortVrijeTekst2;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst3()
    {
        return isset($this->aboSoortVrijeTekst3) ? $this->aboSoortVrijeTekst3 : null;
    }
    /**
     * Set aboSoortVrijeTekst3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst3
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst3($aboSoortVrijeTekst3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst3) && strlen($aboSoortVrijeTekst3) > 4000) || (is_array($aboSoortVrijeTekst3) && count($aboSoortVrijeTekst3) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst3) ? strlen($aboSoortVrijeTekst3) : count($aboSoortVrijeTekst3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst3) && !is_string($aboSoortVrijeTekst3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst3)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst3) || (is_array($aboSoortVrijeTekst3) && empty($aboSoortVrijeTekst3))) {
            unset($this->aboSoortVrijeTekst3);
        } else {
            $this->aboSoortVrijeTekst3 = $aboSoortVrijeTekst3;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst4()
    {
        return isset($this->aboSoortVrijeTekst4) ? $this->aboSoortVrijeTekst4 : null;
    }
    /**
     * Set aboSoortVrijeTekst4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst4
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst4($aboSoortVrijeTekst4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst4) && strlen($aboSoortVrijeTekst4) > 4000) || (is_array($aboSoortVrijeTekst4) && count($aboSoortVrijeTekst4) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst4) ? strlen($aboSoortVrijeTekst4) : count($aboSoortVrijeTekst4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst4) && !is_string($aboSoortVrijeTekst4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst4)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst4) || (is_array($aboSoortVrijeTekst4) && empty($aboSoortVrijeTekst4))) {
            unset($this->aboSoortVrijeTekst4);
        } else {
            $this->aboSoortVrijeTekst4 = $aboSoortVrijeTekst4;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst5()
    {
        return isset($this->aboSoortVrijeTekst5) ? $this->aboSoortVrijeTekst5 : null;
    }
    /**
     * Set aboSoortVrijeTekst5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst5
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst5($aboSoortVrijeTekst5 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst5) && strlen($aboSoortVrijeTekst5) > 4000) || (is_array($aboSoortVrijeTekst5) && count($aboSoortVrijeTekst5) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst5) ? strlen($aboSoortVrijeTekst5) : count($aboSoortVrijeTekst5)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst5) && !is_string($aboSoortVrijeTekst5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst5)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst5) || (is_array($aboSoortVrijeTekst5) && empty($aboSoortVrijeTekst5))) {
            unset($this->aboSoortVrijeTekst5);
        } else {
            $this->aboSoortVrijeTekst5 = $aboSoortVrijeTekst5;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst6()
    {
        return isset($this->aboSoortVrijeTekst6) ? $this->aboSoortVrijeTekst6 : null;
    }
    /**
     * Set aboSoortVrijeTekst6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst6
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst6($aboSoortVrijeTekst6 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst6) && strlen($aboSoortVrijeTekst6) > 4000) || (is_array($aboSoortVrijeTekst6) && count($aboSoortVrijeTekst6) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst6) ? strlen($aboSoortVrijeTekst6) : count($aboSoortVrijeTekst6)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst6) && !is_string($aboSoortVrijeTekst6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst6)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst6) || (is_array($aboSoortVrijeTekst6) && empty($aboSoortVrijeTekst6))) {
            unset($this->aboSoortVrijeTekst6);
        } else {
            $this->aboSoortVrijeTekst6 = $aboSoortVrijeTekst6;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst7()
    {
        return isset($this->aboSoortVrijeTekst7) ? $this->aboSoortVrijeTekst7 : null;
    }
    /**
     * Set aboSoortVrijeTekst7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst7
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst7($aboSoortVrijeTekst7 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst7) && strlen($aboSoortVrijeTekst7) > 4000) || (is_array($aboSoortVrijeTekst7) && count($aboSoortVrijeTekst7) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst7) ? strlen($aboSoortVrijeTekst7) : count($aboSoortVrijeTekst7)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst7) && !is_string($aboSoortVrijeTekst7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst7)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst7) || (is_array($aboSoortVrijeTekst7) && empty($aboSoortVrijeTekst7))) {
            unset($this->aboSoortVrijeTekst7);
        } else {
            $this->aboSoortVrijeTekst7 = $aboSoortVrijeTekst7;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst8()
    {
        return isset($this->aboSoortVrijeTekst8) ? $this->aboSoortVrijeTekst8 : null;
    }
    /**
     * Set aboSoortVrijeTekst8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst8
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst8($aboSoortVrijeTekst8 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst8) && strlen($aboSoortVrijeTekst8) > 4000) || (is_array($aboSoortVrijeTekst8) && count($aboSoortVrijeTekst8) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst8) ? strlen($aboSoortVrijeTekst8) : count($aboSoortVrijeTekst8)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst8) && !is_string($aboSoortVrijeTekst8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst8)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst8) || (is_array($aboSoortVrijeTekst8) && empty($aboSoortVrijeTekst8))) {
            unset($this->aboSoortVrijeTekst8);
        } else {
            $this->aboSoortVrijeTekst8 = $aboSoortVrijeTekst8;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst9()
    {
        return isset($this->aboSoortVrijeTekst9) ? $this->aboSoortVrijeTekst9 : null;
    }
    /**
     * Set aboSoortVrijeTekst9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst9
     * @return \StructType\AbonnementV4
     */
    public function setAboSoortVrijeTekst9($aboSoortVrijeTekst9 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboSoortVrijeTekst9) && strlen($aboSoortVrijeTekst9) > 4000) || (is_array($aboSoortVrijeTekst9) && count($aboSoortVrijeTekst9) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($aboSoortVrijeTekst9) ? strlen($aboSoortVrijeTekst9) : count($aboSoortVrijeTekst9)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst9) && !is_string($aboSoortVrijeTekst9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboSoortVrijeTekst9)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst9) || (is_array($aboSoortVrijeTekst9) && empty($aboSoortVrijeTekst9))) {
            unset($this->aboSoortVrijeTekst9);
        } else {
            $this->aboSoortVrijeTekst9 = $aboSoortVrijeTekst9;
        }
        return $this;
    }
    /**
     * Get aboVerschInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VerschInfoTabV4|null
     */
    public function getAboVerschInfos()
    {
        return isset($this->aboVerschInfos) ? $this->aboVerschInfos : null;
    }
    /**
     * Set aboVerschInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VerschInfoTabV4 $aboVerschInfos
     * @return \StructType\AbonnementV4
     */
    public function setAboVerschInfos(\StructType\VerschInfoTabV4 $aboVerschInfos = null)
    {
        if (is_null($aboVerschInfos) || (is_array($aboVerschInfos) && empty($aboVerschInfos))) {
            unset($this->aboVerschInfos);
        } else {
            $this->aboVerschInfos = $aboVerschInfos;
        }
        return $this;
    }
    /**
     * Get aboVrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VrijeVeldenAboRecV4|null
     */
    public function getAboVrijeVelden()
    {
        return isset($this->aboVrijeVelden) ? $this->aboVrijeVelden : null;
    }
    /**
     * Set aboVrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VrijeVeldenAboRecV4 $aboVrijeVelden
     * @return \StructType\AbonnementV4
     */
    public function setAboVrijeVelden(\StructType\VrijeVeldenAboRecV4 $aboVrijeVelden = null)
    {
        if (is_null($aboVrijeVelden) || (is_array($aboVrijeVelden) && empty($aboVrijeVelden))) {
            unset($this->aboVrijeVelden);
        } else {
            $this->aboVrijeVelden = $aboVrijeVelden;
        }
        return $this;
    }
    /**
     * Get abonnementSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortCode()
    {
        return isset($this->abonnementSoortCode) ? $this->abonnementSoortCode : null;
    }
    /**
     * Set abonnementSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortCode
     * @return \StructType\AbonnementV4
     */
    public function setAbonnementSoortCode($abonnementSoortCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementSoortCode) && strlen($abonnementSoortCode) > 30) || (is_array($abonnementSoortCode) && count($abonnementSoortCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($abonnementSoortCode) ? strlen($abonnementSoortCode) : count($abonnementSoortCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementSoortCode) && !is_string($abonnementSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementSoortCode)), __LINE__);
        }
        if (is_null($abonnementSoortCode) || (is_array($abonnementSoortCode) && empty($abonnementSoortCode))) {
            unset($this->abonnementSoortCode);
        } else {
            $this->abonnementSoortCode = $abonnementSoortCode;
        }
        return $this;
    }
    /**
     * Get abonnementSoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortNaam()
    {
        return isset($this->abonnementSoortNaam) ? $this->abonnementSoortNaam : null;
    }
    /**
     * Set abonnementSoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortNaam
     * @return \StructType\AbonnementV4
     */
    public function setAbonnementSoortNaam($abonnementSoortNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abonnementSoortNaam) && strlen($abonnementSoortNaam) > 500) || (is_array($abonnementSoortNaam) && count($abonnementSoortNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($abonnementSoortNaam) ? strlen($abonnementSoortNaam) : count($abonnementSoortNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abonnementSoortNaam) && !is_string($abonnementSoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abonnementSoortNaam)), __LINE__);
        }
        if (is_null($abonnementSoortNaam) || (is_array($abonnementSoortNaam) && empty($abonnementSoortNaam))) {
            unset($this->abonnementSoortNaam);
        } else {
            $this->abonnementSoortNaam = $abonnementSoortNaam;
        }
        return $this;
    }
    /**
     * Get actieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieCode()
    {
        return isset($this->actieCode) ? $this->actieCode : null;
    }
    /**
     * Set actieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieCode
     * @return \StructType\AbonnementV4
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieCode) && strlen($actieCode) > 15) || (is_array($actieCode) && count($actieCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($actieCode) ? strlen($actieCode) : count($actieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieCode)), __LINE__);
        }
        if (is_null($actieCode) || (is_array($actieCode) && empty($actieCode))) {
            unset($this->actieCode);
        } else {
            $this->actieCode = $actieCode;
        }
        return $this;
    }
    /**
     * Get actieNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieNaam()
    {
        return isset($this->actieNaam) ? $this->actieNaam : null;
    }
    /**
     * Set actieNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieNaam
     * @return \StructType\AbonnementV4
     */
    public function setActieNaam($actieNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actieNaam) && strlen($actieNaam) > 100) || (is_array($actieNaam) && count($actieNaam) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($actieNaam) ? strlen($actieNaam) : count($actieNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actieNaam) && !is_string($actieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actieNaam)), __LINE__);
        }
        if (is_null($actieNaam) || (is_array($actieNaam) && empty($actieNaam))) {
            unset($this->actieNaam);
        } else {
            $this->actieNaam = $actieNaam;
        }
        return $this;
    }
    /**
     * Get artikelGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepCode()
    {
        return isset($this->artikelGroepCode) ? $this->artikelGroepCode : null;
    }
    /**
     * Set artikelGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepCode
     * @return \StructType\AbonnementV4
     */
    public function setArtikelGroepCode($artikelGroepCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelGroepCode) && strlen($artikelGroepCode) > 20) || (is_array($artikelGroepCode) && count($artikelGroepCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($artikelGroepCode) ? strlen($artikelGroepCode) : count($artikelGroepCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelGroepCode) && !is_string($artikelGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelGroepCode)), __LINE__);
        }
        if (is_null($artikelGroepCode) || (is_array($artikelGroepCode) && empty($artikelGroepCode))) {
            unset($this->artikelGroepCode);
        } else {
            $this->artikelGroepCode = $artikelGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepNaam()
    {
        return isset($this->artikelGroepNaam) ? $this->artikelGroepNaam : null;
    }
    /**
     * Set artikelGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepNaam
     * @return \StructType\AbonnementV4
     */
    public function setArtikelGroepNaam($artikelGroepNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelGroepNaam) && strlen($artikelGroepNaam) > 120) || (is_array($artikelGroepNaam) && count($artikelGroepNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($artikelGroepNaam) ? strlen($artikelGroepNaam) : count($artikelGroepNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelGroepNaam) && !is_string($artikelGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelGroepNaam)), __LINE__);
        }
        if (is_null($artikelGroepNaam) || (is_array($artikelGroepNaam) && empty($artikelGroepNaam))) {
            unset($this->artikelGroepNaam);
        } else {
            $this->artikelGroepNaam = $artikelGroepNaam;
        }
        return $this;
    }
    /**
     * Get artikelHoofdGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelHoofdGroepCode()
    {
        return isset($this->artikelHoofdGroepCode) ? $this->artikelHoofdGroepCode : null;
    }
    /**
     * Set artikelHoofdGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelHoofdGroepCode
     * @return \StructType\AbonnementV4
     */
    public function setArtikelHoofdGroepCode($artikelHoofdGroepCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelHoofdGroepCode) && strlen($artikelHoofdGroepCode) > 12) || (is_array($artikelHoofdGroepCode) && count($artikelHoofdGroepCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($artikelHoofdGroepCode) ? strlen($artikelHoofdGroepCode) : count($artikelHoofdGroepCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelHoofdGroepCode) && !is_string($artikelHoofdGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelHoofdGroepCode)), __LINE__);
        }
        if (is_null($artikelHoofdGroepCode) || (is_array($artikelHoofdGroepCode) && empty($artikelHoofdGroepCode))) {
            unset($this->artikelHoofdGroepCode);
        } else {
            $this->artikelHoofdGroepCode = $artikelHoofdGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelHoofdGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelHoofdGroepNaam()
    {
        return isset($this->artikelHoofdGroepNaam) ? $this->artikelHoofdGroepNaam : null;
    }
    /**
     * Set artikelHoofdGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelHoofdGroepNaam
     * @return \StructType\AbonnementV4
     */
    public function setArtikelHoofdGroepNaam($artikelHoofdGroepNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($artikelHoofdGroepNaam) && strlen($artikelHoofdGroepNaam) > 120) || (is_array($artikelHoofdGroepNaam) && count($artikelHoofdGroepNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($artikelHoofdGroepNaam) ? strlen($artikelHoofdGroepNaam) : count($artikelHoofdGroepNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($artikelHoofdGroepNaam) && !is_string($artikelHoofdGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelHoofdGroepNaam)), __LINE__);
        }
        if (is_null($artikelHoofdGroepNaam) || (is_array($artikelHoofdGroepNaam) && empty($artikelHoofdGroepNaam))) {
            unset($this->artikelHoofdGroepNaam);
        } else {
            $this->artikelHoofdGroepNaam = $artikelHoofdGroepNaam;
        }
        return $this;
    }
    /**
     * Get bankRekeningNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankRekeningNummer()
    {
        return isset($this->bankRekeningNummer) ? $this->bankRekeningNummer : null;
    }
    /**
     * Set bankRekeningNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankRekeningNummer
     * @return \StructType\AbonnementV4
     */
    public function setBankRekeningNummer($bankRekeningNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankRekeningNummer) && strlen($bankRekeningNummer) > 20) || (is_array($bankRekeningNummer) && count($bankRekeningNummer) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bankRekeningNummer) ? strlen($bankRekeningNummer) : count($bankRekeningNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankRekeningNummer) && !is_string($bankRekeningNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRekeningNummer)), __LINE__);
        }
        if (is_null($bankRekeningNummer) || (is_array($bankRekeningNummer) && empty($bankRekeningNummer))) {
            unset($this->bankRekeningNummer);
        } else {
            $this->bankRekeningNummer = $bankRekeningNummer;
        }
        return $this;
    }
    /**
     * Get bankIbanNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankIbanNummer()
    {
        return isset($this->bankIbanNummer) ? $this->bankIbanNummer : null;
    }
    /**
     * Set bankIbanNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankIbanNummer
     * @return \StructType\AbonnementV4
     */
    public function setBankIbanNummer($bankIbanNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankIbanNummer) && strlen($bankIbanNummer) > 4000) || (is_array($bankIbanNummer) && count($bankIbanNummer) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($bankIbanNummer) ? strlen($bankIbanNummer) : count($bankIbanNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankIbanNummer) && !is_string($bankIbanNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankIbanNummer)), __LINE__);
        }
        if (is_null($bankIbanNummer) || (is_array($bankIbanNummer) && empty($bankIbanNummer))) {
            unset($this->bankIbanNummer);
        } else {
            $this->bankIbanNummer = $bankIbanNummer;
        }
        return $this;
    }
    /**
     * Get bankBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankBicCode()
    {
        return isset($this->bankBicCode) ? $this->bankBicCode : null;
    }
    /**
     * Set bankBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankBicCode
     * @return \StructType\AbonnementV4
     */
    public function setBankBicCode($bankBicCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankBicCode) && strlen($bankBicCode) > 4000) || (is_array($bankBicCode) && count($bankBicCode) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($bankBicCode) ? strlen($bankBicCode) : count($bankBicCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankBicCode) && !is_string($bankBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankBicCode)), __LINE__);
        }
        if (is_null($bankBicCode) || (is_array($bankBicCode) && empty($bankBicCode))) {
            unset($this->bankBicCode);
        } else {
            $this->bankBicCode = $bankBicCode;
        }
        return $this;
    }
    /**
     * Get betaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBetaalwijze()
    {
        return isset($this->betaalwijze) ? $this->betaalwijze : null;
    }
    /**
     * Set betaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $betaalwijze
     * @return \StructType\AbonnementV4
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: totalDigits
        if (is_float($betaalwijze) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $betaalwijze)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($betaalwijze, strpos($betaalwijze, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($betaalwijze) && !is_numeric($betaalwijze)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($betaalwijze)), __LINE__);
        }
        if (is_null($betaalwijze) || (is_array($betaalwijze) && empty($betaalwijze))) {
            unset($this->betaalwijze);
        } else {
            $this->betaalwijze = $betaalwijze;
        }
        return $this;
    }
    /**
     * Get eindDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEindDatum()
    {
        return isset($this->eindDatum) ? $this->eindDatum : null;
    }
    /**
     * Set eindDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eindDatum
     * @return \StructType\AbonnementV4
     */
    public function setEindDatum($eindDatum = null)
    {
        // validation for constraint: string
        if (!is_null($eindDatum) && !is_string($eindDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eindDatum)), __LINE__);
        }
        if (is_null($eindDatum) || (is_array($eindDatum) && empty($eindDatum))) {
            unset($this->eindDatum);
        } else {
            $this->eindDatum = $eindDatum;
        }
        return $this;
    }
    /**
     * Get herkomstCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHerkomstCode()
    {
        return isset($this->herkomstCode) ? $this->herkomstCode : null;
    }
    /**
     * Set herkomstCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $herkomstCode
     * @return \StructType\AbonnementV4
     */
    public function setHerkomstCode($herkomstCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($herkomstCode) && strlen($herkomstCode) > 20) || (is_array($herkomstCode) && count($herkomstCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($herkomstCode) ? strlen($herkomstCode) : count($herkomstCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($herkomstCode) && !is_string($herkomstCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($herkomstCode)), __LINE__);
        }
        if (is_null($herkomstCode) || (is_array($herkomstCode) && empty($herkomstCode))) {
            unset($this->herkomstCode);
        } else {
            $this->herkomstCode = $herkomstCode;
        }
        return $this;
    }
    /**
     * Get herkomstNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHerkomstNaam()
    {
        return isset($this->herkomstNaam) ? $this->herkomstNaam : null;
    }
    /**
     * Set herkomstNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $herkomstNaam
     * @return \StructType\AbonnementV4
     */
    public function setHerkomstNaam($herkomstNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($herkomstNaam) && strlen($herkomstNaam) > 120) || (is_array($herkomstNaam) && count($herkomstNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($herkomstNaam) ? strlen($herkomstNaam) : count($herkomstNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($herkomstNaam) && !is_string($herkomstNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($herkomstNaam)), __LINE__);
        }
        if (is_null($herkomstNaam) || (is_array($herkomstNaam) && empty($herkomstNaam))) {
            unset($this->herkomstNaam);
        } else {
            $this->herkomstNaam = $herkomstNaam;
        }
        return $this;
    }
    /**
     * Get ingangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIngangsDatum()
    {
        return isset($this->ingangsDatum) ? $this->ingangsDatum : null;
    }
    /**
     * Set ingangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ingangsDatum
     * @return \StructType\AbonnementV4
     */
    public function setIngangsDatum($ingangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($ingangsDatum) && !is_string($ingangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ingangsDatum)), __LINE__);
        }
        if (is_null($ingangsDatum) || (is_array($ingangsDatum) && empty($ingangsDatum))) {
            unset($this->ingangsDatum);
        } else {
            $this->ingangsDatum = $ingangsDatum;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \StructType\AbonnementV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \StructType\AbonnementV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketNaam) && strlen($pakketNaam) > 120) || (is_array($pakketNaam) && count($pakketNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($pakketNaam) ? strlen($pakketNaam) : count($pakketNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get premiumAboCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumAboCode()
    {
        return isset($this->premiumAboCode) ? $this->premiumAboCode : null;
    }
    /**
     * Set premiumAboCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumAboCode
     * @return \StructType\AbonnementV4
     */
    public function setPremiumAboCode($premiumAboCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($premiumAboCode) && strlen($premiumAboCode) > 30) || (is_array($premiumAboCode) && count($premiumAboCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($premiumAboCode) ? strlen($premiumAboCode) : count($premiumAboCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($premiumAboCode) && !is_string($premiumAboCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiumAboCode)), __LINE__);
        }
        if (is_null($premiumAboCode) || (is_array($premiumAboCode) && empty($premiumAboCode))) {
            unset($this->premiumAboCode);
        } else {
            $this->premiumAboCode = $premiumAboCode;
        }
        return $this;
    }
    /**
     * Get premiumAboNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumAboNaam()
    {
        return isset($this->premiumAboNaam) ? $this->premiumAboNaam : null;
    }
    /**
     * Set premiumAboNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumAboNaam
     * @return \StructType\AbonnementV4
     */
    public function setPremiumAboNaam($premiumAboNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($premiumAboNaam) && strlen($premiumAboNaam) > 500) || (is_array($premiumAboNaam) && count($premiumAboNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($premiumAboNaam) ? strlen($premiumAboNaam) : count($premiumAboNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($premiumAboNaam) && !is_string($premiumAboNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiumAboNaam)), __LINE__);
        }
        if (is_null($premiumAboNaam) || (is_array($premiumAboNaam) && empty($premiumAboNaam))) {
            unset($this->premiumAboNaam);
        } else {
            $this->premiumAboNaam = $premiumAboNaam;
        }
        return $this;
    }
    /**
     * Get premiumDebCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumDebCode()
    {
        return isset($this->premiumDebCode) ? $this->premiumDebCode : null;
    }
    /**
     * Set premiumDebCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumDebCode
     * @return \StructType\AbonnementV4
     */
    public function setPremiumDebCode($premiumDebCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($premiumDebCode) && strlen($premiumDebCode) > 30) || (is_array($premiumDebCode) && count($premiumDebCode) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($premiumDebCode) ? strlen($premiumDebCode) : count($premiumDebCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($premiumDebCode) && !is_string($premiumDebCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiumDebCode)), __LINE__);
        }
        if (is_null($premiumDebCode) || (is_array($premiumDebCode) && empty($premiumDebCode))) {
            unset($this->premiumDebCode);
        } else {
            $this->premiumDebCode = $premiumDebCode;
        }
        return $this;
    }
    /**
     * Get premiumDebNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumDebNaam()
    {
        return isset($this->premiumDebNaam) ? $this->premiumDebNaam : null;
    }
    /**
     * Set premiumDebNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumDebNaam
     * @return \StructType\AbonnementV4
     */
    public function setPremiumDebNaam($premiumDebNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($premiumDebNaam) && strlen($premiumDebNaam) > 500) || (is_array($premiumDebNaam) && count($premiumDebNaam) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($premiumDebNaam) ? strlen($premiumDebNaam) : count($premiumDebNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($premiumDebNaam) && !is_string($premiumDebNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiumDebNaam)), __LINE__);
        }
        if (is_null($premiumDebNaam) || (is_array($premiumDebNaam) && empty($premiumDebNaam))) {
            unset($this->premiumDebNaam);
        } else {
            $this->premiumDebNaam = $premiumDebNaam;
        }
        return $this;
    }
    /**
     * Get relNoAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoAbo()
    {
        return isset($this->relNoAbo) ? $this->relNoAbo : null;
    }
    /**
     * Set relNoAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoAbo
     * @return \StructType\AbonnementV4
     */
    public function setRelNoAbo($relNoAbo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoAbo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoAbo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoAbo, strpos($relNoAbo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoAbo) && !is_numeric($relNoAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoAbo)), __LINE__);
        }
        if (is_null($relNoAbo) || (is_array($relNoAbo) && empty($relNoAbo))) {
            unset($this->relNoAbo);
        } else {
            $this->relNoAbo = $relNoAbo;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \StructType\AbonnementV4
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveCode) && strlen($uitgaveCode) > 20) || (is_array($uitgaveCode) && count($uitgaveCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($uitgaveCode) ? strlen($uitgaveCode) : count($uitgaveCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \StructType\AbonnementV4
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uitgaveNaam) && strlen($uitgaveNaam) > 120) || (is_array($uitgaveNaam) && count($uitgaveNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($uitgaveNaam) ? strlen($uitgaveNaam) : count($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get leverStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverStatus()
    {
        return isset($this->leverStatus) ? $this->leverStatus : null;
    }
    /**
     * Set leverStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverStatus
     * @return \StructType\AbonnementV4
     */
    public function setLeverStatus($leverStatus = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($leverStatus) && strlen($leverStatus) > 20) || (is_array($leverStatus) && count($leverStatus) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($leverStatus) ? strlen($leverStatus) : count($leverStatus)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($leverStatus) && !is_string($leverStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leverStatus)), __LINE__);
        }
        if (is_null($leverStatus) || (is_array($leverStatus) && empty($leverStatus))) {
            unset($this->leverStatus);
        } else {
            $this->leverStatus = $leverStatus;
        }
        return $this;
    }
    /**
     * Get aantalExemplaren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalExemplaren()
    {
        return isset($this->aantalExemplaren) ? $this->aantalExemplaren : null;
    }
    /**
     * Set aantalExemplaren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalExemplaren
     * @return \StructType\AbonnementV4
     */
    public function setAantalExemplaren($aantalExemplaren = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aantalExemplaren) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aantalExemplaren)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aantalExemplaren, strpos($aantalExemplaren, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aantalExemplaren) && !is_numeric($aantalExemplaren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantalExemplaren)), __LINE__);
        }
        if (is_null($aantalExemplaren) || (is_array($aantalExemplaren) && empty($aantalExemplaren))) {
            unset($this->aantalExemplaren);
        } else {
            $this->aantalExemplaren = $aantalExemplaren;
        }
        return $this;
    }
    /**
     * Get organisatieLicentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganisatieLicentie()
    {
        return isset($this->organisatieLicentie) ? $this->organisatieLicentie : null;
    }
    /**
     * Set organisatieLicentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organisatieLicentie
     * @return \StructType\AbonnementV4
     */
    public function setOrganisatieLicentie($organisatieLicentie = null)
    {
        if (is_null($organisatieLicentie) || (is_array($organisatieLicentie) && empty($organisatieLicentie))) {
            unset($this->organisatieLicentie);
        } else {
            $this->organisatieLicentie = $organisatieLicentie;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \StructType\AbonnementV4
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($machtigingsKenmerk) && strlen($machtigingsKenmerk) > 4000) || (is_array($machtigingsKenmerk) && count($machtigingsKenmerk) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($machtigingsKenmerk) ? strlen($machtigingsKenmerk) : count($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Get aboRollen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RolInfoV4|null
     */
    public function getAboRollen()
    {
        return isset($this->aboRollen) ? $this->aboRollen : null;
    }
    /**
     * Set aboRollen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RolInfoV4 $aboRollen
     * @return \StructType\AbonnementV4
     */
    public function setAboRollen(\StructType\RolInfoV4 $aboRollen = null)
    {
        if (is_null($aboRollen) || (is_array($aboRollen) && empty($aboRollen))) {
            unset($this->aboRollen);
        } else {
            $this->aboRollen = $aboRollen;
        }
        return $this;
    }
    /**
     * Get relNoDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoDeb()
    {
        return isset($this->relNoDeb) ? $this->relNoDeb : null;
    }
    /**
     * Set relNoDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoDeb
     * @return \StructType\AbonnementV4
     */
    public function setRelNoDeb($relNoDeb = null)
    {
        // validation for constraint: totalDigits
        if (is_float($relNoDeb) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $relNoDeb)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($relNoDeb, strpos($relNoDeb, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($relNoDeb) && !is_numeric($relNoDeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relNoDeb)), __LINE__);
        }
        if (is_null($relNoDeb) || (is_array($relNoDeb) && empty($relNoDeb))) {
            unset($this->relNoDeb);
        } else {
            $this->relNoDeb = $relNoDeb;
        }
        return $this;
    }
    /**
     * Get prijsExtern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExtern()
    {
        return isset($this->prijsExtern) ? $this->prijsExtern : null;
    }
    /**
     * Set prijsExtern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExtern
     * @return \StructType\AbonnementV4
     */
    public function setPrijsExtern($prijsExtern = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($prijsExtern) && strlen(substr($prijsExtern, strpos($prijsExtern, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($prijsExtern, strpos($prijsExtern, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($prijsExtern) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsExtern)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($prijsExtern, strpos($prijsExtern, '.')))), __LINE__);
        }
        if (is_null($prijsExtern) || (is_array($prijsExtern) && empty($prijsExtern))) {
            unset($this->prijsExtern);
        } else {
            $this->prijsExtern = $prijsExtern;
        }
        return $this;
    }
    /**
     * Get prijsPropositie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsPropositie()
    {
        return isset($this->prijsPropositie) ? $this->prijsPropositie : null;
    }
    /**
     * Set prijsPropositie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsPropositie
     * @return \StructType\AbonnementV4
     */
    public function setPrijsPropositie($prijsPropositie = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($prijsPropositie) && strlen(substr($prijsPropositie, strpos($prijsPropositie, '.'))) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($prijsPropositie, strpos($prijsPropositie, '.')))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($prijsPropositie) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $prijsPropositie)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($prijsPropositie, strpos($prijsPropositie, '.')))), __LINE__);
        }
        if (is_null($prijsPropositie) || (is_array($prijsPropositie) && empty($prijsPropositie))) {
            unset($this->prijsPropositie);
        } else {
            $this->prijsPropositie = $prijsPropositie;
        }
        return $this;
    }
    /**
     * Get propositieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropositieCode()
    {
        return isset($this->propositieCode) ? $this->propositieCode : null;
    }
    /**
     * Set propositieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propositieCode
     * @return \StructType\AbonnementV4
     */
    public function setPropositieCode($propositieCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($propositieCode) && strlen($propositieCode) > 20) || (is_array($propositieCode) && count($propositieCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($propositieCode) ? strlen($propositieCode) : count($propositieCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($propositieCode) && !is_string($propositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propositieCode)), __LINE__);
        }
        if (is_null($propositieCode) || (is_array($propositieCode) && empty($propositieCode))) {
            unset($this->propositieCode);
        } else {
            $this->propositieCode = $propositieCode;
        }
        return $this;
    }
    /**
     * Get propositieNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropositieNaam()
    {
        return isset($this->propositieNaam) ? $this->propositieNaam : null;
    }
    /**
     * Set propositieNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propositieNaam
     * @return \StructType\AbonnementV4
     */
    public function setPropositieNaam($propositieNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($propositieNaam) && strlen($propositieNaam) > 120) || (is_array($propositieNaam) && count($propositieNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($propositieNaam) ? strlen($propositieNaam) : count($propositieNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($propositieNaam) && !is_string($propositieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propositieNaam)), __LINE__);
        }
        if (is_null($propositieNaam) || (is_array($propositieNaam) && empty($propositieNaam))) {
            unset($this->propositieNaam);
        } else {
            $this->propositieNaam = $propositieNaam;
        }
        return $this;
    }
    /**
     * Get pakketVrijeCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeCode1()
    {
        return isset($this->pakketVrijeCode1) ? $this->pakketVrijeCode1 : null;
    }
    /**
     * Set pakketVrijeCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeCode1
     * @return \StructType\AbonnementV4
     */
    public function setPakketVrijeCode1($pakketVrijeCode1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketVrijeCode1) && strlen($pakketVrijeCode1) > 20) || (is_array($pakketVrijeCode1) && count($pakketVrijeCode1) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketVrijeCode1) ? strlen($pakketVrijeCode1) : count($pakketVrijeCode1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketVrijeCode1) && !is_string($pakketVrijeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketVrijeCode1)), __LINE__);
        }
        if (is_null($pakketVrijeCode1) || (is_array($pakketVrijeCode1) && empty($pakketVrijeCode1))) {
            unset($this->pakketVrijeCode1);
        } else {
            $this->pakketVrijeCode1 = $pakketVrijeCode1;
        }
        return $this;
    }
    /**
     * Get pakketVrijeNaam1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeNaam1()
    {
        return isset($this->pakketVrijeNaam1) ? $this->pakketVrijeNaam1 : null;
    }
    /**
     * Set pakketVrijeNaam1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeNaam1
     * @return \StructType\AbonnementV4
     */
    public function setPakketVrijeNaam1($pakketVrijeNaam1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketVrijeNaam1) && strlen($pakketVrijeNaam1) > 120) || (is_array($pakketVrijeNaam1) && count($pakketVrijeNaam1) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($pakketVrijeNaam1) ? strlen($pakketVrijeNaam1) : count($pakketVrijeNaam1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketVrijeNaam1) && !is_string($pakketVrijeNaam1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketVrijeNaam1)), __LINE__);
        }
        if (is_null($pakketVrijeNaam1) || (is_array($pakketVrijeNaam1) && empty($pakketVrijeNaam1))) {
            unset($this->pakketVrijeNaam1);
        } else {
            $this->pakketVrijeNaam1 = $pakketVrijeNaam1;
        }
        return $this;
    }
    /**
     * Get aboOrdernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboOrdernummer()
    {
        return isset($this->aboOrdernummer) ? $this->aboOrdernummer : null;
    }
    /**
     * Set aboOrdernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboOrdernummer
     * @return \StructType\AbonnementV4
     */
    public function setAboOrdernummer($aboOrdernummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboOrdernummer) && strlen($aboOrdernummer) > 50) || (is_array($aboOrdernummer) && count($aboOrdernummer) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($aboOrdernummer) ? strlen($aboOrdernummer) : count($aboOrdernummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboOrdernummer) && !is_string($aboOrdernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboOrdernummer)), __LINE__);
        }
        if (is_null($aboOrdernummer) || (is_array($aboOrdernummer) && empty($aboOrdernummer))) {
            unset($this->aboOrdernummer);
        } else {
            $this->aboOrdernummer = $aboOrdernummer;
        }
        return $this;
    }
    /**
     * Get aboCreditcard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditcardV4|null
     */
    public function getAboCreditcard()
    {
        return isset($this->aboCreditcard) ? $this->aboCreditcard : null;
    }
    /**
     * Set aboCreditcard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditcardV4 $aboCreditcard
     * @return \StructType\AbonnementV4
     */
    public function setAboCreditcard(\StructType\CreditcardV4 $aboCreditcard = null)
    {
        if (is_null($aboCreditcard) || (is_array($aboCreditcard) && empty($aboCreditcard))) {
            unset($this->aboCreditcard);
        } else {
            $this->aboCreditcard = $aboCreditcard;
        }
        return $this;
    }
    /**
     * Get factuurAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FactuurAdresV4|null
     */
    public function getFactuurAdres()
    {
        return isset($this->factuurAdres) ? $this->factuurAdres : null;
    }
    /**
     * Set factuurAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FactuurAdresV4 $factuurAdres
     * @return \StructType\AbonnementV4
     */
    public function setFactuurAdres(\StructType\FactuurAdresV4 $factuurAdres = null)
    {
        if (is_null($factuurAdres) || (is_array($factuurAdres) && empty($factuurAdres))) {
            unset($this->factuurAdres);
        } else {
            $this->factuurAdres = $factuurAdres;
        }
        return $this;
    }
    /**
     * Get datumLaatstVerzEditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumLaatstVerzEditie()
    {
        return isset($this->datumLaatstVerzEditie) ? $this->datumLaatstVerzEditie : null;
    }
    /**
     * Set datumLaatstVerzEditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumLaatstVerzEditie
     * @return \StructType\AbonnementV4
     */
    public function setDatumLaatstVerzEditie($datumLaatstVerzEditie = null)
    {
        // validation for constraint: string
        if (!is_null($datumLaatstVerzEditie) && !is_string($datumLaatstVerzEditie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumLaatstVerzEditie)), __LINE__);
        }
        if (is_null($datumLaatstVerzEditie) || (is_array($datumLaatstVerzEditie) && empty($datumLaatstVerzEditie))) {
            unset($this->datumLaatstVerzEditie);
        } else {
            $this->datumLaatstVerzEditie = $datumLaatstVerzEditie;
        }
        return $this;
    }
    /**
     * Get stopredenCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopredenCode()
    {
        return isset($this->stopredenCode) ? $this->stopredenCode : null;
    }
    /**
     * Set stopredenCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopredenCode
     * @return \StructType\AbonnementV4
     */
    public function setStopredenCode($stopredenCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stopredenCode) && strlen($stopredenCode) > 15) || (is_array($stopredenCode) && count($stopredenCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($stopredenCode) ? strlen($stopredenCode) : count($stopredenCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stopredenCode) && !is_string($stopredenCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopredenCode)), __LINE__);
        }
        if (is_null($stopredenCode) || (is_array($stopredenCode) && empty($stopredenCode))) {
            unset($this->stopredenCode);
        } else {
            $this->stopredenCode = $stopredenCode;
        }
        return $this;
    }
    /**
     * Get stopredenNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopredenNaam()
    {
        return isset($this->stopredenNaam) ? $this->stopredenNaam : null;
    }
    /**
     * Set stopredenNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopredenNaam
     * @return \StructType\AbonnementV4
     */
    public function setStopredenNaam($stopredenNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stopredenNaam) && strlen($stopredenNaam) > 40) || (is_array($stopredenNaam) && count($stopredenNaam) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($stopredenNaam) ? strlen($stopredenNaam) : count($stopredenNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stopredenNaam) && !is_string($stopredenNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopredenNaam)), __LINE__);
        }
        if (is_null($stopredenNaam) || (is_array($stopredenNaam) && empty($stopredenNaam))) {
            unset($this->stopredenNaam);
        } else {
            $this->stopredenNaam = $stopredenNaam;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbonnementV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
