<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst abonnementen.
 * @subpackage Structs
 */
class AbonnementTabV4 extends AbstractStructBase
{
    /**
     * The abonnement
     * Meta informations extracted from the WSDL
     * - documentation: Lijst abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AbonnementV4[]
     */
    public $abonnement;
    /**
     * Constructor method for AbonnementTabV4
     * @uses AbonnementTabV4::setAbonnement()
     * @param \StructType\AbonnementV4[] $abonnement
     */
    public function __construct(array $abonnement = array())
    {
        $this
            ->setAbonnement($abonnement);
    }
    /**
     * Get abonnement value
     * @return \StructType\AbonnementV4[]|null
     */
    public function getAbonnement()
    {
        return $this->abonnement;
    }
    /**
     * Set abonnement value
     * @throws \InvalidArgumentException
     * @param \StructType\AbonnementV4[] $abonnement
     * @return \StructType\AbonnementTabV4
     */
    public function setAbonnement(array $abonnement = array())
    {
        foreach ($abonnement as $abonnementTabV4AbonnementItem) {
            // validation for constraint: itemType
            if (!$abonnementTabV4AbonnementItem instanceof \StructType\AbonnementV4) {
                throw new \InvalidArgumentException(sprintf('The abonnement property can only contain items of \StructType\AbonnementV4, "%s" given', is_object($abonnementTabV4AbonnementItem) ? get_class($abonnementTabV4AbonnementItem) : gettype($abonnementTabV4AbonnementItem)), __LINE__);
            }
        }
        $this->abonnement = $abonnement;
        return $this;
    }
    /**
     * Add item to abonnement value
     * @throws \InvalidArgumentException
     * @param \StructType\AbonnementV4 $item
     * @return \StructType\AbonnementTabV4
     */
    public function addToAbonnement(\StructType\AbonnementV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AbonnementV4) {
            throw new \InvalidArgumentException(sprintf('The abonnement property can only contain items of \StructType\AbonnementV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->abonnement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbonnementTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
