<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abonnements pakket object
 * @subpackage Structs
 */
class AboPakketV4 extends AbstractStructBase
{
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van het pakket.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 120
     * @var string
     */
    public $pakketNaam;
    /**
     * The pakketActief
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie actief.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $pakketActief;
    /**
     * The totaalPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal prijs inclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $totaalPrijsInclBtw;
    /**
     * The totaalPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal prijs exclusief BTW.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $totaalPrijsExclBtw;
    /**
     * The aboSoorten
     * Meta informations extracted from the WSDL
     * - documentation: Onderliggende abonnementsoorten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AboPakketAboSoortInfoV4
     */
    public $aboSoorten;
    /**
     * The aanvProducten
     * Meta informations extracted from the WSDL
     * - documentation: Onderliggende aanvullende producten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AboPakketAanvProdInfoV4
     */
    public $aanvProducten;
    /**
     * Constructor method for AboPakketV4
     * @uses AboPakketV4::setPakketCode()
     * @uses AboPakketV4::setPakketNaam()
     * @uses AboPakketV4::setPakketActief()
     * @uses AboPakketV4::setTotaalPrijsInclBtw()
     * @uses AboPakketV4::setTotaalPrijsExclBtw()
     * @uses AboPakketV4::setAboSoorten()
     * @uses AboPakketV4::setAanvProducten()
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param bool $pakketActief
     * @param float $totaalPrijsInclBtw
     * @param float $totaalPrijsExclBtw
     * @param \StructType\AboPakketAboSoortInfoV4 $aboSoorten
     * @param \StructType\AboPakketAanvProdInfoV4 $aanvProducten
     */
    public function __construct($pakketCode = null, $pakketNaam = null, $pakketActief = null, $totaalPrijsInclBtw = null, $totaalPrijsExclBtw = null, \StructType\AboPakketAboSoortInfoV4 $aboSoorten = null, \StructType\AboPakketAanvProdInfoV4 $aanvProducten = null)
    {
        $this
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPakketActief($pakketActief)
            ->setTotaalPrijsInclBtw($totaalPrijsInclBtw)
            ->setTotaalPrijsExclBtw($totaalPrijsExclBtw)
            ->setAboSoorten($aboSoorten)
            ->setAanvProducten($aanvProducten);
    }
    /**
     * Get pakketCode value
     * @return string
     */
    public function getPakketCode()
    {
        return $this->pakketCode;
    }
    /**
     * Set pakketCode value
     * @param string $pakketCode
     * @return \StructType\AboPakketV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) > 20) || (is_array($pakketCode) && count($pakketCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pakketCode) ? strlen($pakketCode) : count($pakketCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pakketCode) && strlen($pakketCode) < 1) || (is_array($pakketCode) && count($pakketCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketCode)), __LINE__);
        }
        $this->pakketCode = $pakketCode;
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \StructType\AboPakketV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketNaam) && strlen($pakketNaam) > 120) || (is_array($pakketNaam) && count($pakketNaam) > 120)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 120 element(s) or a scalar of 120 character(s) at most, "%d" length given', is_scalar($pakketNaam) ? strlen($pakketNaam) : count($pakketNaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get pakketActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPakketActief()
    {
        return isset($this->pakketActief) ? $this->pakketActief : null;
    }
    /**
     * Set pakketActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pakketActief
     * @return \StructType\AboPakketV4
     */
    public function setPakketActief($pakketActief = null)
    {
        if (is_null($pakketActief) || (is_array($pakketActief) && empty($pakketActief))) {
            unset($this->pakketActief);
        } else {
            $this->pakketActief = $pakketActief;
        }
        return $this;
    }
    /**
     * Get totaalPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotaalPrijsInclBtw()
    {
        return isset($this->totaalPrijsInclBtw) ? $this->totaalPrijsInclBtw : null;
    }
    /**
     * Set totaalPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totaalPrijsInclBtw
     * @return \StructType\AboPakketV4
     */
    public function setTotaalPrijsInclBtw($totaalPrijsInclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($totaalPrijsInclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $totaalPrijsInclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($totaalPrijsInclBtw, strpos($totaalPrijsInclBtw, '.')))), __LINE__);
        }
        if (is_null($totaalPrijsInclBtw) || (is_array($totaalPrijsInclBtw) && empty($totaalPrijsInclBtw))) {
            unset($this->totaalPrijsInclBtw);
        } else {
            $this->totaalPrijsInclBtw = $totaalPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get totaalPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotaalPrijsExclBtw()
    {
        return isset($this->totaalPrijsExclBtw) ? $this->totaalPrijsExclBtw : null;
    }
    /**
     * Set totaalPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totaalPrijsExclBtw
     * @return \StructType\AboPakketV4
     */
    public function setTotaalPrijsExclBtw($totaalPrijsExclBtw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($totaalPrijsExclBtw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $totaalPrijsExclBtw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($totaalPrijsExclBtw, strpos($totaalPrijsExclBtw, '.')))), __LINE__);
        }
        if (is_null($totaalPrijsExclBtw) || (is_array($totaalPrijsExclBtw) && empty($totaalPrijsExclBtw))) {
            unset($this->totaalPrijsExclBtw);
        } else {
            $this->totaalPrijsExclBtw = $totaalPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get aboSoorten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AboPakketAboSoortInfoV4|null
     */
    public function getAboSoorten()
    {
        return isset($this->aboSoorten) ? $this->aboSoorten : null;
    }
    /**
     * Set aboSoorten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AboPakketAboSoortInfoV4 $aboSoorten
     * @return \StructType\AboPakketV4
     */
    public function setAboSoorten(\StructType\AboPakketAboSoortInfoV4 $aboSoorten = null)
    {
        if (is_null($aboSoorten) || (is_array($aboSoorten) && empty($aboSoorten))) {
            unset($this->aboSoorten);
        } else {
            $this->aboSoorten = $aboSoorten;
        }
        return $this;
    }
    /**
     * Get aanvProducten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AboPakketAanvProdInfoV4|null
     */
    public function getAanvProducten()
    {
        return isset($this->aanvProducten) ? $this->aanvProducten : null;
    }
    /**
     * Set aanvProducten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AboPakketAanvProdInfoV4 $aanvProducten
     * @return \StructType\AboPakketV4
     */
    public function setAanvProducten(\StructType\AboPakketAanvProdInfoV4 $aanvProducten = null)
    {
        if (is_null($aanvProducten) || (is_array($aanvProducten) && empty($aanvProducten))) {
            unset($this->aanvProducten);
        } else {
            $this->aanvProducten = $aanvProducten;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AboPakketV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
