<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met gevonden abonnements pakketten.
 * @subpackage Structs
 */
class AboPakketInfoV4 extends AbstractStructBase
{
    /**
     * The aboPakket
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met gevonden abonnements pakketten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AboPakketV4[]
     */
    public $aboPakket;
    /**
     * Constructor method for AboPakketInfoV4
     * @uses AboPakketInfoV4::setAboPakket()
     * @param \StructType\AboPakketV4[] $aboPakket
     */
    public function __construct(array $aboPakket = array())
    {
        $this
            ->setAboPakket($aboPakket);
    }
    /**
     * Get aboPakket value
     * @return \StructType\AboPakketV4[]|null
     */
    public function getAboPakket()
    {
        return $this->aboPakket;
    }
    /**
     * Set aboPakket value
     * @throws \InvalidArgumentException
     * @param \StructType\AboPakketV4[] $aboPakket
     * @return \StructType\AboPakketInfoV4
     */
    public function setAboPakket(array $aboPakket = array())
    {
        foreach ($aboPakket as $aboPakketInfoV4AboPakketItem) {
            // validation for constraint: itemType
            if (!$aboPakketInfoV4AboPakketItem instanceof \StructType\AboPakketV4) {
                throw new \InvalidArgumentException(sprintf('The aboPakket property can only contain items of \StructType\AboPakketV4, "%s" given', is_object($aboPakketInfoV4AboPakketItem) ? get_class($aboPakketInfoV4AboPakketItem) : gettype($aboPakketInfoV4AboPakketItem)), __LINE__);
            }
        }
        $this->aboPakket = $aboPakket;
        return $this;
    }
    /**
     * Add item to aboPakket value
     * @throws \InvalidArgumentException
     * @param \StructType\AboPakketV4 $item
     * @return \StructType\AboPakketInfoV4
     */
    public function addToAboPakket(\StructType\AboPakketV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AboPakketV4) {
            throw new \InvalidArgumentException(sprintf('The aboPakket property can only contain items of \StructType\AboPakketV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->aboPakket[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AboPakketInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
