<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wijk ServiceType
 * @subpackage Services
 */
class Wijk extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named wijkCheck
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Controleert of er een levering mogelijk is voor de uitgave/abonnementsoort/pakket op het opgegeven adres.error182: De combinatie postcode/huisnummer is ongeldigerror183: De uitgave code is ongeldigerror184: De abonnementsoort code is
     * ongeldig of niet gekoppeld aan een uitgaveerror185: De pakketcode is ongeldig of er zijn geen gekoppelde uitgavenerror186: De postcode dient te bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletterserror187: Het huisnummer dient geheel te
     * bestaan uit cijferserror188: Teveel parameters tegelijk ingevuld, kies uitgave of abonnementsoort of pakketerror256: De propositie is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WijkCheckRequest $request_parameters
     * @return \StructType\WijkCheckResponse|bool
     */
    public function wijkCheck(\StructType\WijkCheckRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->wijkCheck($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WijkCheckResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
