<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named setOptInOut
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Bij een bestaande relatie de indicatie uitsluiten voor mailing of enquete aan- of uitzetten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOptInOutRequest $request_parameters
     * @return \StructType\SetOptInOutResponse|bool
     */
    public function setOptInOut(\StructType\SetOptInOutRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->setOptInOut($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetOptInOutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
