<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named checkProefabo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Met deze webservice kan worden gecontroleerd of een relatie (obv zijn gegeven e-mail adres of postcode/huisnummer/toevoeging combinatie) al een proefabonnement heeft gehad dat gestart is binnen de afgelopen x maanden. Deze periode is
     * op te geven in de Zeno constantenkaart.error1: Controle op eerdere proefabonnementen staat niet aan.error2: Ongeldige uitgavecode meegegeven.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckProefaboRequest $request_parameters
     * @return \StructType\CheckProefaboResponse|bool
     */
    public function checkProefabo(\StructType\CheckProefaboRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkProefabo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckProefaboResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
