<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bestaat ServiceType
 * @subpackage Services
 */
class Bestaat extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named bestaatActiefAbonnement
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : authentication
     * - SOAPHeaderNamespaces : http://zeno.socho.nl
     * - SOAPHeaderTypes : \StructType\Authentication
     * - SOAPHeaders : required
     * - documentation: Check op een adres in combinatie met achternaam of daar al een actief abonnement aanwezig is. Deze controle houdt alleen rekening met nederlandse adressen.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BestaatActiefAbonnementRequest $request_parameters
     * @return \StructType\BestaatActiefAbonnementResponse|bool
     */
    public function bestaatActiefAbonnement(\StructType\BestaatActiefAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->bestaatActiefAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BestaatActiefAbonnementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
