<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerschInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Verschijning.
 * @subpackage Structs
 */
class VerschInfoV4 extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsnummer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The nabezorgTermijn
     * Meta informations extracted from the WSDL
     * - documentation: Aantal dagen terug dat nabezorgd kan worden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $nabezorgTermijn;
    /**
     * The startBezorgingDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum start bezorging.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startBezorgingDatum;
    /**
     * The startBezorgingTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd start bezorging.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $startBezorgingTijd;
    /**
     * The bezorgdVanafDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum vanaf wanneer de verschijning in ieder geval bezorgd moet zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bezorgdVanafDatum;
    /**
     * The bezorgdVanafTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd vanaf wanneer de verschijning in ieder geval bezorgd moet zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $bezorgdVanafTijd;
    /**
     * The nabezZelfDagMogTotDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum (van vandaag) met de datum tot wanneer het vandaag mogelijk is een nabezorging geleverd te krijgen. Daarna wordt de volgende bezorgdag nabezorgd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nabezZelfDagMogTotDatum;
    /**
     * The nabezZelfDagMogTotTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd tot wanneer het vandaag mogelijk is een nabezorging geleverd te krijgen. Daarna wordt de volgende bezorgdag nabezorgd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $nabezZelfDagMogTotTijd;
    /**
     * The nabezMogTotDatum
     * Meta informations extracted from the WSDL
     * - documentation: Datum (van vandaag) met uiterste tijdstip om nog nabezorging te kunnen krijgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nabezMogTotDatum;
    /**
     * The nabezMogTotTijd
     * Meta informations extracted from the WSDL
     * - documentation: Tijd met uiterste tijdstip om nog nabezorging te kunnen krijgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $nabezMogTotTijd;
    /**
     * Constructor method for VerschInfoV4
     * @uses VerschInfoV4::setAboNo()
     * @uses VerschInfoV4::setNabezorgTermijn()
     * @uses VerschInfoV4::setStartBezorgingDatum()
     * @uses VerschInfoV4::setStartBezorgingTijd()
     * @uses VerschInfoV4::setBezorgdVanafDatum()
     * @uses VerschInfoV4::setBezorgdVanafTijd()
     * @uses VerschInfoV4::setNabezZelfDagMogTotDatum()
     * @uses VerschInfoV4::setNabezZelfDagMogTotTijd()
     * @uses VerschInfoV4::setNabezMogTotDatum()
     * @uses VerschInfoV4::setNabezMogTotTijd()
     * @param int $aboNo
     * @param int $nabezorgTermijn
     * @param string $startBezorgingDatum
     * @param string $startBezorgingTijd
     * @param string $bezorgdVanafDatum
     * @param string $bezorgdVanafTijd
     * @param string $nabezZelfDagMogTotDatum
     * @param string $nabezZelfDagMogTotTijd
     * @param string $nabezMogTotDatum
     * @param string $nabezMogTotTijd
     */
    public function __construct($aboNo = null, $nabezorgTermijn = null, $startBezorgingDatum = null, $startBezorgingTijd = null, $bezorgdVanafDatum = null, $bezorgdVanafTijd = null, $nabezZelfDagMogTotDatum = null, $nabezZelfDagMogTotTijd = null, $nabezMogTotDatum = null, $nabezMogTotTijd = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setNabezorgTermijn($nabezorgTermijn)
            ->setStartBezorgingDatum($startBezorgingDatum)
            ->setStartBezorgingTijd($startBezorgingTijd)
            ->setBezorgdVanafDatum($bezorgdVanafDatum)
            ->setBezorgdVanafTijd($bezorgdVanafTijd)
            ->setNabezZelfDagMogTotDatum($nabezZelfDagMogTotDatum)
            ->setNabezZelfDagMogTotTijd($nabezZelfDagMogTotTijd)
            ->setNabezMogTotDatum($nabezMogTotDatum)
            ->setNabezMogTotTijd($nabezMogTotTijd);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \StructType\VerschInfoV4
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNo, strpos($aboNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNo) && !is_numeric($aboNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNo)), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get nabezorgTermijn value
     * @return int
     */
    public function getNabezorgTermijn()
    {
        return $this->nabezorgTermijn;
    }
    /**
     * Set nabezorgTermijn value
     * @param int $nabezorgTermijn
     * @return \StructType\VerschInfoV4
     */
    public function setNabezorgTermijn($nabezorgTermijn = null)
    {
        // validation for constraint: totalDigits
        if (is_float($nabezorgTermijn) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $nabezorgTermijn)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($nabezorgTermijn, strpos($nabezorgTermijn, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($nabezorgTermijn) && !is_numeric($nabezorgTermijn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nabezorgTermijn)), __LINE__);
        }
        $this->nabezorgTermijn = $nabezorgTermijn;
        return $this;
    }
    /**
     * Get startBezorgingDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartBezorgingDatum()
    {
        return isset($this->startBezorgingDatum) ? $this->startBezorgingDatum : null;
    }
    /**
     * Set startBezorgingDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startBezorgingDatum
     * @return \StructType\VerschInfoV4
     */
    public function setStartBezorgingDatum($startBezorgingDatum = null)
    {
        // validation for constraint: string
        if (!is_null($startBezorgingDatum) && !is_string($startBezorgingDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startBezorgingDatum)), __LINE__);
        }
        if (is_null($startBezorgingDatum) || (is_array($startBezorgingDatum) && empty($startBezorgingDatum))) {
            unset($this->startBezorgingDatum);
        } else {
            $this->startBezorgingDatum = $startBezorgingDatum;
        }
        return $this;
    }
    /**
     * Get startBezorgingTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartBezorgingTijd()
    {
        return isset($this->startBezorgingTijd) ? $this->startBezorgingTijd : null;
    }
    /**
     * Set startBezorgingTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startBezorgingTijd
     * @return \StructType\VerschInfoV4
     */
    public function setStartBezorgingTijd($startBezorgingTijd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($startBezorgingTijd) && strlen($startBezorgingTijd) > 4000) || (is_array($startBezorgingTijd) && count($startBezorgingTijd) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($startBezorgingTijd) ? strlen($startBezorgingTijd) : count($startBezorgingTijd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startBezorgingTijd) && !is_string($startBezorgingTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startBezorgingTijd)), __LINE__);
        }
        if (is_null($startBezorgingTijd) || (is_array($startBezorgingTijd) && empty($startBezorgingTijd))) {
            unset($this->startBezorgingTijd);
        } else {
            $this->startBezorgingTijd = $startBezorgingTijd;
        }
        return $this;
    }
    /**
     * Get bezorgdVanafDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBezorgdVanafDatum()
    {
        return isset($this->bezorgdVanafDatum) ? $this->bezorgdVanafDatum : null;
    }
    /**
     * Set bezorgdVanafDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bezorgdVanafDatum
     * @return \StructType\VerschInfoV4
     */
    public function setBezorgdVanafDatum($bezorgdVanafDatum = null)
    {
        // validation for constraint: string
        if (!is_null($bezorgdVanafDatum) && !is_string($bezorgdVanafDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bezorgdVanafDatum)), __LINE__);
        }
        if (is_null($bezorgdVanafDatum) || (is_array($bezorgdVanafDatum) && empty($bezorgdVanafDatum))) {
            unset($this->bezorgdVanafDatum);
        } else {
            $this->bezorgdVanafDatum = $bezorgdVanafDatum;
        }
        return $this;
    }
    /**
     * Get bezorgdVanafTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBezorgdVanafTijd()
    {
        return isset($this->bezorgdVanafTijd) ? $this->bezorgdVanafTijd : null;
    }
    /**
     * Set bezorgdVanafTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bezorgdVanafTijd
     * @return \StructType\VerschInfoV4
     */
    public function setBezorgdVanafTijd($bezorgdVanafTijd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bezorgdVanafTijd) && strlen($bezorgdVanafTijd) > 10) || (is_array($bezorgdVanafTijd) && count($bezorgdVanafTijd) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($bezorgdVanafTijd) ? strlen($bezorgdVanafTijd) : count($bezorgdVanafTijd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bezorgdVanafTijd) && !is_string($bezorgdVanafTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bezorgdVanafTijd)), __LINE__);
        }
        if (is_null($bezorgdVanafTijd) || (is_array($bezorgdVanafTijd) && empty($bezorgdVanafTijd))) {
            unset($this->bezorgdVanafTijd);
        } else {
            $this->bezorgdVanafTijd = $bezorgdVanafTijd;
        }
        return $this;
    }
    /**
     * Get nabezZelfDagMogTotDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezZelfDagMogTotDatum()
    {
        return isset($this->nabezZelfDagMogTotDatum) ? $this->nabezZelfDagMogTotDatum : null;
    }
    /**
     * Set nabezZelfDagMogTotDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezZelfDagMogTotDatum
     * @return \StructType\VerschInfoV4
     */
    public function setNabezZelfDagMogTotDatum($nabezZelfDagMogTotDatum = null)
    {
        // validation for constraint: string
        if (!is_null($nabezZelfDagMogTotDatum) && !is_string($nabezZelfDagMogTotDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nabezZelfDagMogTotDatum)), __LINE__);
        }
        if (is_null($nabezZelfDagMogTotDatum) || (is_array($nabezZelfDagMogTotDatum) && empty($nabezZelfDagMogTotDatum))) {
            unset($this->nabezZelfDagMogTotDatum);
        } else {
            $this->nabezZelfDagMogTotDatum = $nabezZelfDagMogTotDatum;
        }
        return $this;
    }
    /**
     * Get nabezZelfDagMogTotTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezZelfDagMogTotTijd()
    {
        return isset($this->nabezZelfDagMogTotTijd) ? $this->nabezZelfDagMogTotTijd : null;
    }
    /**
     * Set nabezZelfDagMogTotTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezZelfDagMogTotTijd
     * @return \StructType\VerschInfoV4
     */
    public function setNabezZelfDagMogTotTijd($nabezZelfDagMogTotTijd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nabezZelfDagMogTotTijd) && strlen($nabezZelfDagMogTotTijd) > 10) || (is_array($nabezZelfDagMogTotTijd) && count($nabezZelfDagMogTotTijd) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($nabezZelfDagMogTotTijd) ? strlen($nabezZelfDagMogTotTijd) : count($nabezZelfDagMogTotTijd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nabezZelfDagMogTotTijd) && !is_string($nabezZelfDagMogTotTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nabezZelfDagMogTotTijd)), __LINE__);
        }
        if (is_null($nabezZelfDagMogTotTijd) || (is_array($nabezZelfDagMogTotTijd) && empty($nabezZelfDagMogTotTijd))) {
            unset($this->nabezZelfDagMogTotTijd);
        } else {
            $this->nabezZelfDagMogTotTijd = $nabezZelfDagMogTotTijd;
        }
        return $this;
    }
    /**
     * Get nabezMogTotDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezMogTotDatum()
    {
        return isset($this->nabezMogTotDatum) ? $this->nabezMogTotDatum : null;
    }
    /**
     * Set nabezMogTotDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezMogTotDatum
     * @return \StructType\VerschInfoV4
     */
    public function setNabezMogTotDatum($nabezMogTotDatum = null)
    {
        // validation for constraint: string
        if (!is_null($nabezMogTotDatum) && !is_string($nabezMogTotDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nabezMogTotDatum)), __LINE__);
        }
        if (is_null($nabezMogTotDatum) || (is_array($nabezMogTotDatum) && empty($nabezMogTotDatum))) {
            unset($this->nabezMogTotDatum);
        } else {
            $this->nabezMogTotDatum = $nabezMogTotDatum;
        }
        return $this;
    }
    /**
     * Get nabezMogTotTijd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNabezMogTotTijd()
    {
        return isset($this->nabezMogTotTijd) ? $this->nabezMogTotTijd : null;
    }
    /**
     * Set nabezMogTotTijd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nabezMogTotTijd
     * @return \StructType\VerschInfoV4
     */
    public function setNabezMogTotTijd($nabezMogTotTijd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nabezMogTotTijd) && strlen($nabezMogTotTijd) > 10) || (is_array($nabezMogTotTijd) && count($nabezMogTotTijd) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($nabezMogTotTijd) ? strlen($nabezMogTotTijd) : count($nabezMogTotTijd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nabezMogTotTijd) && !is_string($nabezMogTotTijd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nabezMogTotTijd)), __LINE__);
        }
        if (is_null($nabezMogTotTijd) || (is_array($nabezMogTotTijd) && empty($nabezMogTotTijd))) {
            unset($this->nabezMogTotTijd);
        } else {
            $this->nabezMogTotTijd = $nabezMogTotTijd;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerschInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
