<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ToekMutInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met toekomstige mutaties, zoals bijvoorbeeld verhuizingen of vakantie regelingen.
 * @subpackage Structs
 */
class ToekMutInfoV4 extends AbstractStructBase
{
    /**
     * The toekomstigeMutatie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met toekomstige mutaties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ToekMutV4[]
     */
    public $toekomstigeMutatie;
    /**
     * Constructor method for ToekMutInfoV4
     * @uses ToekMutInfoV4::setToekomstigeMutatie()
     * @param \StructType\ToekMutV4[] $toekomstigeMutatie
     */
    public function __construct(array $toekomstigeMutatie = array())
    {
        $this
            ->setToekomstigeMutatie($toekomstigeMutatie);
    }
    /**
     * Get toekomstigeMutatie value
     * @return \StructType\ToekMutV4[]|null
     */
    public function getToekomstigeMutatie()
    {
        return $this->toekomstigeMutatie;
    }
    /**
     * Set toekomstigeMutatie value
     * @throws \InvalidArgumentException
     * @param \StructType\ToekMutV4[] $toekomstigeMutatie
     * @return \StructType\ToekMutInfoV4
     */
    public function setToekomstigeMutatie(array $toekomstigeMutatie = array())
    {
        foreach ($toekomstigeMutatie as $toekMutInfoV4ToekomstigeMutatieItem) {
            // validation for constraint: itemType
            if (!$toekMutInfoV4ToekomstigeMutatieItem instanceof \StructType\ToekMutV4) {
                throw new \InvalidArgumentException(sprintf('The toekomstigeMutatie property can only contain items of \StructType\ToekMutV4, "%s" given', is_object($toekMutInfoV4ToekomstigeMutatieItem) ? get_class($toekMutInfoV4ToekomstigeMutatieItem) : gettype($toekMutInfoV4ToekomstigeMutatieItem)), __LINE__);
            }
        }
        $this->toekomstigeMutatie = $toekomstigeMutatie;
        return $this;
    }
    /**
     * Add item to toekomstigeMutatie value
     * @throws \InvalidArgumentException
     * @param \StructType\ToekMutV4 $item
     * @return \StructType\ToekMutInfoV4
     */
    public function addToToekomstigeMutatie(\StructType\ToekMutV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ToekMutV4) {
            throw new \InvalidArgumentException(sprintf('The toekomstigeMutatie property can only contain items of \StructType\ToekMutV4, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->toekomstigeMutatie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ToekMutInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
