<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for switchAbonnementResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error1: Het abonnement is niet gevonden | error12: Er is geen abonnement opgegeven | error23: De premium voor de abonnee is niet gevonden | error33: Geef of een abonnementsoort- of een pakketcode op | error34: De actie is niet
 * gevonden | error36: De ingangsdatum van de actie is nog niet ingegaan | error56: De abonnementsoort is niet actief | error57: De actie is niet actief | error58: De premium voor de abonnee is niet actief | error88: Het opgegeven pakket is niet bekend
 * | error89: Het opgegeven pakket is niet actief | error91: De premium voor de debiteur is niet actief | error92: De abonnementsoort is niet bekend | error95: De ingangsdatum van de actie is nog niet ingegaan | error96: De einddatum van de actie is
 * verstreken | error97: De premium voor de abonnee is niet gekoppeld aan de propositie | error98: De premium voor de debiteur is niet gekoppeld aan de propositie | error127: De abonnementsoort is niet gekoppeld aan de actie | error128: Het pakket is
 * niet gekoppeld aan de actie | error131: Een betaalwijze anders dan incasso is niet toegestaan voor dit abonnement | error181: De stopreden is niet gevonden | error215: Het IBAN nummer is ongeldig | error216: De BIC code is ongeldig | error217: Bij
 * automatische incasso of eenmalige incasso is een IBAN nummer verplicht | error218: Het IBAN nummer dient samen met de BIC code opgegeven te worden | error219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error256: De proposie is
 * niet gevonden | error257: De propositie is niet actief | error258: Op basis van de opgegeven abosoort/pakket/propositiecode en actiecode zijn meerdere proposities gevonden | error259: De opgegeven vrije code 3 is niet bekend | error260: Een
 * propositiecode dient in combinatie met een actiecode opgegeven te worden | error261: De opgegeven vrije code 1 is niet bekend | error262: De opgegeven vrije code 2 is niet bekend | error263: De opgegeven vrije code 4 is niet bekend | error264: Bij
 * betaalwijze creditcard zijn gegevens van de creditcard verplicht | error265: Een betaalwijze anders dan factuur per mail is niet toegestaan voor dit abonnement
 * @subpackage Structs
 */
class SwitchAbonnementResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The aboIngangsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Ingangsdatum van het nieuwe abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboIngangsDatum;
    /**
     * The aboNoResult
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsnummer van het nieuwe abonnemet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNoResult;
    /**
     * The aboRelNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de abonnee van het nieuwe abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboRelNo;
    /**
     * The aboBedragNieuw
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag te betalen voor het nieuwe abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragNieuw;
    /**
     * The aboBedragOud
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag terug te ontvangen voor het oude abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragOud;
    /**
     * The aboBedragFactuur
     * Meta informations extracted from the WSDL
     * - documentation: Totaal te betalen bedrag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragFactuur;
    /**
     * The aboBedragAdmKosten
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag te betalen administratie kosten (future support).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboBedragAdmKosten;
    /**
     * The aboFactuurNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de aangemaakte factuur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 17
     * @var string
     */
    public $aboFactuurNummer;
    /**
     * The aboFactuurOnderdrukkenRslt
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de factuur wordt onderdrukt. Als in het request is aangegeven dat de factuur onderdrukt moet worden, maar er is een factuur zonder automatische incasso aangemaakt, dan komt hier alsnog een indicatie false, dus factuur
     * wordt verstuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboFactuurOnderdrukkenRslt;
    /**
     * The machtigingsKenmerk
     * Meta informations extracted from the WSDL
     * - documentation: Door Zeno aangemaakt machtigingskenmerk in geval van betaalwijze SEPA incasso.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 35
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * Constructor method for switchAbonnementResponse
     * @uses SwitchAbonnementResponse::setRequestTag()
     * @uses SwitchAbonnementResponse::setAboIngangsDatum()
     * @uses SwitchAbonnementResponse::setAboNoResult()
     * @uses SwitchAbonnementResponse::setAboRelNo()
     * @uses SwitchAbonnementResponse::setAboBedragNieuw()
     * @uses SwitchAbonnementResponse::setAboBedragOud()
     * @uses SwitchAbonnementResponse::setAboBedragFactuur()
     * @uses SwitchAbonnementResponse::setAboBedragAdmKosten()
     * @uses SwitchAbonnementResponse::setAboFactuurNummer()
     * @uses SwitchAbonnementResponse::setAboFactuurOnderdrukkenRslt()
     * @uses SwitchAbonnementResponse::setMachtigingsKenmerk()
     * @param string $requestTag
     * @param string $aboIngangsDatum
     * @param int $aboNoResult
     * @param int $aboRelNo
     * @param float $aboBedragNieuw
     * @param float $aboBedragOud
     * @param float $aboBedragFactuur
     * @param float $aboBedragAdmKosten
     * @param string $aboFactuurNummer
     * @param bool $aboFactuurOnderdrukkenRslt
     * @param string $machtigingsKenmerk
     */
    public function __construct($requestTag = null, $aboIngangsDatum = null, $aboNoResult = null, $aboRelNo = null, $aboBedragNieuw = null, $aboBedragOud = null, $aboBedragFactuur = null, $aboBedragAdmKosten = null, $aboFactuurNummer = null, $aboFactuurOnderdrukkenRslt = null, $machtigingsKenmerk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboIngangsDatum($aboIngangsDatum)
            ->setAboNoResult($aboNoResult)
            ->setAboRelNo($aboRelNo)
            ->setAboBedragNieuw($aboBedragNieuw)
            ->setAboBedragOud($aboBedragOud)
            ->setAboBedragFactuur($aboBedragFactuur)
            ->setAboBedragAdmKosten($aboBedragAdmKosten)
            ->setAboFactuurNummer($aboFactuurNummer)
            ->setAboFactuurOnderdrukkenRslt($aboFactuurOnderdrukkenRslt)
            ->setMachtigingsKenmerk($machtigingsKenmerk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboIngangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboIngangsDatum()
    {
        return isset($this->aboIngangsDatum) ? $this->aboIngangsDatum : null;
    }
    /**
     * Set aboIngangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboIngangsDatum
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboIngangsDatum($aboIngangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboIngangsDatum) && !is_string($aboIngangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboIngangsDatum)), __LINE__);
        }
        if (is_null($aboIngangsDatum) || (is_array($aboIngangsDatum) && empty($aboIngangsDatum))) {
            unset($this->aboIngangsDatum);
        } else {
            $this->aboIngangsDatum = $aboIngangsDatum;
        }
        return $this;
    }
    /**
     * Get aboNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNoResult()
    {
        return isset($this->aboNoResult) ? $this->aboNoResult : null;
    }
    /**
     * Set aboNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNoResult
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboNoResult($aboNoResult = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboNoResult) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboNoResult)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboNoResult, strpos($aboNoResult, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboNoResult) && !is_numeric($aboNoResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboNoResult)), __LINE__);
        }
        if (is_null($aboNoResult) || (is_array($aboNoResult) && empty($aboNoResult))) {
            unset($this->aboNoResult);
        } else {
            $this->aboNoResult = $aboNoResult;
        }
        return $this;
    }
    /**
     * Get aboRelNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboRelNo()
    {
        return isset($this->aboRelNo) ? $this->aboRelNo : null;
    }
    /**
     * Set aboRelNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboRelNo
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboRelNo($aboRelNo = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboRelNo) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboRelNo)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($aboRelNo, strpos($aboRelNo, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($aboRelNo) && !is_numeric($aboRelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aboRelNo)), __LINE__);
        }
        if (is_null($aboRelNo) || (is_array($aboRelNo) && empty($aboRelNo))) {
            unset($this->aboRelNo);
        } else {
            $this->aboRelNo = $aboRelNo;
        }
        return $this;
    }
    /**
     * Get aboBedragNieuw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragNieuw()
    {
        return isset($this->aboBedragNieuw) ? $this->aboBedragNieuw : null;
    }
    /**
     * Set aboBedragNieuw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragNieuw
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboBedragNieuw($aboBedragNieuw = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboBedragNieuw) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboBedragNieuw)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aboBedragNieuw, strpos($aboBedragNieuw, '.')))), __LINE__);
        }
        if (is_null($aboBedragNieuw) || (is_array($aboBedragNieuw) && empty($aboBedragNieuw))) {
            unset($this->aboBedragNieuw);
        } else {
            $this->aboBedragNieuw = $aboBedragNieuw;
        }
        return $this;
    }
    /**
     * Get aboBedragOud value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragOud()
    {
        return isset($this->aboBedragOud) ? $this->aboBedragOud : null;
    }
    /**
     * Set aboBedragOud value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragOud
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboBedragOud($aboBedragOud = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboBedragOud) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboBedragOud)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aboBedragOud, strpos($aboBedragOud, '.')))), __LINE__);
        }
        if (is_null($aboBedragOud) || (is_array($aboBedragOud) && empty($aboBedragOud))) {
            unset($this->aboBedragOud);
        } else {
            $this->aboBedragOud = $aboBedragOud;
        }
        return $this;
    }
    /**
     * Get aboBedragFactuur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragFactuur()
    {
        return isset($this->aboBedragFactuur) ? $this->aboBedragFactuur : null;
    }
    /**
     * Set aboBedragFactuur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragFactuur
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboBedragFactuur($aboBedragFactuur = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboBedragFactuur) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboBedragFactuur)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aboBedragFactuur, strpos($aboBedragFactuur, '.')))), __LINE__);
        }
        if (is_null($aboBedragFactuur) || (is_array($aboBedragFactuur) && empty($aboBedragFactuur))) {
            unset($this->aboBedragFactuur);
        } else {
            $this->aboBedragFactuur = $aboBedragFactuur;
        }
        return $this;
    }
    /**
     * Get aboBedragAdmKosten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboBedragAdmKosten()
    {
        return isset($this->aboBedragAdmKosten) ? $this->aboBedragAdmKosten : null;
    }
    /**
     * Set aboBedragAdmKosten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboBedragAdmKosten
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboBedragAdmKosten($aboBedragAdmKosten = null)
    {
        // validation for constraint: totalDigits
        if (is_float($aboBedragAdmKosten) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $aboBedragAdmKosten)) !== 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 38 digits, "%d" given', strlen(substr($aboBedragAdmKosten, strpos($aboBedragAdmKosten, '.')))), __LINE__);
        }
        if (is_null($aboBedragAdmKosten) || (is_array($aboBedragAdmKosten) && empty($aboBedragAdmKosten))) {
            unset($this->aboBedragAdmKosten);
        } else {
            $this->aboBedragAdmKosten = $aboBedragAdmKosten;
        }
        return $this;
    }
    /**
     * Get aboFactuurNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboFactuurNummer()
    {
        return isset($this->aboFactuurNummer) ? $this->aboFactuurNummer : null;
    }
    /**
     * Set aboFactuurNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboFactuurNummer
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboFactuurNummer($aboFactuurNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aboFactuurNummer) && strlen($aboFactuurNummer) > 17) || (is_array($aboFactuurNummer) && count($aboFactuurNummer) > 17)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 17 element(s) or a scalar of 17 character(s) at most, "%d" length given', is_scalar($aboFactuurNummer) ? strlen($aboFactuurNummer) : count($aboFactuurNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aboFactuurNummer) && !is_string($aboFactuurNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aboFactuurNummer)), __LINE__);
        }
        if (is_null($aboFactuurNummer) || (is_array($aboFactuurNummer) && empty($aboFactuurNummer))) {
            unset($this->aboFactuurNummer);
        } else {
            $this->aboFactuurNummer = $aboFactuurNummer;
        }
        return $this;
    }
    /**
     * Get aboFactuurOnderdrukkenRslt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboFactuurOnderdrukkenRslt()
    {
        return isset($this->aboFactuurOnderdrukkenRslt) ? $this->aboFactuurOnderdrukkenRslt : null;
    }
    /**
     * Set aboFactuurOnderdrukkenRslt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboFactuurOnderdrukkenRslt
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setAboFactuurOnderdrukkenRslt($aboFactuurOnderdrukkenRslt = null)
    {
        if (is_null($aboFactuurOnderdrukkenRslt) || (is_array($aboFactuurOnderdrukkenRslt) && empty($aboFactuurOnderdrukkenRslt))) {
            unset($this->aboFactuurOnderdrukkenRslt);
        } else {
            $this->aboFactuurOnderdrukkenRslt = $aboFactuurOnderdrukkenRslt;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \StructType\SwitchAbonnementResponse
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($machtigingsKenmerk) && strlen($machtigingsKenmerk) > 35) || (is_array($machtigingsKenmerk) && count($machtigingsKenmerk) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($machtigingsKenmerk) ? strlen($machtigingsKenmerk) : count($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SwitchAbonnementResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
