<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchRelNoByEmailResponse StructType
 * @subpackage Structs
 */
class SearchRelNoByEmailResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 4000
     * @var string
     */
    public $requestTag;
    /**
     * The relatieNummers
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met relatienummers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RelatieNummerObjectV4
     */
    public $relatieNummers;
    /**
     * Constructor method for searchRelNoByEmailResponse
     * @uses SearchRelNoByEmailResponse::setRequestTag()
     * @uses SearchRelNoByEmailResponse::setRelatieNummers()
     * @param string $requestTag
     * @param \StructType\RelatieNummerObjectV4 $relatieNummers
     */
    public function __construct($requestTag = null, \StructType\RelatieNummerObjectV4 $relatieNummers = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatieNummers($relatieNummers);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \StructType\SearchRelNoByEmailResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestTag) && strlen($requestTag) > 4000) || (is_array($requestTag) && count($requestTag) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($requestTag) ? strlen($requestTag) : count($requestTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatieNummers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RelatieNummerObjectV4|null
     */
    public function getRelatieNummers()
    {
        return isset($this->relatieNummers) ? $this->relatieNummers : null;
    }
    /**
     * Set relatieNummers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RelatieNummerObjectV4 $relatieNummers
     * @return \StructType\SearchRelNoByEmailResponse
     */
    public function setRelatieNummers(\StructType\RelatieNummerObjectV4 $relatieNummers = null)
    {
        if (is_null($relatieNummers) || (is_array($relatieNummers) && empty($relatieNummers))) {
            unset($this->relatieNummers);
        } else {
            $this->relatieNummers = $relatieNummers;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchRelNoByEmailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
